/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.PrepareForReplaceVisitor;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.ui.IWorkbenchPart;

public class ReplaceOperation
extends UpdateOperation {
    boolean recurse = true;

    public ReplaceOperation(IWorkbenchPart part, IResource[] resources, CVSTag tag, boolean recurse) {
        super(part, resources, ReplaceOperation.getReplaceOptions(recurse), tag);
        this.recurse = recurse;
    }

    private static Command.LocalOption[] getReplaceOptions(boolean recurse) {
        ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>();
        options.add(Update.IGNORE_LOCAL_CHANGES);
        if (!recurse) {
            options.add(Command.DO_NOT_RECURSE);
        }
        return options.toArray(new Command.LocalOption[options.size()]);
    }

    protected String getTaskName() {
        return Policy.bind("ReplaceOperation.taskName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 100);
        ICVSResource[] managedResources = this.getResourcesToUpdate(resources);
        try {
            new PrepareForReplaceVisitor().visitResources(provider.getProject(), resources, "CVSTeamProvider.scrubbingResource", this.recurse ? 2 : 0, Policy.subMonitorFor(monitor, 30));
            IStatus status = OK;
            if (managedResources.length > 0) {
                status = super.executeCommand(session, provider, managedResources, Policy.subMonitorFor(monitor, 70));
            }
            if (status.isOK() && CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                new PruneFolderVisitor().visit(session, resources);
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected ICVSResource[] getResourcesToUpdate(ICVSResource[] resources) throws CVSException {
        ArrayList<ICVSResource> managedResources = new ArrayList<ICVSResource>();
        for (int i = 0; i < resources.length; ++i) {
            byte[] syncBytes;
            ICVSResource resource = resources[i];
            if (resource.isFolder() && ((ICVSFolder)resource).isCVSFolder()) {
                managedResources.add(resource);
                continue;
            }
            if (resource.isFolder() || (syncBytes = ((ICVSFile)resource).getSyncBytes()) == null || ResourceSyncInfo.isAddition((byte[])syncBytes)) continue;
            managedResources.add(resource);
        }
        return managedResources.toArray(new ICVSResource[managedResources.size()]);
    }

    protected Update getUpdateCommand() {
        return Command.REPLACE;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("ReplaceOperation.0", provider.getProject().getName());
    }
}

