/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.TextActionHandler;

public class RefactorActionGroup
extends ActionGroup {
    private MoveResourceAction moveAction;
    private RenameResourceAction renameAction;
    private TextActionHandler textActionHandler;
    private ISynchronizePageSite site;
    private DeleteResourceAction deleteAction;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public RefactorActionGroup(ISynchronizePageSite site) {
        this.site = site;
        this.makeActions();
    }

    public void fillContextMenu(IMenuManager parentMenu, String groupId) {
        IStructuredSelection selection = this.getSelection();
        if (selection == null) {
            return;
        }
        boolean anyResourceSelected = !selection.isEmpty() && this.allResourcesAreOfType(selection, 7);
        MenuManager menu = new MenuManager(Policy.bind("RefactorActionGroup.0"));
        IStructuredSelection convertedSelection = this.convertSelection(selection);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(convertedSelection);
            menu.add((IAction)this.deleteAction);
            this.moveAction.selectionChanged(convertedSelection);
            menu.add((IAction)this.moveAction);
            this.renameAction.selectionChanged(convertedSelection);
            menu.add((IAction)this.renameAction);
        }
        parentMenu.appendToGroup(groupId, (IContributionItem)menu);
    }

    private IStructuredSelection convertSelection(IStructuredSelection selection) {
        return new StructuredSelection((Object[])Utils.getResources(selection.toArray()));
    }

    public void fillActionBars(IActionBars actionBars) {
        this.textActionHandler = new TextActionHandler(actionBars);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        this.deleteAction.selectionChanged(this.getSelection());
    }

    protected void makeActions() {
        Shell shell = this.site.getShell();
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.moveAction = new MoveResourceAction(shell);
        this.renameAction = new RenameResourceAction(shell);
        this.deleteAction = new DeleteResourceAction(shell){

            protected List getSelectedResources() {
                return Arrays.asList(Utils.getResources(RefactorActionGroup.this.getSelection().toArray()));
            }
        };
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        IKeyBindingService keyBindingService = this.site.getKeyBindingService();
        if (keyBindingService != null) {
            keyBindingService.registerAction((IAction)this.deleteAction);
        }
    }

    public void dispose() {
        IKeyBindingService keyBindingService;
        if (this.deleteAction != null && (keyBindingService = this.site.getKeyBindingService()) != null) {
            keyBindingService.unregisterAction((IAction)this.deleteAction);
        }
        super.dispose();
    }

    public void updateActionBars() {
        IStructuredSelection selection = this.getSelection();
        this.deleteAction.selectionChanged(selection);
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.site.getSelectionProvider().getSelection();
    }

    private boolean allResourcesAreOfType(IStructuredSelection selection, int resourceMask) {
        Iterator resources = selection.iterator();
        while (resources.hasNext()) {
            IResource[] r;
            Object next = resources.next();
            IResource resource = null;
            if (next instanceof IResource) {
                resource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)next;
                resource = (IResource)adaptable.getAdapter(class$org$eclipse$core$resources$IResource == null ? RefactorActionGroup.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            }
            if (resource == null && (r = Utils.getResources(new Object[]{next})).length == 1) {
                resource = r[0];
            }
            if (resource != null && (resource.getType() & resourceMask) != 0) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

