/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.model;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;

public class WorkbenchContentProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener {
    private Viewer viewer;

    public void dispose() {
        if (this.viewer != null) {
            IWorkspace workspace = null;
            Object obj = this.viewer.getInput();
            if (obj instanceof IWorkspace) {
                workspace = (IWorkspace)obj;
            } else if (obj instanceof IContainer) {
                workspace = ((IContainer)obj).getWorkspace();
            }
            if (workspace != null) {
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        final IResourceDelta delta = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                public void run() {
                    WorkbenchContentProvider.this.processDelta(delta);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        for (int i = 0; i < affectedChildren.length; ++i) {
            if ((affectedChildren[i].getFlags() & 0x8000) == 0) continue;
            ((StructuredViewer)this.viewer).refresh((Object)resource);
            return;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x14000) != 0) {
            ((StructuredViewer)this.viewer).update((Object)resource, null);
        }
        if ((changeFlags & 0x40000) != 0) {
            ((StructuredViewer)this.viewer).refresh((Object)resource, true);
            return;
        }
        for (int i = 0; i < affectedChildren.length; ++i) {
            this.processDelta(affectedChildren[i]);
        }
        boolean addedAndRemoved = false;
        try {
            int i;
            Object[] affected;
            IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
            IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
            addedAndRemoved = addedChildren.length > 0 & removedChildren.length > 0;
            if (addedAndRemoved) {
                this.viewer.getControl().setRedraw(false);
            }
            if (addedChildren.length > 0) {
                affected = new Object[addedChildren.length];
                for (i = 0; i < addedChildren.length; ++i) {
                    affected[i] = addedChildren[i].getResource();
                }
                if (this.viewer instanceof AbstractTreeViewer) {
                    ((AbstractTreeViewer)this.viewer).add((Object)resource, affected);
                } else {
                    ((StructuredViewer)this.viewer).refresh((Object)resource);
                }
            }
            if (removedChildren.length > 0) {
                affected = new Object[removedChildren.length];
                for (i = 0; i < removedChildren.length; ++i) {
                    affected[i] = removedChildren[i].getResource();
                }
                if (this.viewer instanceof AbstractTreeViewer) {
                    ((AbstractTreeViewer)this.viewer).remove(affected);
                } else {
                    ((StructuredViewer)this.viewer).refresh((Object)resource);
                }
            }
        }
        finally {
            if (addedAndRemoved) {
                this.viewer.getControl().setRedraw(true);
            }
        }
    }
}

