/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.framelist;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.FrameListMessages;

public class BackAction
extends FrameAction {
    public BackAction(FrameList frameList) {
        super(frameList);
        this.setText(FrameListMessages.getString("Back.text"));
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.back_action_context");
        this.update();
    }

    private Frame getPreviousFrame() {
        FrameList list = this.getFrameList();
        return list.getFrame(list.getCurrentIndex() - 1);
    }

    private String getToolTipText(Frame previousFrame) {
        String text;
        if (previousFrame != null && (text = previousFrame.getToolTipText()) != null && text.length() > 0) {
            return FrameListMessages.format("Back.toolTipOneArg", new Object[]{text});
        }
        return FrameListMessages.getString("Back.toolTip");
    }

    public void run() {
        this.getFrameList().back();
    }

    public void update() {
        super.update();
        Frame previousFrame = this.getPreviousFrame();
        this.setEnabled(previousFrame != null);
        this.setToolTipText(this.getToolTipText(previousFrame));
    }
}

