/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.EditVariableEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.JavadocLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewVariableEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public final class BuildPathDialogAccess {
    static /* synthetic */ Class class$org$eclipse$core$resources$IFile;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IFolder;

    private BuildPathDialogAccess() {
    }

    public static IClasspathEntry configureSourceAttachment(Shell shell, IClasspathEntry initialEntry) {
        int entryKind = initialEntry.getEntryKind();
        if (initialEntry == null || entryKind != 1 && entryKind != 4) {
            throw new IllegalArgumentException();
        }
        SourceAttachmentDialog dialog = new SourceAttachmentDialog(shell, initialEntry);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static URL[] configureJavadocLocation(Shell shell, String libraryName, URL initialURL) {
        if (libraryName == null) {
            throw new IllegalArgumentException();
        }
        JavadocLocationDialog dialog = new JavadocLocationDialog(shell, libraryName, initialURL);
        if (dialog.open() == 0) {
            return new URL[]{dialog.getResult()};
        }
        return null;
    }

    public static IPath configureVariableEntry(Shell shell, IPath initialEntryPath, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        EditVariableEntryDialog dialog = new EditVariableEntryDialog(shell, initialEntryPath, existingPaths);
        if (dialog.open() == 0) {
            return dialog.getPath();
        }
        return null;
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        NewVariableEntryDialog dialog = new NewVariableEntryDialog(shell);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static IClasspathEntry configureContainerEntry(Shell shell, IClasspathEntry initialEntry, IJavaProject project, IClasspathEntry[] currentClasspath) {
        IClasspathEntry[] created;
        if (initialEntry == null || currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        ClasspathContainerWizard wizard = new ClasspathContainerWizard(initialEntry, project, currentClasspath);
        if (ClasspathContainerWizard.openWizard(shell, wizard) == 0 && (created = wizard.getNewEntries()) != null && created.length == 1) {
            return created[0];
        }
        return null;
    }

    public static IClasspathEntry[] chooseContainerEntries(Shell shell, IJavaProject project, IClasspathEntry[] currentClasspath) {
        if (currentClasspath == null) {
            throw new IllegalArgumentException();
        }
        ClasspathContainerWizard wizard = new ClasspathContainerWizard((IClasspathEntry)null, project, currentClasspath);
        if (ClasspathContainerWizard.openWizard(shell, wizard) == 0) {
            return wizard.getNewEntries();
        }
        return null;
    }

    public static IPath configureJAREntry(Shell shell, IPath initialEntry, IPath[] usedEntries) {
        if (initialEntry == null || usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = BuildPathDialogAccess.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < usedEntries.length; ++i) {
            IResource resource;
            IPath curr = usedEntries[i];
            if (curr.equals(initialEntry) || !((resource = root.findMember(usedEntries[i])) instanceof IFile)) continue;
            usedJars.add(resource);
        }
        IResource existing = root.findMember(initialEntry);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.getString("BuildPathDialogAccess.JARArchiveDialog.edit.title"));
        dialog.setMessage(NewWizardMessages.getString("BuildPathDialogAccess.JARArchiveDialog.edit.description"));
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelection((Object)existing);
        if (dialog.open() == 0) {
            IResource element = (IResource)dialog.getFirstResult();
            return element.getFullPath();
        }
        return null;
    }

    public static IPath[] chooseJAREntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        Class[] acceptedClasses = new Class[]{class$org$eclipse$core$resources$IFile == null ? (class$org$eclipse$core$resources$IFile = BuildPathDialogAccess.class$("org.eclipse.core.resources.IFile")) : class$org$eclipse$core$resources$IFile};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        ArrayList<IResource> usedJars = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < usedEntries.length; ++i) {
            IResource resource = root.findMember(usedEntries[i]);
            if (!(resource instanceof IFile)) continue;
            usedJars.add(resource);
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(NewWizardMessages.getString("BuildPathDialogAccess.JARArchiveDialog.new.title"));
        dialog.setMessage(NewWizardMessages.getString("BuildPathDialogAccess.JARArchiveDialog.new.description"));
        dialog.addFilter((ViewerFilter)new ArchiveFileFilter(usedJars, true));
        dialog.setInput((Object)root);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelection((Object)focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            for (int i = 0; i < res.length; ++i) {
                IResource elem = (IResource)elements[i];
                res[i] = elem.getFullPath();
            }
            return res;
        }
        return null;
    }

    public static IPath configureExternalJAREntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(NewWizardMessages.getString("BuildPathDialogAccess.ExtJARArchiveDialog.edit.title"));
        dialog.setFilterExtensions(ArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        dialog.setFileName(initialEntry.lastSegment());
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String fileNames = dialog.getFileName();
        Path filterPath = new Path(dialog.getFilterPath());
        JavaPlugin.getDefault().getDialogSettings().put("org.eclipse.jdt.ui.lastextjar", filterPath.toOSString());
        return filterPath.append(fileNames).makeAbsolute();
    }

    public static IPath[] chooseExternalJAREntries(Shell shell) {
        String lastUsedPath = JavaPlugin.getDefault().getDialogSettings().get("org.eclipse.jdt.ui.lastextjar");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(NewWizardMessages.getString("BuildPathDialogAccess.ExtJARArchiveDialog.new.title"));
        dialog.setFilterExtensions(ArchiveFileFilter.FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        for (int i = 0; i < nChosen; ++i) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
        }
        JavaPlugin.getDefault().getDialogSettings().put("org.eclipse.jdt.ui.lastextjar", filterPath.toOSString());
        return elems;
    }

    public static IPath[] chooseClassFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.getString("BuildPathDialogAccess.ExistingClassFolderDialog.edit.title");
        String message = NewWizardMessages.getString("BuildPathDialogAccess.ExistingClassFolderDialog.edit.description");
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = NewWizardMessages.getString("BuildPathDialogAccess.ExistingSourceFolderDialog.edit.title");
        String message = NewWizardMessages.getString("BuildPathDialogAccess.ExistingSourceFolderDialog.edit.description");
        return BuildPathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message) {
        Class[] acceptedClasses = new Class[]{class$org$eclipse$core$resources$IProject == null ? (class$org$eclipse$core$resources$IProject = BuildPathDialogAccess.class$("org.eclipse.core.resources.IProject")) : class$org$eclipse$core$resources$IProject, class$org$eclipse$core$resources$IFolder == null ? (class$org$eclipse$core$resources$IFolder = BuildPathDialogAccess.class$("org.eclipse.core.resources.IFolder")) : class$org$eclipse$core$resources$IFolder};
        ArrayList<IResource> usedContainers = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < usedEntries.length; ++i) {
            IResource resource = root.findMember(usedEntries[i]);
            if (!(resource instanceof IContainer)) continue;
            usedContainers.add(resource);
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        Object[] used = usedContainers.toArray();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setExisting(used);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(new TypedViewerFilter(acceptedClasses, used));
        dialog.setInput(root);
        dialog.setInitialFocus(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            for (int i = 0; i < res.length; ++i) {
                IResource elem = (IResource)elements[i];
                res[i] = elem.getFullPath();
            }
            return res;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

