/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class URLCoder {
    public static String encode(String s) {
        try {
            return URLCoder.urlEncode(s.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public static String decode(String s) {
        try {
            return new String(URLCoder.urlDecode(s), "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    private static String urlEncode(byte[] data) {
        StringBuffer buf = new StringBuffer(data.length);
        for (int i = 0; i < data.length; ++i) {
            buf.append('%');
            buf.append(Character.forDigit((data[i] & 0xF0) >>> 4, 16));
            buf.append(Character.forDigit(data[i] & 0xF, 16));
        }
        return buf.toString();
    }

    private static byte[] urlDecode(String encodedURL) {
        int len = encodedURL.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(len);
        int i = 0;
        block4: while (i < len) {
            switch (encodedURL.charAt(i)) {
                case '%': {
                    if (len >= i + 3) {
                        os.write(Integer.parseInt(encodedURL.substring(i + 1, i + 3), 16));
                    }
                    i += 3;
                    continue block4;
                }
                case '+': {
                    os.write(32);
                    ++i;
                    continue block4;
                }
            }
            os.write(encodedURL.charAt(i++));
        }
        return os.toByteArray();
    }
}

