/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskListMessages;

class PurgeCompletedAction
extends TaskAction {
    public PurgeCompletedAction(TaskList tasklist, String id) {
        super(tasklist, id);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.purge_completed_task_action_context");
    }

    public void run() {
        try {
            IResource resource = this.getTaskList().getResource();
            int depth = this.getTaskList().getResourceDepth();
            IMarker[] tasks = resource.findMarkers("org.eclipse.core.resources.taskmarker", true, depth);
            ArrayList<IMarker> completed = new ArrayList<IMarker>();
            for (int i = 0; i < tasks.length; ++i) {
                IMarker task = tasks[i];
                if (!MarkerUtil.isComplete(task) || MarkerUtil.isReadOnly(task)) continue;
                completed.add(task);
            }
            if (completed.size() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TaskListMessages.getString("PurgeCompleted.title"), (String)TaskListMessages.getString("PurgeCompleted.noneCompleted"));
                return;
            }
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)TaskListMessages.getString("PurgeCompleted.title"), (String)TaskListMessages.format("PurgeCompleted.permanent", new Object[]{new Integer(completed.size())}))) {
                return;
            }
            IMarker[] toDelete = new IMarker[completed.size()];
            completed.toArray(toDelete);
            this.getTaskList().getWorkspace().deleteMarkers(toDelete);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.getString("PurgeCompleted.errorMessage"), null, (IStatus)e.getStatus());
        }
    }
}

