/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TextTemplateMessages;

public class TemplateTranslator {
    private static final int TEXT = 0;
    private static final int ESCAPE = 1;
    private static final int IDENTIFIER = 2;
    private static final char ESCAPE_CHARACTER = '$';
    private static final char IDENTIFIER_BEGIN = '{';
    private static final char IDENTIFIER_END = '}';
    private final StringBuffer fBuffer = new StringBuffer();
    private final Vector fOffsets = new Vector();
    private final Vector fLengths = new Vector();
    private int fState;
    private String fErrorMessage;

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public TemplateBuffer translate(Template template) throws TemplateException {
        return this.translate(template.getPattern());
    }

    public TemplateBuffer translate(String string) throws TemplateException {
        this.fBuffer.setLength(0);
        this.fOffsets.clear();
        this.fLengths.clear();
        this.fState = 0;
        this.fErrorMessage = null;
        if (!this.parse(string)) {
            throw new TemplateException(this.fErrorMessage);
        }
        switch (this.fState) {
            case 0: {
                break;
            }
            case 1: {
                throw new TemplateException(TextTemplateMessages.getString("TemplateTranslator.error.incomplete.variable"));
            }
            case 2: {
                throw new TemplateException(TextTemplateMessages.getString("TemplateTranslator.error.incomplete.variable"));
            }
        }
        int[] offsets = new int[this.fOffsets.size()];
        int[] lengths = new int[this.fLengths.size()];
        for (int i = 0; i < this.fOffsets.size(); ++i) {
            offsets[i] = (Integer)this.fOffsets.get(i);
            lengths[i] = (Integer)this.fLengths.get(i);
        }
        String translatedString = this.fBuffer.toString();
        TemplateVariable[] variables = this.findVariables(translatedString, offsets, lengths);
        return new TemplateBuffer(translatedString, variables);
    }

    private TemplateVariable[] findVariables(String string, int[] offsets, int[] lengths) {
        HashMap<String, Vector<Integer>> map = new HashMap<String, Vector<Integer>>();
        for (int i = 0; i != offsets.length; ++i) {
            int offset = offsets[i];
            int length = lengths[i];
            String content = string.substring(offset, offset + length);
            Vector<Integer> vector = (Vector<Integer>)map.get(content);
            if (vector == null) {
                vector = new Vector<Integer>();
                map.put(content, vector);
            }
            vector.add(new Integer(offset));
        }
        TemplateVariable[] variables = new TemplateVariable[map.size()];
        int k = 0;
        Set keys = map.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Vector vector = (Vector)map.get(name);
            int[] offsets_ = new int[vector.size()];
            for (int j = 0; j != offsets_.length; ++j) {
                offsets_[j] = (Integer)vector.get(j);
            }
            variables[k] = this.createVariable(name, name, offsets_);
            ++k;
        }
        return variables;
    }

    protected TemplateVariable createVariable(String type, String name, int[] offsets) {
        return new TemplateVariable(type, name, offsets);
    }

    private boolean parse(String string) {
        block15: for (int i = 0; i != string.length(); ++i) {
            char ch = string.charAt(i);
            switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case '$': {
                            this.fState = 1;
                            continue block15;
                        }
                    }
                    this.fBuffer.append(ch);
                    continue block15;
                }
                case 1: {
                    switch (ch) {
                        case '$': {
                            this.fBuffer.append(ch);
                            this.fState = 0;
                            continue block15;
                        }
                        case '{': {
                            this.fOffsets.add(new Integer(this.fBuffer.length()));
                            this.fState = 2;
                            continue block15;
                        }
                    }
                    this.fErrorMessage = TextTemplateMessages.getString("TemplateTranslator.error.incomplete.variable");
                    this.fBuffer.append('$');
                    this.fBuffer.append(ch);
                    this.fState = 0;
                    return false;
                }
                case 2: {
                    switch (ch) {
                        case '}': {
                            int offset = (Integer)this.fOffsets.get(this.fOffsets.size() - 1);
                            this.fLengths.add(new Integer(this.fBuffer.length() - offset));
                            this.fState = 0;
                            continue block15;
                        }
                    }
                    if (!Character.isUnicodeIdentifierStart(ch) && !Character.isUnicodeIdentifierPart(ch)) {
                        this.fErrorMessage = TextTemplateMessages.getString("TemplateTranslator.error.invalid.identifier");
                        return false;
                    }
                    this.fBuffer.append(ch);
                }
            }
        }
        return true;
    }
}

