/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorAction;
import org.eclipse.jface.action.IAction;

public class MonitorQuitAction
extends MonitorAction {
    public void run(IAction action) {
        IJavaDebugTarget target = this.getDebugTarget();
        if (target == null) {
            return;
        }
        try {
            IThread[] threads = target.getThreads();
            for (int i = 0; i < threads.length; ++i) {
                IThread thread = threads[i];
                if (!thread.isSuspended()) continue;
                thread.resume();
                while (thread.isSuspended()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    public void update() {
        boolean enable = false;
        if (this.fAction != null) {
            IJavaDebugTarget target = this.getDebugTarget();
            if (target != null && target.supportsMonitorInformation()) {
                try {
                    IThread[] threads = target.getThreads();
                    for (int i = 0; i < threads.length; ++i) {
                        IThread thread = threads[i];
                        if (!thread.isSuspended()) continue;
                        enable = true;
                        break;
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
            this.fAction.setEnabled(enable);
        }
    }
}

