/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.widgets.SelectableItem;
import org.eclipse.swt.widgets.SelectableItemWidget;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

abstract class AbstractTreeItem
extends SelectableItem {
    private Vector children;
    private boolean isExpanded = false;
    private int visibleItemCount = 0;

    AbstractTreeItem(Tree parent, int swtStyle) {
        super(parent, swtStyle);
    }

    void add(TreeItem item, int index) {
        Vector items = this.getChildren();
        int visibleIndex = this.getVisibleIndex();
        if (index < 0 || index > items.size()) {
            this.error(6);
        }
        if (item.isRoot()) {
            visibleIndex = index;
        } else if (!this.isExpanded) {
            visibleIndex = -1;
        }
        if (visibleIndex != -1) {
            if (index > 0) {
                TreeItem previousChild = (TreeItem)this.getChildren().elementAt(index - 1);
                visibleIndex = previousChild.getVisibleIndex() + previousChild.getVisibleItemCount() + 1;
            } else {
                visibleIndex = this.getVisibleIndex() + 1;
            }
        }
        this.getSelectableParent().addingItem(item, visibleIndex);
        item.setIndex(index);
        this.resetChildIndices(index, true);
        items.insertElementAt(item, index);
        if (this.isExpanded) {
            ++this.visibleItemCount;
            this.calculateVisibleItemCountParent();
        }
        this.getSelectableParent().addedItem(item, visibleIndex);
    }

    void internalSetExpanded(boolean expanded) {
        this.isExpanded = expanded;
        this.calculateVisibleItemCount();
    }

    abstract void calculateVisibleItemCount();

    abstract void calculateVisibleItemCountParent();

    void deselectAll() {
        Enumeration children = this.getChildren().elements();
        this.setSelected(false);
        while (children.hasMoreElements()) {
            AbstractTreeItem treeItem = (AbstractTreeItem)children.nextElement();
            treeItem.deselectAll();
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Vector children = this.getChildren();
        while (children.size() > 0) {
            AbstractTreeItem child = (AbstractTreeItem)children.firstElement();
            child.dispose();
        }
        super.dispose();
    }

    void doDispose() {
        this.setChildren(null);
        this.visibleItemCount = 0;
        super.doDispose();
    }

    Vector getChildren() {
        if (this.children == null) {
            this.children = new Vector(4);
        }
        return this.children;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.isExpanded;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getChildren().size();
    }

    abstract int getVisibleIndex();

    abstract int getVisibleIndex(int var1);

    abstract TreeItem getVisibleItem(int var1);

    int getVisibleItemCount() {
        return this.visibleItemCount;
    }

    boolean internalGetExpanded() {
        return this.isExpanded;
    }

    boolean isLeaf() {
        return this.getChildren().size() == 0;
    }

    boolean isRoot() {
        return false;
    }

    void removeItem(SelectableItem child) {
        Vector children = this.getChildren();
        SelectableItemWidget parent = this.getSelectableParent();
        int childIndex = children.indexOf(child);
        if (childIndex != -1) {
            if (((Tree)parent).isRemovingAll()) {
                children.removeElementAt(childIndex);
                if (this.isExpanded) {
                    --this.visibleItemCount;
                    this.calculateVisibleItemCountParent();
                }
            } else {
                parent.removingItem(child);
                children.removeElementAt(childIndex);
                if (this.isExpanded) {
                    --this.visibleItemCount;
                    this.calculateVisibleItemCountParent();
                }
                this.resetChildIndices(childIndex, false);
                parent.removedItem(child);
            }
        }
    }

    void reset() {
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            AbstractTreeItem treeItem = (AbstractTreeItem)children.nextElement();
            treeItem.reset();
        }
    }

    void resetChildIndices(int startIndex, boolean addItem) {
        Vector children = this.getChildren();
        int increment = addItem ? 1 : 0;
        for (int i = startIndex; i < children.size(); ++i) {
            TreeItem child = (TreeItem)children.elementAt(i);
            child.setIndex(i + increment);
        }
    }

    Vector selectAll(Vector selectedItems) {
        Enumeration children = this.getChildren().elements();
        if (!this.isSelected()) {
            selectedItems.addElement(this);
            this.setSelected(true);
            this.getSelectableParent().redrawSelection(this);
        }
        while (children.hasMoreElements()) {
            AbstractTreeItem treeItem = (AbstractTreeItem)children.nextElement();
            selectedItems = treeItem.selectAll(selectedItems);
        }
        return selectedItems;
    }

    void setChildren(Vector children) {
        this.children = children;
    }

    void setVisibleItemCount(int count) {
        this.visibleItemCount = count;
    }
}

