/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.DependencySystem;
import org.eclipse.core.internal.dependencies.Element;

public class ElementSet {
    private DependencySystem system;
    private Object id;
    private transient int visitedMark;
    private transient int changedMark;
    private transient int needingUpdate;
    private int singletonsCount;
    private Collection requiring;
    private Collection required;
    private Map available;
    private Set satisfied;
    private Set selected;
    private Set resolved;
    private Map dependencyCounters;

    public ElementSet(Object id, DependencySystem system) {
        this.id = id;
        this.system = system;
        this.setNeedingUpdate(0);
        this.available = new HashMap();
        this.satisfied = Collections.EMPTY_SET;
        this.selected = Collections.EMPTY_SET;
        this.resolved = Collections.EMPTY_SET;
        this.required = new LinkedList();
        this.requiring = new LinkedList();
        this.dependencyCounters = new HashMap();
    }

    public DependencySystem getSystem() {
        return this.system;
    }

    public boolean allowsConcurrency() {
        return this.singletonsCount == 0;
    }

    void addElement(Element element) {
        if (this.available.containsKey(element.getVersionId())) {
            return;
        }
        this.setNeedingUpdate(0);
        this.available.put(element.getVersionId(), element);
        Dependency[] dependencies = element.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            this.addRequired(dependencies[i].getRequiredObjectId());
        }
        if (element.isSingleton()) {
            ++this.singletonsCount;
        }
        this.system.recordElementStatusChanged(element, 1);
    }

    void removeElement(Element element) {
        this.removeElement(element.getVersionId());
    }

    void removeElement(Object versionId) {
        Element toRemove = (Element)this.available.remove(versionId);
        if (toRemove == null) {
            return;
        }
        this.markNeedingUpdate(0);
        Dependency[] dependencies = toRemove.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            this.removeRequired(dependencies[i].getRequiredObjectId());
        }
        if (toRemove.isSingleton()) {
            --this.singletonsCount;
        }
        int change = 2;
        this.system.recordElementStatusChanged(toRemove, change);
    }

    public Object getId() {
        return this.id;
    }

    public boolean isRoot() {
        return this.getRequired().isEmpty();
    }

    public Set getAvailable() {
        return new HashSet(this.available.values());
    }

    public Collection getRequired() {
        return this.required;
    }

    public Collection getRequiring() {
        return this.requiring;
    }

    public Set getResolved() {
        return this.resolved;
    }

    public void resolveDependency(Dependency dependency, Object resolvedVersionId) {
        dependency.resolve(resolvedVersionId, this.visitedMark);
    }

    public void setResolved(Set newResolved) {
        this.setNeedingUpdate(Integer.MAX_VALUE);
        Iterator resolvedIter = this.resolved.iterator();
        block0: while (resolvedIter.hasNext()) {
            Element resolvedElement = (Element)resolvedIter.next();
            Dependency[] dependencies = resolvedElement.getDependencies();
            for (int i = 0; i < dependencies.length; ++i) {
                if (dependencies[i].getChangedMark() != this.getVisitedMark()) continue;
                this.system.recordElementStatusChanged(resolvedElement, 16);
                continue block0;
            }
        }
        if (((Object)newResolved).equals(this.resolved)) {
            return;
        }
        this.setChangedMark(this.visitedMark);
        Set oldResolved = this.resolved;
        this.resolved = Collections.unmodifiableSet(newResolved);
        this.system.recordDependencyChanged(oldResolved, newResolved);
    }

    public Set getSelected() {
        return this.selected;
    }

    public void setSelected(Set selected) {
        this.setNeedingUpdate(2);
        if (((Object)selected).equals(this.selected)) {
            return;
        }
        this.setChangedMark(this.visitedMark);
        this.selected = Collections.unmodifiableSet(selected);
    }

    public Set getSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(Set satisfied) {
        this.setNeedingUpdate(1);
        if (((Object)satisfied).equals(this.satisfied)) {
            return;
        }
        this.setChangedMark(this.visitedMark);
        this.satisfied = Collections.unmodifiableSet(satisfied);
    }

    public String toString() {
        return this.id + ": " + this.available;
    }

    public boolean equals(Object elementSet) {
        return ((ElementSet)elementSet).getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private void addRequired(Object requiredId) {
        this.setNeedingUpdate(0);
        ElementSet requiredNode = this.system.getElementSet(requiredId);
        DependencyCounter counter = (DependencyCounter)this.dependencyCounters.get(requiredId);
        if (counter == null) {
            counter = new DependencyCounter();
            this.dependencyCounters.put(requiredId, counter);
            this.required.add(requiredNode);
            requiredNode.requiring.add(this);
            requiredNode.setNeedingUpdate(Math.min(requiredNode.getNeedingUpdate(), 1));
        }
        ++counter.value;
    }

    private void removeRequired(Object requiredId) {
        ElementSet requiredNode = this.system.getElementSet(requiredId);
        DependencyCounter counter = (DependencyCounter)this.dependencyCounters.get(requiredId);
        if (counter == null) {
            if (this.system.inDebugMode()) {
                System.err.println("Trying to remove non-existent dependency: " + this.id + " -> " + requiredId);
            }
            return;
        }
        --counter.value;
        if (counter.value == 0) {
            this.dependencyCounters.remove(requiredId);
            this.required.remove(requiredNode);
            requiredNode.requiring.remove(this);
            requiredNode.setNeedingUpdate(1);
        }
    }

    public void removeFromCycle() {
        Element[] availableElements = this.available.values().toArray(new Element[this.available.size()]);
        for (int i = 0; i < availableElements.length; ++i) {
            this.removeElement(availableElements[i]);
            availableElements[i].removeFromCycle();
            this.addElement(availableElements[i]);
        }
    }

    int getRequiringCount() {
        return this.requiring.size();
    }

    int getElementCount() {
        return this.available.size();
    }

    int getVisitedMark() {
        return this.visitedMark;
    }

    void setVisitedMark(int mark) {
        this.visitedMark = mark;
    }

    int getChangedMark() {
        return this.changedMark;
    }

    private void setChangedMark(int mark) {
        this.changedMark = mark;
    }

    void markNeedingUpdate(int order) {
        this.setNeedingUpdate(order);
    }

    boolean isNeedingUpdate(int order) {
        return this.getNeedingUpdate() <= order;
    }

    Element getElement(Object versionId) {
        return (Element)this.available.get(versionId);
    }

    public Collection getRequiringElements(Object versionId) {
        LinkedList<Element> result = new LinkedList<Element>();
        Iterator requiringSetsIter = this.requiring.iterator();
        while (requiringSetsIter.hasNext()) {
            ElementSet requiringSet = (ElementSet)requiringSetsIter.next();
            Iterator iter = requiringSet.getResolved().iterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                Dependency requisite = element.getDependency(this.id);
                if (requisite == null || !versionId.equals(requisite.getResolvedVersionId())) continue;
                result.add(element);
            }
        }
        return result;
    }

    public void unresolve(Element element, int mark) {
        this.setVisitedMark(mark);
        if (!this.resolved.contains(element)) {
            return;
        }
        HashSet newResolved = new HashSet(this.resolved);
        newResolved.remove(element);
        this.resolved = Collections.unmodifiableSet(newResolved);
        Dependency[] dependencies = element.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            this.resolveDependency(dependencies[i], null);
        }
        this.setChangedMark(mark);
        this.setNeedingUpdate(0);
    }

    private void setNeedingUpdate(int needingUpdate) {
        this.needingUpdate = needingUpdate;
    }

    private int getNeedingUpdate() {
        return this.needingUpdate;
    }

    class DependencyCounter {
        int value;

        DependencyCounter() {
        }
    }
}

