/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;

public class RenameCompilationUnitProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating {
    private RenameTypeProcessor fRenameTypeProcessor;
    private boolean fWillRenameType;
    private ICompilationUnit fCu;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameCompilationUnitProcessor";
    static /* synthetic */ Class class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker;

    public RenameCompilationUnitProcessor(ICompilationUnit unit) throws CoreException {
        this.fCu = unit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() {
        if (this.fCu == null) {
            return false;
        }
        if (!this.fCu.exists()) {
            return false;
        }
        if (!JavaModelUtil.isPrimary(this.fCu)) {
            return false;
        }
        return !this.fCu.isReadOnly();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.name", new String[]{this.fCu.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fCu);
    }

    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        String newTypeName = RenameCompilationUnitProcessor.removeFileNameExtension(this.getNewElementName());
        RenameArguments arguments = new RenameArguments(newTypeName, this.getUpdateReferences());
        this.loadDerivedParticipants(status, result, this.computeDerivedElements(), arguments, this.computeResourceModifications(), natures, shared);
    }

    private Object[] computeDerivedElements() {
        if (this.fRenameTypeProcessor == null) {
            return new Object[0];
        }
        return this.fRenameTypeProcessor.getElements();
    }

    private ResourceModifications computeResourceModifications() {
        IResource resource = this.fCu.getResource();
        if (resource == null) {
            return null;
        }
        ResourceModifications result = new ResourceModifications();
        result.setRename(resource, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        String typeName = RenameCompilationUnitProcessor.removeFileNameExtension(newName);
        RefactoringStatus result = Checks.checkCompilationUnitName(newName);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeProcessor.checkNewElementName(typeName));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fCu, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameCompilationUnitRefactoring.same_name"));
        }
        return result;
    }

    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameCompilationUnitProcessor.removeFileNameExtension(newName));
        }
    }

    public Object getNewElement() {
        IJavaElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IPackageFragment pack = (IPackageFragment)parent;
        if (JavaConventions.validateCompilationUnitName((String)this.getNewElementName()).getSeverity() == 4) {
            return this.fCu;
        }
        return pack.getCompilationUnit(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public boolean getUpdateTextualMatches() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateTextualMatches();
    }

    public void setUpdateTextualMatches(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateTextualMatches(update);
        }
    }

    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(update);
        }
    }

    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(update);
    }

    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(patterns);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            RefactoringStatus result1;
            if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                result1 = new RefactoringStatus();
                RefactoringStatus result2 = new RefactoringStatus();
                result2.merge(Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName()));
                if (result2.hasFatalError()) {
                    result1.addError(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed_1", this.fCu.getElementName()));
                } else {
                    result1.addError(RefactoringCoreMessages.getFormattedString("RenameCompilationUnitRefactoring.not_parsed", this.fCu.getElementName()));
                }
                result1.merge(result2);
            }
            if (this.fWillRenameType) {
                result1 = this.fRenameTypeProcessor.checkFinalConditions(pm, context);
                return result1;
            }
            IFile file = ResourceUtil.getFile(this.fCu);
            if (file != null) {
                ValidateEditChecker checker = (ValidateEditChecker)context.getChecker(class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker == null ? (class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker = RenameCompilationUnitProcessor.class$("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker")) : class$org$eclipse$ltk$core$refactoring$participants$ValidateEditChecker);
                checker.addFile(file);
            }
            RefactoringStatus refactoringStatus = Checks.checkCompilationUnitNewName(this.fCu, this.getNewElementName());
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return;
        }
        IType type = this.getTypeWithTheSameName();
        this.fRenameTypeProcessor = type != null ? new RenameTypeProcessor(type) : null;
        this.fWillRenameType = this.fRenameTypeProcessor != null && this.fCu.isStructureKnown();
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            for (int i = 0; i < topLevelTypes.length; ++i) {
                if (!name.equals(topLevelTypes[i].getElementName())) continue;
                return topLevelTypes[i];
            }
            return null;
        }
        catch (CoreException e) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameCompilationUnitProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(pm);
        }
        IResource resource = ResourceUtil.getResource(this.fCu);
        if (resource != null && resource.isLinked()) {
            return new DynamicValidationStateChange(new RenameResourceChange(resource, this.getNewElementName()));
        }
        return new DynamicValidationStateChange(new RenameCompilationUnitChange(this.fCu, this.getNewElementName()));
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.postCreateChange(participantChanges, pm);
        }
        return super.postCreateChange(participantChanges, pm);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

