/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContextType;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.java.JavaContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaDocContextType;
import org.eclipse.jdt.internal.corext.template.java.Templates;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.ui.CompatibilityTemplateStore;
import org.eclipse.jdt.internal.ui.EditorInputAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaElementAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.LogicalPackageAdapterFactory;
import org.eclipse.jdt.internal.ui.MarkerAdapterFactory;
import org.eclipse.jdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CustomBufferFactory;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.preferences.MockupPreferenceStore;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderRegistry;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class JavaPlugin
extends AbstractUIPlugin {
    public static final boolean USE_WORKING_COPY_OWNERS = true;
    private static final String TEMPLATES_KEY = "org.eclipse.jdt.ui.text.custom_templates";
    private static final String CODE_TEMPLATES_KEY = "org.eclipse.jdt.ui.text.custom_code_templates";
    private static final String TEMPLATES_MIGRATION_KEY = "org.eclipse.jdt.ui.text.templates_migrated";
    private static final String CODE_TEMPLATES_MIGRATION_KEY = "org.eclipse.jdt.ui.text.code_templates_migrated";
    private static JavaPlugin fgJavaPlugin;
    private ContextTypeRegistry fContextTypeRegistry;
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private TemplateStore fTemplateStore;
    private TemplateStore fCodeTemplateStore;
    private IWorkingCopyManager fWorkingCopyManager;
    private IBufferFactory fBufferFactory;
    private ICompilationUnitDocumentProvider fCompilationUnitDocumentProvider;
    private ClassFileDocumentProvider fClassFileDocumentProvider;
    private JavaTextTools fJavaTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private JavaElementAdapterFactory fJavaElementAdapterFactory;
    private MarkerAdapterFactory fMarkerAdapterFactory;
    private EditorInputAdapterFactory fEditorInputAdapterFactory;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private LogicalPackageAdapterFactory fLogicalPackageAdapterFactory;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private IPropertyChangeListener fFontPropertyChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private JavaEditorTextHoverDescriptor[] fJavaEditorTextHoverDescriptors;
    private MockupPreferenceStore fMockupPreferenceStore;
    private ASTProvider fASTProvider;
    private IPreferenceStore fCombinedPreferenceStore;
    private JavaFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;
    static /* synthetic */ Class class$org$eclipse$core$resources$IMarker;
    static /* synthetic */ Class class$org$eclipse$ui$IEditorInput;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$jdt$internal$ui$browsing$LogicalPackage;

    public static JavaPlugin getDefault() {
        return fgJavaPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return JavaPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JavaPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        for (int i = 0; i < windows.length; ++i) {
            IWorkbenchPage[] pages = windows[i].getPages();
            for (int x = 0; x < pages.length; ++x) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                for (int z = 0; z < editors.length; ++z) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (inputs.contains(input)) continue;
                    inputs.add(input);
                    result.add(ep);
                }
            }
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        for (int windowIndex = 0; windowIndex < windows.length; ++windowIndex) {
            IWorkbenchPage[] pages = windows[windowIndex].getPages();
            for (int pageIndex = 0; pageIndex < pages.length; ++pageIndex) {
                IEditorReference[] references = pages[pageIndex].getEditorReferences();
                for (int refIndex = 0; refIndex < references.length; ++refIndex) {
                    IEditorPart editor = references[refIndex].getEditor(false);
                    if (editor == null) continue;
                    result.add(editor);
                }
            }
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static String getPluginId() {
        return "org.eclipse.jdt.ui";
    }

    public static void log(IStatus status) {
        JavaPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            JavaPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(JavaPlugin.getPluginId(), 10001, message, null);
        multi.add(status);
        JavaPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, JavaUIMessages.getString("JavaPlugin.internal_error"), e));
    }

    public static boolean isDebug() {
        return JavaPlugin.getDefault().isDebugging();
    }

    public static boolean useNewSearch() {
        return true;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return JavaPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    public JavaPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgJavaPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerAdapters();
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.installPreferenceStoreBackwardsCompatibility();
        AllTypesCache.initialize();
        this.getASTProvider();
    }

    private void installPreferenceStoreBackwardsCompatibility() {
        String fontPropagatedKey = "fontPropagated";
        if (this.getPreferenceStore().contains("org.eclipse.jface.textfont") && !this.getPreferenceStore().isDefault("org.eclipse.jface.textfont") && !this.getPreferenceStore().getBoolean(fontPropagatedKey)) {
            PreferenceConverter.setValue((IPreferenceStore)PlatformUI.getWorkbench().getPreferenceStore(), (String)"org.eclipse.jdt.ui.editors.textfont", (FontData[])PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont"));
        }
        this.getPreferenceStore().setValue(fontPropagatedKey, true);
        PreferenceConverter.putValue((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
        this.fFontPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jdt.ui.editors.textfont".equals(event.getProperty())) {
                    PreferenceConverter.putValue((IPreferenceStore)JavaPlugin.this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        String oldTabWidthKey = "org.eclipse.jdt.ui.editor.tab.width";
        String newTabWidthKey = "tabWidth";
        String tabWidthPropagatedKey = "tabWidthPropagated";
        if (this.getPreferenceStore().contains("org.eclipse.jdt.ui.editor.tab.width") && !this.getPreferenceStore().isDefault("org.eclipse.jdt.ui.editor.tab.width") && !this.getPreferenceStore().getBoolean(tabWidthPropagatedKey)) {
            this.getPreferenceStore().setValue("tabWidth", this.getPreferenceStore().getInt("org.eclipse.jdt.ui.editor.tab.width"));
        }
        this.getPreferenceStore().setValue(tabWidthPropagatedKey, true);
        this.getPreferenceStore().putValue("org.eclipse.jdt.ui.editor.tab.width", this.getPreferenceStore().getString("tabWidth"));
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("tabWidth".equals(event.getProperty())) {
                    JavaPlugin.this.getPreferenceStore().putValue("org.eclipse.jdt.ui.editor.tab.width", JavaPlugin.this.getPreferenceStore().getString("tabWidth"));
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        this.getPreferenceStore().setValue("Refactoring.ErrorPage.severityThreshold", RefactoringCore.getConditionCheckingFailedSeverity());
    }

    private void uninstallPreferenceStoreBackwardsCompatibility() {
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
        this.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected ImageRegistry createImageRegistry() {
        return JavaPluginImages.getImageRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            AllTypesCache.terminate();
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            this.unregisterAdapters();
            if (this.fASTProvider != null) {
                this.fASTProvider.dispose();
                this.fASTProvider = null;
            }
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.shutdown();
                this.fWorkingCopyManager = null;
            }
            if (this.fCompilationUnitDocumentProvider != null) {
                this.fCompilationUnitDocumentProvider.shutdown();
                this.fCompilationUnitDocumentProvider = null;
            }
            if (this.fJavaTextTools != null) {
                this.fJavaTextTools.dispose();
                this.fJavaTextTools = null;
            }
            JavaDocLocations.shutdownJavadocLocations();
            this.uninstallPreferenceStoreBackwardsCompatibility();
            RefactoringCore.getUndoManager().shutdown();
        }
        finally {
            super.stop(context);
        }
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public synchronized IBufferFactory getBufferFactory() {
        if (this.fBufferFactory == null) {
            this.fBufferFactory = new CustomBufferFactory();
        }
        return this.fBufferFactory;
    }

    public synchronized ICompilationUnitDocumentProvider getCompilationUnitDocumentProvider() {
        if (this.fCompilationUnitDocumentProvider == null) {
            this.fCompilationUnitDocumentProvider = new CompilationUnitDocumentProvider();
        }
        return this.fCompilationUnitDocumentProvider;
    }

    public synchronized ClassFileDocumentProvider getClassFileDocumentProvider() {
        if (this.fClassFileDocumentProvider == null) {
            this.fClassFileDocumentProvider = new ClassFileDocumentProvider();
        }
        return this.fClassFileDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ICompilationUnitDocumentProvider provider = this.getCompilationUnitDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public MockupPreferenceStore getMockupPreferenceStore() {
        if (this.fMockupPreferenceStore == null) {
            this.fMockupPreferenceStore = new MockupPreferenceStore();
        }
        return this.fMockupPreferenceStore;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized JavaTextTools getJavaTextTools() {
        if (this.fJavaTextTools == null) {
            this.fJavaTextTools = new JavaTextTools(this.getPreferenceStore(), JavaCore.getPlugin().getPluginPreferences());
        }
        return this.fJavaTextTools;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        if (this.fMembersOrderPreferenceCache == null) {
            this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        }
        return this.fMembersOrderPreferenceCache;
    }

    public JavaEditorTextHoverDescriptor[] getJavaEditorTextHoverDescriptors() {
        if (this.fJavaEditorTextHoverDescriptors == null) {
            this.fJavaEditorTextHoverDescriptors = JavaEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((JavaEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fJavaEditorTextHoverDescriptors);
            int length = this.fJavaEditorTextHoverDescriptors.length;
            int first = -1;
            int last = length - 1;
            int problemHoverIndex = -1;
            int annotationHoverIndex = -1;
            for (int i = 0; i < length; ++i) {
                if (!this.fJavaEditorTextHoverDescriptors[i].getId().startsWith("org.eclipse.jdt.ui")) {
                    if (problemHoverIndex == -1 || annotationHoverIndex == -1) continue;
                    last = i - 1;
                    break;
                }
                if (first == -1) {
                    first = i;
                }
                if (this.fJavaEditorTextHoverDescriptors[i].getId().equals("org.eclipse.jdt.ui.AnnotationHover")) {
                    annotationHoverIndex = i;
                    continue;
                }
                if (!this.fJavaEditorTextHoverDescriptors[i].getId().equals("org.eclipse.jdt.ui.ProblemHover")) continue;
                problemHoverIndex = i;
            }
            JavaEditorTextHoverDescriptor hoverDescriptor = null;
            if (first > -1 && problemHoverIndex > -1 && problemHoverIndex != first) {
                hoverDescriptor = this.fJavaEditorTextHoverDescriptors[first];
                this.fJavaEditorTextHoverDescriptors[first] = this.fJavaEditorTextHoverDescriptors[problemHoverIndex];
                this.fJavaEditorTextHoverDescriptors[problemHoverIndex] = hoverDescriptor;
                if (annotationHoverIndex == first) {
                    annotationHoverIndex = problemHoverIndex;
                }
            }
            if (annotationHoverIndex > -1 && annotationHoverIndex != last) {
                hoverDescriptor = this.fJavaEditorTextHoverDescriptors[last];
                this.fJavaEditorTextHoverDescriptors[last] = this.fJavaEditorTextHoverDescriptors[annotationHoverIndex];
                this.fJavaEditorTextHoverDescriptors[annotationHoverIndex] = hoverDescriptor;
            }
            for (int i = 0; i < this.fJavaEditorTextHoverDescriptors.length - 1; ++i) {
                if (!"org.eclipse.jdt.ui.BestMatchHover".equals(this.fJavaEditorTextHoverDescriptors[i].getId())) continue;
                hoverDescriptor = this.fJavaEditorTextHoverDescriptors[i];
                for (int j = i; j > 0; --j) {
                    this.fJavaEditorTextHoverDescriptors[j] = this.fJavaEditorTextHoverDescriptors[j - 1];
                }
                this.fJavaEditorTextHoverDescriptors[0] = hoverDescriptor;
                break;
            }
        }
        return this.fJavaEditorTextHoverDescriptors;
    }

    public void resetJavaEditorTextHoverDescriptors() {
        this.fJavaEditorTextHoverDescriptors = null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType((TemplateContextType)new JavaContextType());
            this.fContextTypeRegistry.addContextType((TemplateContextType)new JavaDocContextType());
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            boolean alreadyMigrated = this.getPreferenceStore().getBoolean(TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY);
            } else {
                this.fTemplateStore = new CompatibilityTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), TEMPLATES_KEY, Templates.getInstance());
                this.getPreferenceStore().setValue(TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
        }
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            CodeTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            boolean alreadyMigrated = this.getPreferenceStore().getBoolean(CODE_TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fCodeTemplateStore = new ContributionTemplateStore(this.getCodeTemplateContextRegistry(), this.getPreferenceStore(), CODE_TEMPLATES_KEY);
            } else {
                this.fCodeTemplateStore = new CompatibilityTemplateStore(this.getCodeTemplateContextRegistry(), this.getPreferenceStore(), CODE_TEMPLATES_KEY, CodeTemplates.getInstance());
                this.getPreferenceStore().setValue(CODE_TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
            CompatibilityTemplateStore.pruneDuplicates(this.fCodeTemplateStore, true);
        }
        return this.fCodeTemplateStore;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        EditorsUI.useAnnotationsPreferencePage((IPreferenceStore)store);
        EditorsUI.useQuickDiffPreferencePage((IPreferenceStore)store);
        PreferenceConstants.initializeDefaultValues(store);
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    private void registerAdapters() {
        this.fJavaElementAdapterFactory = new JavaElementAdapterFactory();
        this.fMarkerAdapterFactory = new MarkerAdapterFactory();
        this.fEditorInputAdapterFactory = new EditorInputAdapterFactory();
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fLogicalPackageAdapterFactory = new LogicalPackageAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)this.fJavaElementAdapterFactory, class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavaPlugin.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        manager.registerAdapters((IAdapterFactory)this.fMarkerAdapterFactory, class$org$eclipse$core$resources$IMarker == null ? (class$org$eclipse$core$resources$IMarker = JavaPlugin.class$("org.eclipse.core.resources.IMarker")) : class$org$eclipse$core$resources$IMarker);
        manager.registerAdapters((IAdapterFactory)this.fEditorInputAdapterFactory, class$org$eclipse$ui$IEditorInput == null ? (class$org$eclipse$ui$IEditorInput = JavaPlugin.class$("org.eclipse.ui.IEditorInput")) : class$org$eclipse$ui$IEditorInput);
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = JavaPlugin.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        manager.registerAdapters((IAdapterFactory)this.fLogicalPackageAdapterFactory, class$org$eclipse$jdt$internal$ui$browsing$LogicalPackage == null ? (class$org$eclipse$jdt$internal$ui$browsing$LogicalPackage = JavaPlugin.class$("org.eclipse.jdt.internal.ui.browsing.LogicalPackage")) : class$org$eclipse$jdt$internal$ui$browsing$LogicalPackage);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fJavaElementAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fMarkerAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fEditorInputAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fLogicalPackageAdapterFactory);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public synchronized JavaFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new JavaFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

