/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.InstallLogParser;
import org.eclipse.update.internal.ui.UpdateLabelProvider;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;

public class ActivitiesTableViewer {
    private static InstallLogParser parser;

    public static TableViewer createViewer(Composite parent, boolean showCurrentOnly) {
        parser = new InstallLogParser();
        parser.parseInstallationLog();
        Table table = new Table(parent, 2048);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("ActivitiesTableViewer.date"));
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("ActivitiesTableViewer.target"));
        column = new TableColumn(table, 0);
        column.setText(UpdateUI.getString("ActivitiesTableViewer.action"));
        TableViewer activitiesViewer = new TableViewer(table);
        activitiesViewer.setLabelProvider((IBaseLabelProvider)new ActivitiesLabelProvider());
        activitiesViewer.setContentProvider((IContentProvider)new ActivitiesContentProvider(showCurrentOnly));
        return activitiesViewer;
    }

    static class ActivitiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ActivitiesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                UpdateLabelProvider provider = UpdateUI.getDefault().getLabelProvider();
                switch (((IActivity)element).getStatus()) {
                    case 0: {
                        return provider.get(UpdateUIImages.DESC_OK_ST_OBJ, 0);
                    }
                    case 1: {
                        return provider.get(UpdateUIImages.DESC_ERR_ST_OBJ, 0);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IActivity activity = (IActivity)element;
            switch (columnIndex) {
                case 1: {
                    return Utilities.format((Date)activity.getDate());
                }
                case 2: {
                    return activity.getLabel();
                }
                case 3: {
                    return this.getActionLabel(activity);
                }
            }
            return "";
        }

        private String getActionLabel(IActivity activity) {
            int action = activity.getAction();
            switch (action) {
                case 6: {
                    return UpdateUI.getString("ActivitiesTableViewer.enabled");
                }
                case 1: {
                    return UpdateUI.getString("ActivitiesTableViewer.featureInstalled");
                }
                case 2: {
                    return UpdateUI.getString("ActivitiesTableViewer.featureRemoved");
                }
                case 3: {
                    return UpdateUI.getString("ActivitiesTableViewer.siteInstalled");
                }
                case 4: {
                    return UpdateUI.getString("ActivitiesTableViewer.siteRemoved");
                }
                case 5: {
                    return UpdateUI.getString("ActivitiesTableViewer.disabled");
                }
                case 7: {
                    return UpdateUI.getString("ActivitiesTableViewer.revert");
                }
                case 8: {
                    return UpdateUI.getString("ActivitiesTableViewer.reconcile");
                }
            }
            return UpdateUI.getString("ActivitiesTableViewer.unknown");
        }
    }

    static class ActivitiesContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        private boolean showCurrentOnly;

        public ActivitiesContentProvider(boolean showCurrentOnly) {
            this.showCurrentOnly = showCurrentOnly;
        }

        public ActivitiesContentProvider() {
            this.showCurrentOnly = false;
        }

        public Object[] getElements(Object element) {
            InstallConfiguration currentConfig = (InstallConfiguration)element;
            InstallConfiguration[] configs = parser.getConfigurations();
            boolean hitCurrentConfig = false;
            ArrayList<IActivity> activitiesList = new ArrayList<IActivity>();
            for (int i = 0; i < configs.length; ++i) {
                if (configs[i].equals((Object)currentConfig) && !hitCurrentConfig) {
                    hitCurrentConfig = true;
                }
                if (hitCurrentConfig && this.showCurrentOnly) {
                    return configs[i].getActivities();
                }
                if (!hitCurrentConfig) continue;
                IActivity[] activities = configs[i].getActivities();
                for (int j = 0; j < activities.length; ++j) {
                    activitiesList.add(activities[j]);
                }
            }
            return activitiesList.toArray(new IActivity[activitiesList.size()]);
        }
    }
}

