/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ModifiedFileSender;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;

public class Commit
extends Command {
    public static final Command.LocalOption FORCE = new Command.LocalOption("-f");

    protected Commit() {
    }

    protected String getRequestId() {
        return "ci";
    }

    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        this.checkResourcesManaged(resources);
        ModifiedFileSender visitor = new ModifiedFileSender(session);
        visitor.visit(session, resources, monitor);
        ICVSResource[] changedFiles = visitor.getModifiedFiles();
        for (int i = 0; i < changedFiles.length; ++i) {
            session.sendArgument(changedFiles[i].getRelativePath(session.getLocalRoot()));
        }
        return changedFiles;
    }

    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            new PruneFolderVisitor().visit(session, resources);
        }
        if (status.isOK()) {
            for (int i = 0; i < resources.length; ++i) {
                ICVSFile cvsFile;
                ICVSResource resource = resources[i];
                if (resource.isFolder() || !(cvsFile = (ICVSFile)resources[i]).exists() || !cvsFile.isModified(null)) continue;
                status = this.mergeStatus(status, this.clearModifiedState(cvsFile));
            }
        }
        return status;
    }

    protected IStatus clearModifiedState(ICVSFile cvsFile) throws CVSException {
        byte[] info = cvsFile.getSyncBytes();
        if (info == null) {
            return new Status(2, "org.eclipse.team.cvs.core", 0, Policy.bind("Commit.syncInfoMissing", cvsFile.getIResource().getFullPath().toString()), null);
        }
        cvsFile.checkedIn(null);
        return new Status(1, "org.eclipse.team.cvs.core", 0, Policy.bind("Commit.timestampReset", cvsFile.getIResource().getFullPath().toString()), null);
    }

    protected void sendArguments(Session session, String[] arguments) throws CVSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStatus execute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] arguments, Collection filesToCommitAsText, ICommandOutputListener listener, IProgressMonitor pm) throws CVSException {
        session.setTextTransferOverride(filesToCommitAsText);
        try {
            IStatus iStatus = super.execute(session, globalOptions, localOptions, arguments, listener, pm);
            return iStatus;
        }
        finally {
            session.setTextTransferOverride(null);
        }
    }
}

