/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.ResponseStream;
import org.apache.catalina.connector.http.HttpResponseImpl;

public final class HttpResponseStream
extends ResponseStream {
    private static final int MAX_CHUNK_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private boolean useChunking;
    private boolean writingChunk;
    private boolean writeContent;

    public HttpResponseStream(HttpResponseImpl response) {
        super(response);
        this.checkChunking(response);
        this.checkHead(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        if (this.suspended) {
            return;
        }
        if (!this.writeContent) {
            return;
        }
        if (this.useChunking && !this.writingChunk) {
            this.writingChunk = true;
            try {
                this.print("1\r\n");
                super.write(b);
                this.println();
            }
            finally {
                this.writingChunk = false;
            }
        } else {
            super.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.suspended) {
            return;
        }
        if (!this.writeContent) {
            return;
        }
        if (this.useChunking && !this.writingChunk) {
            if (len > 0) {
                this.writingChunk = true;
                try {
                    this.println(Integer.toHexString(len));
                    super.write(b, off, len);
                    this.println();
                }
                finally {
                    this.writingChunk = false;
                }
            }
        } else {
            super.write(b, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.suspended) {
            throw new IOException(sm.getString("responseStream.suspended"));
        }
        if (!this.writeContent) {
            return;
        }
        if (this.useChunking) {
            this.writingChunk = true;
            try {
                this.print("0\r\n\r\n");
            }
            finally {
                this.writingChunk = false;
            }
        }
        super.close();
    }

    void checkChunking(HttpResponseImpl response) {
        if (this.count != 0) {
            return;
        }
        boolean bl = this.useChunking = !response.isCommitted() && response.getContentLength() == -1 && response.getStatus() != 304;
        if (!response.isChunkingAllowed() && this.useChunking) {
            response.setHeader("Connection", "close");
        }
        boolean bl2 = this.useChunking = this.useChunking && !response.isCloseConnection();
        if (this.useChunking) {
            response.setHeader("Transfer-Encoding", "chunked");
        } else if (response.isChunkingAllowed()) {
            response.removeHeader("Transfer-Encoding", "chunked");
        }
    }

    protected void checkHead(HttpResponseImpl response) {
        HttpServletRequest servletRequest = (HttpServletRequest)response.getRequest();
        this.writeContent = !"HEAD".equals(servletRequest.getMethod());
    }
}

