/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.sonatype.spice.zapper.internal.hawtbuf.HashBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hash
extends HashBase<Hash> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasHashAlg()) {
            missingFields.add("hashAlg");
        }
        if (!this.hasHashBytes()) {
            missingFields.add("hashBytes");
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearHashAlg();
        this.clearHashBytes();
    }

    public Hash clone() {
        return new Hash().mergeFrom(this);
    }

    public Hash mergeFrom(Hash other) {
        if (other.hasHashAlg()) {
            this.setHashAlg(other.getHashAlg());
        }
        if (other.hasHashBytes()) {
            this.setHashBytes(other.getHashBytes());
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasHashAlg()) {
            size += CodedOutputStream.computeStringSize((int)1, (String)this.getHashAlg());
        }
        if (this.hasHashBytes()) {
            size += CodedOutputStream.computeBytesSize((int)2, (Buffer)this.getHashBytes());
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public Hash mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block5: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block5;
                }
                case 10: {
                    this.setHashAlg(input.readString());
                    continue block5;
                }
                case 18: 
            }
            this.setHashBytes(input.readBytes());
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasHashAlg()) {
            output.writeString(1, this.getHashAlg());
        }
        if (this.hasHashBytes()) {
            output.writeBytes(2, this.getHashBytes());
        }
    }

    public static Hash parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (Hash)((Object)new Hash().mergeUnframed(data).checktInitialized());
    }

    public static Hash parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeUnframed(data))).checktInitialized());
    }

    public static Hash parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeUnframed(data))).checktInitialized());
    }

    public static Hash parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeUnframed(data))).checktInitialized());
    }

    public static Hash parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeFramed(data))).checktInitialized());
    }

    public static Hash parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeFramed(data))).checktInitialized());
    }

    public static Hash parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeFramed(data))).checktInitialized());
    }

    public static Hash parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (Hash)((Object)((Hash)((Object)new Hash().mergeFramed(data))).checktInitialized());
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        if (this.hasHashAlg()) {
            sb.append(prefix + "hashAlg: ");
            sb.append(this.getHashAlg());
            sb.append("\n");
        }
        if (this.hasHashBytes()) {
            sb.append(prefix + "hashBytes: ");
            sb.append(this.getHashBytes());
            sb.append("\n");
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != Hash.class) {
            return false;
        }
        return this.equals((Hash)((Object)obj));
    }

    public boolean equals(Hash obj) {
        if (this.hasHashAlg() ^ obj.hasHashAlg()) {
            return false;
        }
        if (this.hasHashAlg() && !this.getHashAlg().equals(obj.getHashAlg())) {
            return false;
        }
        if (this.hasHashBytes() ^ obj.hasHashBytes()) {
            return false;
        }
        return !this.hasHashBytes() || this.getHashBytes().equals(obj.getHashBytes());
    }

    public int hashCode() {
        int rc = 2241838;
        if (this.hasHashAlg()) {
            rc ^= 0x8CCB958E ^ this.getHashAlg().hashCode();
        }
        if (this.hasHashBytes()) {
            rc ^= 0x8850A7DD ^ this.getHashBytes().hashCode();
        }
        return rc;
    }
}

