/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

public abstract class Socks5Exception
extends SmackException {
    private static final long serialVersionUID = 1L;

    protected Socks5Exception(String message) {
        super(message);
    }

    public static final class CouldNotConnectToAnyProvidedSocks5Host
    extends Socks5Exception {
        private static final long serialVersionUID = 1L;
        private final Map<Bytestream.StreamHost, Exception> streamHostsExceptions;

        private CouldNotConnectToAnyProvidedSocks5Host(String message, Map<Bytestream.StreamHost, Exception> streamHostsExceptions) {
            super(message);
            this.streamHostsExceptions = Collections.unmodifiableMap(streamHostsExceptions);
        }

        public Map<Bytestream.StreamHost, Exception> getStreamHostsExceptions() {
            return this.streamHostsExceptions;
        }

        static CouldNotConnectToAnyProvidedSocks5Host construct(Map<Bytestream.StreamHost, Exception> streamHostsExceptions) {
            assert (!streamHostsExceptions.isEmpty());
            StringBuilder sb = new StringBuilder(256);
            sb.append("Could not establish socket with any provided SOCKS5 stream host.");
            Iterator<Bytestream.StreamHost> it = streamHostsExceptions.keySet().iterator();
            while (it.hasNext()) {
                Bytestream.StreamHost streamHost = it.next();
                Exception exception = streamHostsExceptions.get(streamHost);
                sb.append(' ').append(streamHost).append(" Exception: '").append(exception).append('\'');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            String message = sb.toString();
            return new CouldNotConnectToAnyProvidedSocks5Host(message, streamHostsExceptions);
        }
    }

    public static final class NoSocks5StreamHostsProvided
    extends Socks5Exception {
        private static final long serialVersionUID = 1L;

        NoSocks5StreamHostsProvided() {
            super("No SOCKS5 stream hosts provided.");
        }
    }
}

