/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;
import org.jivesoftware.smackx.xdata.FormFieldWithOptions;
import org.jivesoftware.smackx.xdata.JidMultiFormField;
import org.jivesoftware.smackx.xdata.JidSingleFormField;
import org.jivesoftware.smackx.xdata.ListMultiFormField;
import org.jivesoftware.smackx.xdata.ListSingleFormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProviderManager;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;

public class DataFormProvider
extends ExtensionElementProvider<DataForm> {
    private static final Logger LOGGER = Logger.getLogger(DataFormProvider.class.getName());
    public static final DataFormProvider INSTANCE = new DataFormProvider();
    private static final Set<FieldNameAndFormType> UNKNOWN_FIELDS = new CopyOnWriteArraySet<FieldNameAndFormType>();

    /*
     * Enabled aggressive block sorting
     */
    public DataForm parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        DataForm.Type dataFormType = DataForm.Type.fromString(parser.getAttributeValue("", "type"));
        DataForm.Builder dataForm = DataForm.builder(dataFormType);
        String formType = null;
        DataForm.ReportedData reportedData = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    XmlEnvironment elementXmlEnvironment = XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment);
                    switch (name) {
                        case "instructions": {
                            dataForm.addInstruction(parser.nextText());
                            break;
                        }
                        case "title": {
                            dataForm.setTitle(parser.nextText());
                            break;
                        }
                        case "field": {
                            FormField formField = DataFormProvider.parseField(parser, elementXmlEnvironment, formType);
                            TextSingleFormField hiddenFormTypeField = formField.asHiddenFormTypeFieldIfPossible();
                            if (hiddenFormTypeField != null) {
                                if (formType != null) {
                                    throw new SmackParsingException("Multiple hidden form type fields");
                                }
                                formType = hiddenFormTypeField.getValue();
                            }
                            dataForm.addField(formField);
                            break;
                        }
                        case "item": {
                            DataForm.Item item = DataFormProvider.parseItem(parser, elementXmlEnvironment, formType, reportedData);
                            dataForm.addItem(item);
                            break;
                        }
                        case "reported": {
                            if (reportedData != null) {
                                throw new SmackParsingException("Data form with multiple <reported/> elements");
                            }
                            reportedData = DataFormProvider.parseReported(parser, elementXmlEnvironment, formType);
                            dataForm.setReportedData(reportedData);
                            break;
                        }
                        case "query": {
                            if (namespace.equals("jabber:iq:roster")) {
                                dataForm.addExtensionElement((Element)RosterPacketProvider.INSTANCE.parse(parser));
                                break;
                            }
                            break block0;
                        }
                        case "page": {
                            if (namespace.equals("http://jabber.org/protocol/xdata-layout")) {
                                dataForm.addExtensionElement((Element)DataLayoutProvider.parse(parser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return dataForm.build();
                }
            }
        }
    }

    private static FormField parseField(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType) throws XmlPullParserException, IOException, SmackParsingException {
        return DataFormProvider.parseField(parser, xmlEnvironment, formType, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FormField parseField(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType, DataForm.ReportedData reportedData) throws XmlPullParserException, IOException, SmackParsingException {
        FormField.Builder builder;
        FormField reportedFormField;
        int initialDepth = parser.getDepth();
        String fieldName = parser.getAttributeValue("var");
        String label = parser.getAttributeValue("", "label");
        FormField.Type type = null;
        String fieldTypeString = parser.getAttributeValue("type");
        if (fieldTypeString != null) {
            type = FormField.Type.fromString(fieldTypeString);
        }
        ArrayList<FormField.Value> values = new ArrayList<FormField.Value>();
        ArrayList<FormField.Option> options = new ArrayList<FormField.Option>();
        ArrayList<FormFieldChildElement> childElements = new ArrayList<FormFieldChildElement>();
        boolean required = false;
        block19: while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            switch (eventType) {
                case START_ELEMENT: {
                    QName qname = parser.getQName();
                    if (qname.equals(FormField.Value.QNAME)) {
                        FormField.Value value = DataFormProvider.parseValue(parser);
                        values.add(value);
                        break;
                    }
                    if (qname.equals(FormField.Option.QNAME)) {
                        FormField.Option option = DataFormProvider.parseOption(parser);
                        options.add(option);
                        break;
                    }
                    if (qname.equals(FormField.Required.QNAME)) {
                        required = true;
                        break;
                    }
                    FormFieldChildElementProvider<?> formFieldChildElementProvider = FormFieldChildElementProviderManager.getFormFieldChildElementProvider(qname);
                    if (formFieldChildElementProvider == null) {
                        LOGGER.warning("Unknown form field child element " + qname + " ignored");
                        continue block19;
                    }
                    FormFieldChildElement formFieldChildElement = (FormFieldChildElement)formFieldChildElementProvider.parse(parser, XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment));
                    childElements.add(formFieldChildElement);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block19;
                }
            }
        }
        if (type == null && reportedData != null && (reportedFormField = reportedData.getField(fieldName)) != null) {
            type = reportedFormField.getType();
        }
        if (type == null) {
            if (fieldName.equals("FORM_TYPE")) {
                type = FormField.Type.hidden;
            } else {
                type = FormFieldRegistry.lookup(formType, fieldName);
                if (type == null) {
                    FieldNameAndFormType fieldNameAndFormType = new FieldNameAndFormType(fieldName, formType);
                    if (!UNKNOWN_FIELDS.contains(fieldNameAndFormType)) {
                        LOGGER.warning("The Field '" + fieldName + "' from FORM_TYPE '" + formType + "' is not registered. Field type is unknown, assuming text-single.");
                        UNKNOWN_FIELDS.add(fieldNameAndFormType);
                    }
                    type = FormField.Type.text_single;
                }
            }
        }
        switch (type) {
            case bool: {
                builder = DataFormProvider.parseBooleanFormField(fieldName, values);
                break;
            }
            case fixed: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.fixedBuilder(fieldName), values);
                break;
            }
            case hidden: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.hiddenBuilder(fieldName), values);
                break;
            }
            case jid_multi: {
                JidMultiFormField.Builder jidMultiBuilder = FormField.jidMultiBuilder(fieldName);
                for (FormField.Value value : values) {
                    jidMultiBuilder.addValue(value);
                }
                builder = jidMultiBuilder;
                break;
            }
            case jid_single: {
                DataFormProvider.ensureAtMostSingleValue(type, values);
                JidSingleFormField.Builder builder2 = FormField.jidSingleBuilder(fieldName);
                if (!values.isEmpty()) {
                    FormField.Value value;
                    value = (FormField.Value)values.get(0);
                    builder2.setValue(value);
                }
                builder = builder2;
                break;
            }
            case list_multi: {
                ListMultiFormField.Builder listMultiBuilder = FormField.listMultiBuilder(fieldName);
                DataFormProvider.addOptionsToBuilder(options, listMultiBuilder);
                builder = DataFormProvider.parseMultiKindFormField(listMultiBuilder, values);
                break;
            }
            case list_single: {
                ListSingleFormField.Builder listSingleBuilder = FormField.listSingleBuilder(fieldName);
                DataFormProvider.addOptionsToBuilder(options, listSingleBuilder);
                builder = DataFormProvider.parseSingleKindFormField(listSingleBuilder, values);
                break;
            }
            case text_multi: {
                builder = DataFormProvider.parseMultiKindFormField(FormField.textMultiBuilder(fieldName), values);
                break;
            }
            case text_private: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.textPrivateBuilder(fieldName), values);
                break;
            }
            case text_single: {
                builder = DataFormProvider.parseSingleKindFormField(FormField.textSingleBuilder(fieldName), values);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type " + (Object)((Object)type)));
            }
        }
        switch (type) {
            case list_multi: 
            case list_single: {
                break;
            }
            default: {
                if (options.isEmpty()) break;
                throw new SmackParsingException("Form fields of type " + (Object)((Object)type) + " must not have options. This one had " + options.size());
            }
        }
        if (label != null) {
            builder.setLabel(label);
        }
        builder.setRequired(required);
        builder.addFormFieldChildElements(childElements);
        return builder.build();
    }

    private static FormField.Builder<?, ?> parseBooleanFormField(String fieldName, List<FormField.Value> values) throws SmackParsingException {
        BooleanFormField.Builder builder = FormField.booleanBuilder(fieldName);
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), values);
        if (values.size() == 1) {
            FormField.Value value = values.get(0);
            builder.setValue(value);
        }
        return builder;
    }

    private static AbstractSingleStringValueFormField.Builder<?, ?> parseSingleKindFormField(AbstractSingleStringValueFormField.Builder<?, ?> builder, List<FormField.Value> values) throws SmackParsingException {
        DataFormProvider.ensureAtMostSingleValue(builder.getType(), values);
        if (values.size() == 1) {
            String value = values.get(0).getValue().toString();
            builder.setValue(value);
        }
        return builder;
    }

    private static AbstractMultiFormField.Builder<?, ?> parseMultiKindFormField(AbstractMultiFormField.Builder<?, ?> builder, List<FormField.Value> values) {
        for (FormField.Value value : values) {
            builder.addValue(value.getValue());
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.Item parseItem(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType, DataForm.ReportedData reportedData) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            FormField field = DataFormProvider.parseField(parser, XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment), formType, reportedData);
                            fields.add(field);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.Item(fields);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.ReportedData parseReported(XmlPullParser parser, XmlEnvironment xmlEnvironment, String formType) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            FormField field = DataFormProvider.parseField(parser, XmlEnvironment.from((XmlPullParser)parser, (XmlEnvironment)xmlEnvironment), formType);
                            fields.add(field);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.ReportedData(fields);
                }
            }
        }
    }

    public static FormField.Value parseValue(XmlPullParser parser) throws IOException, XmlPullParserException {
        String value = parser.nextText();
        return new FormField.Value(value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static FormField.Option parseOption(XmlPullParser parser) throws IOException, XmlPullParserException {
        int initialDepth = parser.getDepth();
        FormField.Option option = null;
        String label = parser.getAttributeValue("", "label");
        while (true) {
            XmlPullParser.TagEvent eventType = parser.nextTag();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "value": {
                            option = new FormField.Option(label, parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return option;
                }
            }
        }
    }

    private static void ensureAtMostSingleValue(FormField.Type type, List<FormField.Value> values) throws SmackParsingException {
        if (values.size() > 1) {
            throw new SmackParsingException((Object)((Object)type) + " fields can have at most one value, this one had " + values.size());
        }
    }

    private static void addOptionsToBuilder(Collection<FormField.Option> options, FormFieldWithOptions.Builder<?> builder) {
        for (FormField.Option option : options) {
            builder.addOption(option);
        }
    }

    private static final class FieldNameAndFormType {
        private final String fieldName;
        private final String formType;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        private FieldNameAndFormType(String fieldName, String formType) {
            this.fieldName = fieldName;
            this.formType = formType;
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(b -> b.append((Object)this.fieldName).append((Object)this.formType).build());
        }

        public boolean equals(Object other) {
            return EqualsUtil.equals((Object)this, (Object)other, (e, o) -> e.append((Object)this.fieldName, (Object)o.fieldName).append((Object)this.formType, (Object)o.formType));
        }
    }
}

