/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper;

import java.security.NoSuchAlgorithmException;
import org.sonatype.spice.zapper.CodecSelector;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.codec.NoopCodecSelector;
import org.sonatype.spice.zapper.hash.HashAlgorithm;
import org.sonatype.spice.zapper.hash.Sha1HashAlgorithm;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.ParametersImpl;

public class ParametersBuilder {
    private HashAlgorithm hashAlgorithm;
    private CodecSelector codecSelector;
    private int maximumTrackCount;
    private long maximumSegmentLength;

    private ParametersBuilder(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = Check.notNull(hashAlgorithm, HashAlgorithm.class);
        this.codecSelector = new NoopCodecSelector();
        this.maximumTrackCount = 6;
        this.maximumSegmentLength = 0x40000000L;
    }

    public ParametersBuilder setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = Check.notNull(hashAlgorithm, HashAlgorithm.class);
        return this;
    }

    public ParametersBuilder setCodecSelector(CodecSelector codecSelector) {
        this.codecSelector = Check.notNull(codecSelector, CodecSelector.class);
        return this;
    }

    public ParametersBuilder setMaximumTrackCount(int maximumTrackCount) {
        this.maximumTrackCount = Check.argument(maximumTrackCount > 0, maximumTrackCount, "maximumTrackCount not positive!");
        return this;
    }

    public ParametersBuilder setMaximumSegmentLength(long maximumSegmentLength) {
        this.maximumSegmentLength = Check.argument(maximumSegmentLength > 0L, maximumSegmentLength, "maximumSegmentLength not positive!");
        return this;
    }

    public Parameters build() {
        return new ParametersImpl(this.hashAlgorithm, this.codecSelector, this.maximumTrackCount, this.maximumSegmentLength);
    }

    public static ParametersBuilder defaults() throws NoSuchAlgorithmException {
        return new ParametersBuilder(new Sha1HashAlgorithm()).setMaximumTrackCount(6).setMaximumSegmentLength(0x40000000L);
    }
}

