/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.status;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitStatusConsumer
implements StreamConsumer {
    private static final Pattern ADDED_PATTERN = Pattern.compile("^A[ M]* (.*)$");
    private static final Pattern MODIFIED_PATTERN = Pattern.compile("^ *M[ M]* (.*)$");
    private static final Pattern DELETED_PATTERN = Pattern.compile("^ *D * (.*)$");
    private static final Pattern RENAMED_PATTERN = Pattern.compile("^R  (.*) -> (.*)$");
    private ScmLogger logger;
    private File workingDirectory;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();
    private URI relativeRepositoryPath;

    public GitStatusConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    public GitStatusConsumer(ScmLogger logger, File workingDirectory, URI relativeRepositoryPath) {
        this(logger, workingDirectory);
        this.relativeRepositoryPath = relativeRepositoryPath;
    }

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (StringUtils.isEmpty((String)line)) {
            return;
        }
        ScmFileStatus status = null;
        ArrayList<String> files = new ArrayList<String>();
        Matcher matcher = ADDED_PATTERN.matcher(line);
        if (matcher.find()) {
            status = ScmFileStatus.ADDED;
            files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
        } else {
            matcher = MODIFIED_PATTERN.matcher(line);
            if (matcher.find()) {
                status = ScmFileStatus.MODIFIED;
                files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
            } else {
                matcher = DELETED_PATTERN.matcher(line);
                if (matcher.find()) {
                    status = ScmFileStatus.DELETED;
                    files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
                } else {
                    matcher = RENAMED_PATTERN.matcher(line);
                    if (matcher.find()) {
                        status = ScmFileStatus.RENAMED;
                        files.add(GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath));
                        files.add(GitStatusConsumer.resolvePath(matcher.group(2), this.relativeRepositoryPath));
                        this.logger.debug("RENAMED status for line '" + line + "' files added '" + matcher.group(1) + "' '" + matcher.group(2));
                    } else {
                        this.logger.warn("Ignoring unrecognized line: " + line);
                        return;
                    }
                }
            }
        }
        if (!files.isEmpty() && status != null) {
            if (this.workingDirectory != null) {
                if (status == ScmFileStatus.RENAMED) {
                    String oldFilePath = (String)files.get(0);
                    String newFilePath = (String)files.get(1);
                    if (this.isFile(oldFilePath)) {
                        this.logger.debug("file '" + oldFilePath + "' is a file");
                        return;
                    }
                    this.logger.debug("file '" + oldFilePath + "' not a file");
                    if (!this.isFile(newFilePath)) {
                        this.logger.debug("file '" + newFilePath + "' not a file");
                        return;
                    }
                    this.logger.debug("file '" + newFilePath + "' is a file");
                } else if (status == ScmFileStatus.DELETED ? this.isFile((String)files.get(0)) : !this.isFile((String)files.get(0))) {
                    return;
                }
            }
            for (String file : files) {
                this.changedFiles.add(new ScmFile(file, status));
            }
        }
    }

    private boolean isFile(String file) {
        File targetFile = this.relativeRepositoryPath == null ? new File(this.workingDirectory, file) : new File(this.relativeRepositoryPath.getPath(), file);
        return targetFile.isFile();
    }

    protected static String resolvePath(String fileEntry, URI path) {
        if (path != null) {
            return GitStatusConsumer.resolveURI(fileEntry, path).getPath();
        }
        return fileEntry;
    }

    public static URI resolveURI(String fileEntry, URI path) {
        String str = fileEntry.replace(" ", "%20");
        return path.relativize(URI.create(str));
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

