/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.condition;

import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.NexusStatus;
import org.sonatype.nexus.client.internal.util.Check;

public abstract class LogicalConditions {
    public static Condition and(final Condition ... conditions) {
        Check.argument(conditions.length > 1, "At least two operators expected!");
        return new Condition(){
            private static final String KW = " AND ";

            @Override
            public boolean isSatisfiedBy(NexusStatus status) {
                for (Condition condition : conditions) {
                    if (condition.isSatisfiedBy(status)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String explainNotSatisfied(NexusStatus status) {
                Condition lastCondition = conditions[conditions.length - 1];
                StringBuilder explanation = new StringBuilder("(");
                for (Condition condition : conditions) {
                    explanation.append(condition.explainNotSatisfied(status));
                    if (condition == lastCondition) continue;
                    explanation.append(KW);
                }
                return explanation.append(")").toString();
            }
        };
    }

    public static Condition or(final Condition ... conditions) {
        Check.argument(conditions.length > 1, "At least two operators expected!");
        return new Condition(){
            private static final String KW = " OR ";

            @Override
            public boolean isSatisfiedBy(NexusStatus status) {
                for (Condition condition : conditions) {
                    if (!condition.isSatisfiedBy(status)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String explainNotSatisfied(NexusStatus status) {
                Condition lastCondition = conditions[conditions.length - 1];
                StringBuilder explanation = new StringBuilder("(");
                for (Condition condition : conditions) {
                    explanation.append(condition.explainNotSatisfied(status));
                    if (condition == lastCondition) continue;
                    explanation.append(KW);
                }
                return explanation.append(")").toString();
            }
        };
    }

    public static Condition not(final Condition condition) {
        Check.notNull(condition, Condition.class);
        return new Condition(){

            @Override
            public boolean isSatisfiedBy(NexusStatus status) {
                return !condition.isSatisfiedBy(status);
            }

            @Override
            public String explainNotSatisfied(NexusStatus status) {
                return "(NOT " + condition.explainNotSatisfied(status) + ")";
            }
        };
    }
}

