/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.ExtensionsKt;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/github/ajalt/colormath/HSL;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "h", "", "s", "l", "(III)V", "getH", "()I", "getL", "getS", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toHSL", "toHSV", "Lcom/github/ajalt/colormath/HSV;", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colorconversion"})
public final class HSL
implements ConvertibleColor {
    private final int h;
    private final int s;
    private final int l;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB toRGB() {
        double h = (double)this.h / 360.0;
        double s = (double)this.s / 100.0;
        double l = (double)this.l / 100.0;
        if (s == 0.0) {
            int v = (int)(l * (double)255);
            return new RGB(v, v, v);
        }
        double t2 = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double t1 = (double)2 * l - t2;
        Double[] rgb = new Double[]{0.0, 0.0, 0.0};
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            void i;
            double t3 = h + 0.3333333333333333 * -((double)i - 1.0);
            if (t3 < 0.0) {
                t3 += 1.0;
            }
            if (t3 > 1.0) {
                t3 -= 1.0;
            }
            double v = (double)6 * t3 < 1.0 ? t1 + (t2 - t1) * (double)6 * t3 : ((double)2 * t3 < 1.0 ? t2 : ((double)3 * t3 < (double)2 ? t1 + (t2 - t1) * (0.6666666666666666 - t3) * (double)6 : t1));
            rgb[i] = v * 255.0;
            ++i;
        }
        return new RGB(ExtensionsKt.roundToInt(rgb[0]), ExtensionsKt.roundToInt(rgb[1]), ExtensionsKt.roundToInt(rgb[2]));
    }

    @Override
    @NotNull
    public HSV toHSV() {
        double h = this.h;
        double s = (double)this.s / (double)100;
        double l = (double)this.l / (double)100;
        double smin = s;
        double d = 0.01;
        double lmin = Math.max(l, d);
        double v = (l + (s *= (l *= (double)2) <= 1.0 ? l : (double)2 - l)) / (double)2;
        double sv = l == 0.0 ? (double)2 * (smin *= lmin <= 1.0 ? lmin : (double)2 - lmin) / (lmin + smin) : (double)2 * s / (l + s);
        return new HSV(ExtensionsKt.roundToInt(h), ExtensionsKt.roundToInt(sv * (double)100), ExtensionsKt.roundToInt(v * (double)100));
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return this;
    }

    public final int getH() {
        return this.h;
    }

    public final int getS() {
        return this.s;
    }

    public final int getL() {
        return this.l;
    }

    public HSL(int h, int s, int l) {
        this.h = h;
        this.s = s;
        this.l = l;
        int n = this.h;
        int n2 = n = 0 <= n && 360 >= n ? 1 : 0;
        if (n == 0) {
            String string = "h must be in range [0, 360]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.s;
        int n3 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "s must be in range [0, 100]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.l;
        int n4 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "l must be in range [0, 100]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return ConvertibleColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return ConvertibleColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return ConvertibleColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return ConvertibleColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return ConvertibleColor.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.h;
    }

    public final int component2() {
        return this.s;
    }

    public final int component3() {
        return this.l;
    }

    @NotNull
    public final HSL copy(int h, int s, int l) {
        return new HSL(h, s, l);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ HSL copy$default(HSL hSL, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = hSL.h;
        }
        if ((n4 & 2) != 0) {
            n2 = hSL.s;
        }
        if ((n4 & 4) != 0) {
            n3 = hSL.l;
        }
        return hSL.copy(n, n2, n3);
    }

    public String toString() {
        return "HSL(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ")";
    }

    public int hashCode() {
        return (this.h * 31 + this.s) * 31 + this.l;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HSL)) break block3;
                HSL hSL = (HSL)object;
                if (!(this.h == hSL.h) || !(this.s == hSL.s) || !(this.l == hSL.l)) break block3;
            }
            return true;
        }
        return false;
    }
}

