/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveToObjectComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "op", "Lcom/intellij/psi/tree/IElementType;", "leftIsPrimitive", "", "left", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "right", "(Lcom/intellij/psi/tree/IElementType;ZLorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "checkTypeAndCompare", "onWrongType", "Lorg/jetbrains/org/objectweb/asm/Label;", "discard", "", "jumpIfFalse", "target", "jumpIfTrue", "backend.jvm.codegen"})
public final class PrimitiveToObjectComparison
extends BooleanValue {
    @NotNull
    private final IElementType op;
    private final boolean leftIsPrimitive;
    @NotNull
    private final MaterialValue left;
    @NotNull
    private final MaterialValue right;

    public PrimitiveToObjectComparison(@NotNull IElementType op, boolean leftIsPrimitive, @NotNull MaterialValue left, @NotNull MaterialValue right) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        super(left.getCodegen());
        this.op = op;
        this.leftIsPrimitive = leftIsPrimitive;
        this.left = left;
        this.right = right;
    }

    private final BooleanValue checkTypeAndCompare(Label onWrongType) {
        BooleanValue booleanValue;
        int n;
        Label compareLabel = new Label();
        if (this.leftIsPrimitive) {
            n = -1;
        } else {
            int n2;
            int it = n2 = this.getCodegen().getFrameMap().enterTemp(this.right.getType());
            boolean bl = false;
            this.getMv().store(it, this.right.getType());
            n = n2;
        }
        int tmp = n;
        this.getMv().dup();
        if (AsmUtil.isBoxedPrimitiveType(this.leftIsPrimitive ? this.right.getType() : this.left.getType())) {
            this.getMv().ifnonnull(compareLabel);
        } else {
            this.getMv().instanceOf(AsmUtil.boxType(this.leftIsPrimitive ? this.left.getType() : this.right.getType()));
            this.getMv().ifne(compareLabel);
        }
        if (this.leftIsPrimitive) {
            this.right.discard();
        }
        this.left.discard();
        this.getMv().goTo(onWrongType);
        this.getMv().mark(compareLabel);
        if (this.leftIsPrimitive) {
            booleanValue = new BooleanComparison(this.op, this.left, PromisedValueKt.materializedAt$default(this.right, this.left.getType(), this.right.getIrType(), false, 4, null));
        } else {
            MaterialValue leftUnboxed = PromisedValueKt.materializedAt$default(this.left, this.right.getType(), this.left.getIrType(), false, 4, null);
            this.getMv().load(tmp, this.right.getType());
            this.getCodegen().getFrameMap().leaveTemp(this.right.getType());
            booleanValue = new BooleanComparison(this.op, leftUnboxed, this.right);
        }
        return booleanValue;
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.checkTypeAndCompare(target).jumpIfFalse(target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Label wrongType = new Label();
        this.checkTypeAndCompare(wrongType).jumpIfTrue(target);
        this.getMv().mark(wrongType);
    }

    @Override
    public void discard() {
        this.right.discard();
        this.left.discard();
    }
}

