/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.nullCheck;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInlinerKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.PopBackwardPropagationTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NotNullBasicValue;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.NullBasicValue;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0016J\u000e\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0014*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/nullCheck/NullabilityInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "merge", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "v", "w", "mergeNotNullValuesOfSameKind", "Lorg/jetbrains/kotlin/codegen/optimization/common/StrictBasicValue;", "naryOperation", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "values", "", "newOperation", "unaryOperation", "value", "isReferenceType", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "isReifiedSafeAs", "backend"})
public final class NullabilityInterpreter
extends OptimizationBasicInterpreter {
    @NotNull
    private final GenerationState generationState;

    public NullabilityInterpreter(@NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.generationState = generationState;
    }

    @Override
    @Nullable
    public BasicValue newOperation(@NotNull AbstractInsnNode insn) {
        BasicValue defaultResult;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        BasicValue basicValue = defaultResult = super.newOperation(insn);
        Type resultType = basicValue != null ? basicValue.getType() : null;
        return insn.getOpcode() == 1 ? (BasicValue)NullBasicValue.INSTANCE : (insn.getOpcode() == 187 ? (BasicValue)new NotNullBasicValue(resultType) : (insn.getOpcode() == 18 && this.isReferenceType(resultType) ? (BasicValue)new NotNullBasicValue(resultType) : (PopBackwardPropagationTransformerKt.isUnitInstance(insn) ? (BasicValue)new NotNullBasicValue(resultType) : defaultResult)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isReferenceType(Type $this$isReferenceType) {
        Type type2 = $this$isReferenceType;
        if (type2 == null) return false;
        Integer n = type2.getSort();
        Integer it = n;
        boolean bl = false;
        Integer n2 = it;
        int n3 = 10;
        if (n2 != null) {
            if (n2 == n3) return true;
        }
        Integer n4 = it;
        n3 = 9;
        if (n4 == null) return false;
        if (n4 != n3) return false;
        return true;
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @Nullable BasicValue value2) {
        BasicValue basicValue;
        BasicValue defaultResult;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        BasicValue basicValue2 = defaultResult = super.unaryOperation(insn, value2);
        Type resultType = basicValue2 != null ? basicValue2.getType() : null;
        switch (insn.getOpcode()) {
            case 192: {
                if (this.isReifiedSafeAs(insn)) {
                    basicValue = new StrictBasicValue(resultType);
                    break;
                }
                basicValue = value2;
                break;
            }
            case 188: 
            case 189: {
                basicValue = new NotNullBasicValue(resultType);
                break;
            }
            default: {
                basicValue = defaultResult;
            }
        }
        return basicValue;
    }

    private final boolean isReifiedSafeAs(AbstractInsnNode $this$isReifiedSafeAs) {
        AbstractInsnNode abstractInsnNode = $this$isReifiedSafeAs.getPrevious();
        MethodInsnNode methodInsnNode = abstractInsnNode instanceof MethodInsnNode ? (MethodInsnNode)abstractInsnNode : null;
        if (methodInsnNode == null) {
            return false;
        }
        MethodInsnNode marker = methodInsnNode;
        return ReifiedTypeInliner.Companion.isOperationReifiedMarker(marker) && ReifiedTypeInlinerKt.getOperationKind(marker) == ReifiedTypeInliner.OperationKind.SAFE_AS;
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values2) {
        Value value2;
        Value defaultResult;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Value value3 = defaultResult = super.naryOperation(insn, (List)values2);
        Type resultType = value3 != null ? ((BasicValue)value3).getType() : null;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            value2 = new NotNullBasicValue(resultType);
        } else if (BoxingInterpreterKt.isIteratorMethodCallOfProgression(insn, values2)) {
            Type type2 = values2.get(0).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"values[0].type");
            value2 = ProgressionIteratorBasicValue.Companion.byProgressionClassType(insn, type2);
        } else {
            value2 = BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values2) ? (BasicValue)new NotNullBasicValue(resultType) : (PseudoInsnsKt.isPseudo(insn, PseudoInsn.AS_NOT_NULL) ? (BasicValue)new NotNullBasicValue(values2.get(0).getType()) : defaultResult);
        }
        return value2;
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        BasicValue basicValue;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        if (v instanceof NullBasicValue && w instanceof NullBasicValue) {
            basicValue = NullBasicValue.INSTANCE;
        } else if (v instanceof NullBasicValue || w instanceof NullBasicValue) {
            basicValue = StrictBasicValue.REFERENCE_VALUE;
        } else if (v instanceof ProgressionIteratorBasicValue && w instanceof ProgressionIteratorBasicValue) {
            basicValue = this.mergeNotNullValuesOfSameKind((StrictBasicValue)v, (StrictBasicValue)w);
        } else if (v instanceof ProgressionIteratorBasicValue && w instanceof NotNullBasicValue) {
            basicValue = NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
        } else if (w instanceof ProgressionIteratorBasicValue && v instanceof NotNullBasicValue) {
            basicValue = NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
        } else if (v instanceof NotNullBasicValue && w instanceof NotNullBasicValue) {
            basicValue = this.mergeNotNullValuesOfSameKind((StrictBasicValue)v, (StrictBasicValue)w);
        } else {
            BasicValue basicValue2 = super.merge(v, w);
            basicValue = basicValue2;
            Intrinsics.checkNotNullExpressionValue((Object)basicValue2, (String)"super.merge(v, w)");
        }
        return basicValue;
    }

    private final StrictBasicValue mergeNotNullValuesOfSameKind(StrictBasicValue v, StrictBasicValue w) {
        return Intrinsics.areEqual((Object)v.getType(), (Object)w.getType()) ? v : (StrictBasicValue)NotNullBasicValue.Companion.getNOT_NULL_REFERENCE_VALUE();
    }
}

