/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.change.VersionChange;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.change.DefaultVersionChange;
import org.codehaus.mojo.versions.change.VersionChanger;
import org.codehaus.mojo.versions.change.VersionChangerFactory;
import org.codehaus.mojo.versions.ordering.ReactorDepthComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DelegatingContextualLog;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="set", aggregator=true, threadSafe=true)
public class SetMojo
extends AbstractVersionsUpdaterMojo {
    private static final String SNAPSHOT = "-SNAPSHOT";
    @Parameter(property="newVersion")
    private String newVersion;
    @Parameter(property="groupId", defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(property="artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(property="oldVersion", defaultValue="${project.version}")
    private String oldVersion;
    @Parameter(property="updateMatchingVersions", defaultValue="true")
    private boolean updateMatchingVersions;
    @Parameter(property="processParent", defaultValue="true")
    private boolean processParent;
    @Parameter(property="processProject", defaultValue="true")
    private boolean processProject;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies;
    @Parameter(property="processPlugins", defaultValue="true")
    private boolean processPlugins;
    private Prompter prompter;
    @Parameter(property="removeSnapshot", defaultValue="false")
    private boolean removeSnapshot;
    @Parameter(property="nextSnapshot", defaultValue="false")
    protected boolean nextSnapshot;
    @Parameter(property="nextSnapshotIndexToIncrement")
    protected Integer nextSnapshotIndexToIncrement;
    @Parameter(property="processAllModules", defaultValue="false")
    private boolean processAllModules;
    @Parameter(property="processFromLocalAggregationRoot", defaultValue="true")
    private boolean processFromLocalAggregationRoot;
    @Parameter(property="updateBuildOutputTimestamp", defaultValue="true")
    private boolean updateBuildOutputTimestamp;
    @Parameter(property="updateBuildOutputTimestampPolicy", defaultValue="onchange")
    private String updateBuildOutputTimestampPolicy;
    private final transient List<DefaultVersionChange> sourceChanges = new ArrayList<DefaultVersionChange>();
    protected final ProjectBuilder projectBuilder;

    @Inject
    public SetMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, ProjectBuilder projectBuilder, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders, Prompter prompter) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
        this.projectBuilder = projectBuilder;
        this.prompter = prompter;
    }

    private synchronized void addChange(String groupId, String artifactId, String oldVersion, String newVersion) {
        if (!newVersion.equals(oldVersion)) {
            this.sourceChanges.add(new DefaultVersionChange(groupId, artifactId, oldVersion, newVersion));
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String version;
        if (this.getProject().getOriginalModel().getVersion() == null) {
            throw new MojoExecutionException("Project version is inherited from parent.");
        }
        if (this.removeSnapshot && !this.nextSnapshot && (version = this.getVersion()).endsWith(SNAPSHOT)) {
            this.newVersion = version.substring(0, version.indexOf(SNAPSHOT));
            this.getLog().info((CharSequence)("SNAPSHOT found.  BEFORE " + version + "  --> AFTER: " + this.newVersion));
        }
        if (!this.nextSnapshot && this.nextSnapshotIndexToIncrement != null) {
            throw new MojoExecutionException("nextSnapshotIndexToIncrement is not valid when nextSnapshot is false");
        }
        if (!this.removeSnapshot && this.nextSnapshot) {
            version = this.getVersion();
            this.newVersion = this.getIncrementedVersion(version, this.nextSnapshotIndexToIncrement);
            this.getLog().info((CharSequence)("SNAPSHOT found.  BEFORE " + version + "  --> AFTER: " + this.newVersion));
        }
        if (StringUtils.isEmpty((String)this.newVersion)) {
            if (this.removeSnapshot) {
                this.getLog().info((CharSequence)"removeSnapshot enabled whilst the version is not a snapshot: nothing to do.");
                return;
            }
            if (this.session.getSettings().isInteractiveMode()) {
                try {
                    this.newVersion = this.prompter.prompt("Enter the new version to set", this.getProject().getOriginalModel().getVersion());
                }
                catch (PrompterException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            } else {
                throw new MojoExecutionException("You must specify the new version, either by using the newVersion property (that is -DnewVersion=... on the command line) or run in interactive mode");
            }
        }
        if (!("onchange".equals(this.updateBuildOutputTimestampPolicy) || "always".equals(this.updateBuildOutputTimestampPolicy) || "never".equals(this.updateBuildOutputTimestampPolicy))) {
            throw new MojoExecutionException("updateBuildOutputTimestampPolicy should be one of: \"onchange\", \"always\", \"never\".");
        }
        try {
            MavenProject project = this.processFromLocalAggregationRoot ? PomHelper.getLocalRoot((ProjectBuilder)this.projectBuilder, (MavenSession)this.session, (Log)this.getLog()) : this.getProject();
            this.getLog().info((CharSequence)("Local aggregation root: " + project.getBasedir()));
            Map reactorModels = PomHelper.getChildModels((MavenProject)project, (Log)this.getLog());
            TreeMap<File, Model> reactor = new TreeMap<File, Model>((Comparator<File>)new ReactorDepthComparator(reactorModels));
            reactor.putAll(reactorModels);
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            this.getLog().info((CharSequence)("Processing change of " + this.groupId + ":" + this.artifactId + ":" + this.oldVersion + " -> " + this.newVersion));
            Pattern groupIdRegex = Pattern.compile(RegexUtils.convertWildcardsToRegex((String)SetMojo.fixNullOrEmpty(this.groupId, "*"), (boolean)true));
            Pattern artifactIdRegex = Pattern.compile(RegexUtils.convertWildcardsToRegex((String)SetMojo.fixNullOrEmpty(this.artifactId, "*"), (boolean)true));
            Pattern oldVersionIdRegex = Pattern.compile(RegexUtils.convertWildcardsToRegex((String)SetMojo.fixNullOrEmpty(this.oldVersion, "*"), (boolean)true));
            for (Model m2 : reactor.values()) {
                Map properties = Optional.ofNullable(m2.getProperties()).map(p -> p.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()))).orElse(null);
                String mGroupId = PomHelper.getGroupId((Model)m2);
                String mArtifactId = PomHelper.getArtifactId((Model)m2);
                String mVersion = PomHelper.getVersion((Model)m2);
                if (properties != null) {
                    mGroupId = PomHelper.evaluate((String)mGroupId, (Map)properties);
                    mArtifactId = PomHelper.evaluate((String)mArtifactId, (Map)properties);
                    mVersion = PomHelper.evaluate((String)mVersion, (Map)properties);
                }
                if (!this.processAllModules && (!groupIdRegex.matcher(mGroupId).matches() || !artifactIdRegex.matcher(mArtifactId).matches()) || !oldVersionIdRegex.matcher(mVersion).matches() || this.newVersion.equals(mVersion)) continue;
                this.applyChange(project, reactor, files, mGroupId, m2.getArtifactId(), StringUtils.isBlank((String)this.oldVersion) || "*".equals(this.oldVersion) ? "" : mVersion);
            }
            if ("always".equals(this.updateBuildOutputTimestampPolicy)) {
                reactor.values().stream().map(m -> PomHelper.getModelEntry((Map)reactor, (String)PomHelper.getGroupId((Model)m), (String)PomHelper.getArtifactId((Model)m))).filter(Objects::nonNull).map(Map.Entry::getValue).map(Model::getPomFile).forEach(files::add);
            }
            for (File file : files) {
                this.process(file);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected String getIncrementedVersion(String version, Integer nextSnapshotIndexToIncrement) throws MojoExecutionException {
        String versionWithoutSnapshot = version.endsWith(SNAPSHOT) ? version.substring(0, version.indexOf(SNAPSHOT)) : version;
        LinkedList<String> numbers = new LinkedList<String>(Arrays.asList(versionWithoutSnapshot.split("\\.")));
        if (nextSnapshotIndexToIncrement == null) {
            nextSnapshotIndexToIncrement = numbers.size();
        } else {
            if (nextSnapshotIndexToIncrement < 1) {
                throw new MojoExecutionException("nextSnapshotIndexToIncrement cannot be less than 1");
            }
            if (nextSnapshotIndexToIncrement > numbers.size()) {
                throw new MojoExecutionException("nextSnapshotIndexToIncrement cannot be greater than the last version index");
            }
        }
        int snapshotVersionToIncrement = Integer.parseInt((String)numbers.remove(nextSnapshotIndexToIncrement - 1));
        numbers.add(nextSnapshotIndexToIncrement - 1, String.valueOf(snapshotVersionToIncrement + 1));
        return StringUtils.join((Object[])numbers.toArray(new String[0]), (String)".") + SNAPSHOT;
    }

    private static String fixNullOrEmpty(String value, String defaultValue) {
        return StringUtils.isBlank((String)value) ? defaultValue : value;
    }

    private void applyChange(MavenProject project, SortedMap<File, Model> reactor, Set<File> files, String groupId, String artifactId, String oldVersion) {
        this.getLog().debug((CharSequence)("Applying change " + groupId + ":" + artifactId + ":" + oldVersion + " -> " + this.newVersion));
        this.addChange(groupId, artifactId, oldVersion, this.newVersion);
        Map.Entry current = PomHelper.getModelEntry(reactor, (String)groupId, (String)artifactId);
        if (current != null) {
            ((Model)current.getValue()).setVersion(this.newVersion);
            files.add(((Model)current.getValue()).getPomFile());
        }
        for (Map.Entry<File, Model> sourceEntry : reactor.entrySet()) {
            File sourcePath = sourceEntry.getKey();
            Model sourceModel = sourceEntry.getValue();
            this.getLog().debug((CharSequence)(sourcePath.length() == 0L ? "Processing root module as parent" : "Processing " + sourcePath + " as a parent."));
            String sourceGroupId = PomHelper.getGroupId((Model)sourceModel);
            if (sourceGroupId == null) {
                this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a groupId."));
                continue;
            }
            String sourceArtifactId = PomHelper.getArtifactId((Model)sourceModel);
            if (sourceArtifactId == null) {
                this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing an artifactId."));
                continue;
            }
            String sourceVersion = PomHelper.getVersion((Model)sourceModel);
            if (sourceVersion == null) {
                this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a version."));
                continue;
            }
            files.add(sourceModel.getPomFile());
            this.getLog().debug((CharSequence)("Looking for modules which use " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + " as their parent"));
            for (Map.Entry<File, Model> entry : this.processAllModules ? reactor.entrySet() : PomHelper.getChildModels(reactor, (String)sourceGroupId, (String)sourceArtifactId).entrySet()) {
                Model targetModel = entry.getValue();
                Parent parent = targetModel.getParent();
                this.getLog().debug((CharSequence)("Module: " + entry.getKey()));
                if (parent != null && sourceVersion.equals(parent.getVersion())) {
                    this.getLog().debug((CharSequence)("    parent already is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                } else {
                    this.getLog().debug((CharSequence)("    parent is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + (parent == null ? "" : parent.getVersion())));
                    this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                }
                boolean targetExplicit = PomHelper.isExplicitVersion((Model)targetModel);
                if ((this.updateMatchingVersions || !targetExplicit) && parent != null && StringUtils.equals((String)parent.getVersion(), (String)PomHelper.getVersion((Model)targetModel))) {
                    this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId((Model)targetModel), (String)PomHelper.getArtifactId((Model)targetModel)) + ":" + PomHelper.getVersion((Model)targetModel)));
                    this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId((Model)targetModel), (String)PomHelper.getArtifactId((Model)targetModel)) + ":" + sourceVersion));
                    this.addChange(PomHelper.getGroupId((Model)targetModel), PomHelper.getArtifactId((Model)targetModel), PomHelper.getVersion((Model)targetModel), sourceVersion);
                    targetModel.setVersion(sourceVersion);
                    continue;
                }
                this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId((Model)targetModel), (String)PomHelper.getArtifactId((Model)targetModel)) + ":" + PomHelper.getVersion((Model)targetModel)));
            }
        }
    }

    @Override
    protected synchronized void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        DelegatingContextualLog log = new DelegatingContextualLog(this.getLog());
        try {
            Model model = PomHelper.getRawModel((ModifiedPomXMLEventReader)pom);
            log.setContext("Processing " + PomHelper.getGroupId((Model)model) + ":" + PomHelper.getArtifactId((Model)model));
            VersionChangerFactory versionChangerFactory = new VersionChangerFactory();
            versionChangerFactory.setPom(pom);
            versionChangerFactory.setLog((Log)log);
            versionChangerFactory.setModel(model);
            VersionChanger changer = versionChangerFactory.newVersionChanger(this.processParent, this.processProject, this.processDependencies, this.processPlugins);
            for (DefaultVersionChange versionChange : this.sourceChanges) {
                changer.apply((VersionChange)versionChange);
            }
            if (this.updateBuildOutputTimestamp && !"never".equals(this.updateBuildOutputTimestampPolicy) && ("always".equals(this.updateBuildOutputTimestampPolicy) || !this.sourceChanges.isEmpty())) {
                this.updateBuildOutputTimestamp(pom, model);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        log.clearContext();
    }

    private void updateBuildOutputTimestamp(ModifiedPomXMLEventReader pom, Model model) throws XMLStreamException {
        String buildOutputTimestamp = model.getProperties().getProperty("project.build.outputTimestamp");
        if (buildOutputTimestamp == null || StringUtils.isEmpty((String)buildOutputTimestamp)) {
            return;
        }
        if (StringUtils.isNumeric((String)buildOutputTimestamp)) {
            buildOutputTimestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        } else {
            if (buildOutputTimestamp.length() <= 1) {
                return;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            buildOutputTimestamp = df.format(new Date());
        }
        PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)pom, null, (String)"project.build.outputTimestamp", (String)buildOutputTimestamp);
    }
}

