/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.MediaType;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class MediaSource
extends AbstractPacketExtension {
    public static final String ELEMENT = "media-source";
    public static final String NAMESPACE = "jitsi:colibri2";
    public static final QName QNAME = new QName("jitsi:colibri2", "media-source");
    public static final String ID_NAME = "id";
    public static final String TYPE_ATTR_NAME = "type";

    public MediaSource() {
        super(NAMESPACE, ELEMENT);
    }

    private MediaSource(Builder b) {
        super(NAMESPACE, ELEMENT);
        if (b.type == null) {
            throw new IllegalArgumentException("Source media type must be set");
        }
        this.setAttribute(TYPE_ATTR_NAME, b.type.toString());
        if (b.id == null) {
            throw new IllegalArgumentException("Source ID must be set.");
        }
        this.setAttribute(ID_NAME, b.id);
        for (SourcePacketExtension s : b.sources) {
            this.addChildExtension(s);
        }
        for (SourceGroupPacketExtension sg : b.ssrcGroups) {
            this.addChildExtension(sg);
        }
    }

    @NotNull
    public String getId() {
        return this.getAttributeAsString(ID_NAME);
    }

    @NotNull
    public MediaType getType() {
        return MediaType.parseString((String)this.getAttributeAsString(TYPE_ATTR_NAME));
    }

    @NotNull
    public List<SourcePacketExtension> getSources() {
        return this.getChildExtensionsOfType(SourcePacketExtension.class);
    }

    @NotNull
    public List<SourceGroupPacketExtension> getSsrcGroups() {
        return this.getChildExtensionsOfType(SourceGroupPacketExtension.class);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Provider
    extends DefaultPacketExtensionProvider<MediaSource> {
        public Provider() {
            super(MediaSource.class);
        }

        @Override
        public MediaSource parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            MediaSource ms = (MediaSource)super.parse(parser, depth, xmlEnvironment);
            String type = ms.getAttributeAsString(MediaSource.TYPE_ATTR_NAME);
            if (type == null) {
                throw new SmackParsingException.RequiredAttributeMissingException(MediaSource.TYPE_ATTR_NAME);
            }
            try {
                MediaType.parseString((String)type);
            }
            catch (IllegalArgumentException e) {
                throw new SmackParsingException("type:" + e.getMessage());
            }
            if (ms.getId() == null) {
                throw new SmackParsingException.RequiredAttributeMissingException(MediaSource.ID_NAME);
            }
            return ms;
        }
    }

    public static final class Builder {
        MediaType type = null;
        String id = null;
        private final List<SourcePacketExtension> sources = new ArrayList<SourcePacketExtension>();
        private final List<SourceGroupPacketExtension> ssrcGroups = new ArrayList<SourceGroupPacketExtension>();

        public Builder setType(@NotNull MediaType t) {
            this.type = t;
            return this;
        }

        public Builder setId(@NotNull String id) {
            this.id = id;
            return this;
        }

        public Builder addSource(@NotNull SourcePacketExtension pt) {
            this.sources.add(pt);
            return this;
        }

        public Builder addSsrcGroup(@NotNull SourceGroupPacketExtension ext) {
            this.ssrcGroups.add(ext);
            return this;
        }

        private Builder() {
        }

        @Contract(value=" -> new")
        @NotNull
        public MediaSource build() {
            return new MediaSource(this);
        }
    }
}

