/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger;

import java.util.concurrent.Callable;
import org.sonatype.sisu.charger.ExceptionHandler;
import org.sonatype.sisu.charger.internal.Check;

public class ExceptionHandlingCallable<E>
implements Callable<E>,
ExceptionHandler {
    private final Callable<E> callable;
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandlingCallable(Callable<E> callable, ExceptionHandler exceptionHandler) {
        this.callable = Check.notNull(callable, "Callable is null!");
        this.exceptionHandler = Check.notNull(exceptionHandler, "ExceptionHandler is null!");
    }

    @Override
    public E call() throws Exception {
        return this.callable.call();
    }

    @Override
    public boolean handle(Exception ex) {
        return this.exceptionHandler.handle(ex);
    }
}

