/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;

public class ImageToBuffer {
    private static BufferedImage convert(Image im) {
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Buffer createBuffer(Image image, float frameRate) {
        void var4_8;
        int blue;
        int green;
        int red;
        int bitsPerPixel;
        Class<?> dataType;
        int pixelsLength;
        BufferedImage bi = image instanceof BufferedImage ? (BufferedImage)image : ImageToBuffer.convert(image);
        DataBuffer dataBuffer = bi.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            int[] intPixels;
            int[] nArray = intPixels = ((DataBufferInt)dataBuffer).getData();
            pixelsLength = intPixels.length;
            dataType = Format.intArray;
        } else {
            byte[] bytePixels;
            if (!(dataBuffer instanceof DataBufferByte)) throw new IllegalArgumentException("Unknown or unsupported data buffer type: " + dataBuffer);
            byte[] byArray = bytePixels = ((DataBufferByte)dataBuffer).getData();
            pixelsLength = bytePixels.length;
            dataType = Format.byteArray;
        }
        int bufferedImageType = bi.getType();
        Buffer result = new Buffer();
        Dimension size = new Dimension(bi.getWidth(), bi.getHeight());
        int maxDataLength = -1;
        if (bufferedImageType == 5) {
            bitsPerPixel = 24;
            red = 1;
            green = 2;
            blue = 3;
        } else if (bufferedImageType == 4) {
            bitsPerPixel = 32;
            red = 255;
            green = 65280;
            blue = 0xFF0000;
        } else if (bufferedImageType == 1) {
            bitsPerPixel = 32;
            red = 0xFF0000;
            green = 65280;
            blue = 255;
        } else if (bufferedImageType == 2) {
            bitsPerPixel = 32;
            red = 0xFF0000;
            green = 65280;
            blue = 255;
        } else if (bi.getColorModel() instanceof ComponentColorModel && bi.getSampleModel() instanceof ComponentSampleModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)bi.getColorModel();
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bi.getSampleModel();
            int[] offsets = componentSampleModel.getBandOffsets();
            if (dataBuffer instanceof DataBufferInt) {
                bitsPerPixel = 32;
                red = 255 << offsets[0];
                green = 255 << offsets[1];
                blue = 255 << offsets[2];
            } else {
                if (!(dataBuffer instanceof DataBufferByte)) throw new IllegalArgumentException("Unsupported buffered image type: " + bufferedImageType);
                bitsPerPixel = componentSampleModel.getPixelStride() * 8;
                red = 1 + offsets[0];
                green = 1 + offsets[1];
                blue = 1 + offsets[2];
            }
        } else {
            if (!(bi.getColorModel() instanceof DirectColorModel)) throw new IllegalArgumentException("Unsupported buffered image type: " + bufferedImageType);
            DirectColorModel directColorModel = (DirectColorModel)bi.getColorModel();
            if (!(dataBuffer instanceof DataBufferInt)) throw new IllegalArgumentException("Unsupported buffered image type: " + bufferedImageType);
            bitsPerPixel = 32;
            red = directColorModel.getRedMask();
            green = directColorModel.getGreenMask();
            blue = directColorModel.getBlueMask();
        }
        result.setFormat(new RGBFormat(size, -1, dataType, frameRate, bitsPerPixel, red, green, blue));
        result.setData(var4_8);
        result.setLength(pixelsLength);
        result.setOffset(0);
        return result;
    }
}

