/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.address.SipUri;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sip.address.Address;
import net.java.sip.communicator.impl.protocol.sip.ContactGroupSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ServerStoredContactList;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.Sha1Crypto;
import org.jitsi.util.OSUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ServerStoredContactListXivoImpl
extends ServerStoredContactList
implements Runnable {
    private static final Logger logger = Logger.getLogger(ServerStoredContactListXivoImpl.class);
    private Socket connection;
    private BufferedReader connectionReader;
    private PrintStream connectionWriter;
    private boolean stopped = false;

    ServerStoredContactListXivoImpl(ProtocolProviderServiceSipImpl sipProvider, OperationSetPresenceSipImpl parentOperationSet) {
        super(sipProvider, parentOperationSet);
    }

    @Override
    public void init() {
        try {
            SipAccountIDImpl accountID = (SipAccountIDImpl)this.sipProvider.getAccountID();
            if (!accountID.isXiVOEnable()) {
                return;
            }
            boolean useSipCredentials = accountID.isClistOptionUseSipCredentials();
            String serverAddress = accountID.getClistOptionServerUri();
            String username = accountID.getAccountPropertyString("USER_ID");
            Address userAddress = this.sipProvider.parseAddressString(username);
            username = useSipCredentials ? ((SipUri)userAddress.getURI()).getUser() : accountID.getClistOptionUser();
            try {
                this.connect(serverAddress);
            }
            catch (Throwable ex) {
                ServerStoredContactListXivoImpl.showError(ex, null, null);
                logger.error((Object)"Error connecting to server", ex);
                return;
            }
            Thread thread = new Thread((Runnable)this, this.getClass().getName());
            thread.setDaemon(true);
            thread.start();
            if (!this.login(username)) {
                ServerStoredContactListXivoImpl.showError(null, null, "Unauthorized. Cannot login.");
                logger.error((Object)"Cannot login.");
                return;
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error init clist from xivo server");
        }
    }

    private void connect(String serverAddress) throws IOException {
        this.connection = serverAddress != null ? new Socket(serverAddress, 5003) : new Socket(this.sipProvider.getConnection().getAddress().getAddress(), 5003);
        this.connectionWriter = new PrintStream(this.connection.getOutputStream());
    }

    @Override
    public void destroy() {
        this.stopped = true;
        try {
            if (this.connection != null) {
                this.connection.shutdownInput();
                this.connection.close();
                this.connection = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.connectionReader != null) {
                this.connectionReader.close();
                this.connectionReader = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.connectionWriter != null) {
            this.connectionWriter.close();
            this.connectionWriter = null;
        }
    }

    @Override
    public void run() {
        if (this.connection == null) {
            logger.error((Object)"No connection.");
            return;
        }
        try {
            String line;
            this.connectionReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            if (!this.connectionReader.readLine().contains("XiVO")) {
                logger.error((Object)"Error xivo with server!");
                this.destroy();
                return;
            }
            while ((line = this.connectionReader.readLine()) != null || !this.stopped) {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Read from server:" + line));
                    }
                    this.handle((JSONObject)JSONValue.parseWithException((String)line));
                }
                catch (Throwable ex) {
                    logger.error((Object)("Error parsing object:" + line), ex);
                }
            }
        }
        catch (IOException ex) {
            this.destroy();
        }
    }

    @Override
    public URI getImageUri() {
        return null;
    }

    @Override
    public byte[] getImage(URI imageUri) {
        return new byte[0];
    }

    @Override
    public ContactGroupSipImpl createGroup(ContactGroupSipImpl parentGroup, String groupName, boolean persistent) throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public void renameGroup(ContactGroupSipImpl group, String newName) {
    }

    @Override
    public void moveContactToGroup(ContactSipImpl contact, ContactGroupSipImpl newParentGroup) throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public void removeGroup(ContactGroupSipImpl group) {
    }

    @Override
    public ContactSipImpl createContact(ContactGroupSipImpl parentGroup, String contactId, String displayName, boolean persistent, String contactType) throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public void removeContact(ContactSipImpl contact) throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public void renameContact(ContactSipImpl contact, String newName) {
    }

    @Override
    public void authorizationAccepted(ContactSipImpl contact) {
    }

    @Override
    public void authorizationRejected(ContactSipImpl contact) {
    }

    @Override
    public void authorizationIgnored(ContactSipImpl contact) {
    }

    @Override
    public ServerStoredDetails.ImageDetail getAccountImage() throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public void deleteAccountImage() throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public void setAccountImage(byte[] newImageBytes) throws OperationFailedException {
        throw new OperationFailedException("Modification not supported.", 18);
    }

    @Override
    public boolean isAccountImageSupported() {
        return false;
    }

    private void handle(JSONObject incomingObject) {
        if (!incomingObject.containsKey((Object)"class")) {
            return;
        }
        try {
            String classField = (String)incomingObject.get((Object)"class");
            if (classField.equals("loginko")) {
                ServerStoredContactListXivoImpl.showError(null, null, "Unauthorized. Cannot login: " + incomingObject.get((Object)"errorstring"));
                logger.error((Object)("Error login: " + incomingObject.get((Object)"errorstring")));
                this.destroy();
                return;
            }
            if (classField.equals("login_id_ok")) {
                SipAccountIDImpl accountID = (SipAccountIDImpl)this.sipProvider.getAccountID();
                boolean useSipCredentials = accountID.isClistOptionUseSipCredentials();
                String password = useSipCredentials ? SipActivator.getProtocolProviderFactory().loadPassword((AccountID)accountID) : accountID.getClistOptionPassword();
                if (!this.authorize((String)incomingObject.get((Object)"sessionid"), password)) {
                    logger.error((Object)"Error login authorization!");
                }
                return;
            }
            if (classField.equals("login_pass_ok")) {
                if (!this.sendCapas((JSONArray)incomingObject.get((Object)"capalist"))) {
                    logger.error((Object)"Error send capas!");
                }
                return;
            }
            if (classField.equals("login_capas_ok")) {
                if (!this.sendFeatures((String)incomingObject.get((Object)"astid"), (String)incomingObject.get((Object)"xivo_userid"))) {
                    logger.error((Object)"Problem send features get!");
                }
                return;
            }
            if (classField.equals("features")) {
                if (!this.getPhoneList()) {
                    logger.error((Object)"Problem send get phones!");
                }
                return;
            }
            if (classField.equals("phones")) {
                this.phonesRecieved(incomingObject);
                return;
            }
            if (classField.equals("disconn")) {
                this.destroy();
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("unhandled classField: " + incomingObject));
            }
            return;
        }
        catch (Throwable t) {
            logger.error((Object)"Error handling incoming object", t);
            return;
        }
    }

    private boolean login(String username) {
        if (this.connection == null || username == null) {
            return false;
        }
        JSONObject obj = new JSONObject();
        try {
            obj.put((Object)"class", (Object)"login_id");
            obj.put((Object)"company", (Object)"Jitsi");
            String os = "x11";
            if (OSUtils.IS_WINDOWS) {
                os = "win";
            } else if (OSUtils.IS_MAC) {
                os = "mac";
            }
            obj.put((Object)"ident", (Object)(username + "@" + os));
            obj.put((Object)"userid", (Object)username);
            obj.put((Object)"version", (Object)"9999");
            obj.put((Object)"xivoversion", (Object)"1.1");
            return this.send(obj);
        }
        catch (Exception e) {
            logger.error((Object)"Error login", (Throwable)e);
            return false;
        }
    }

    private boolean authorize(String sessionId, String password) {
        if (this.connection == null || sessionId == null || password == null) {
            return false;
        }
        JSONObject obj = new JSONObject();
        try {
            obj.put((Object)"class", (Object)"login_pass");
            obj.put((Object)"hashedpassword", (Object)Sha1Crypto.encode((String)(sessionId + ":" + password)));
            return this.send(obj);
        }
        catch (Exception e) {
            logger.error((Object)"Error login with password", (Throwable)e);
            return false;
        }
    }

    private boolean sendCapas(JSONArray capalistParam) {
        if (this.connection == null || capalistParam == null || capalistParam.isEmpty()) {
            return false;
        }
        JSONObject obj = new JSONObject();
        try {
            obj.put((Object)"class", (Object)"login_capas");
            obj.put((Object)"capaid", capalistParam.get(0));
            obj.put((Object)"lastconnwins", (Object)"false");
            obj.put((Object)"loginkind", (Object)"agent");
            obj.put((Object)"state", (Object)"");
            return this.send(obj);
        }
        catch (Exception e) {
            logger.error((Object)"Error login", (Throwable)e);
            return false;
        }
    }

    private boolean sendFeatures(String astid, String xivoUserId) {
        if (this.connection == null || astid == null || xivoUserId == null) {
            return false;
        }
        JSONObject obj = new JSONObject();
        try {
            obj.put((Object)"class", (Object)"featuresget");
            obj.put((Object)"userid", (Object)(astid + "/" + xivoUserId));
            return this.send(obj);
        }
        catch (Exception e) {
            logger.error((Object)"Error send features get command", (Throwable)e);
            return false;
        }
    }

    private boolean getPhoneList() {
        JSONObject obj = new JSONObject();
        try {
            obj.put((Object)"class", (Object)"phones");
            obj.put((Object)"function", (Object)"getlist");
            return this.send(obj);
        }
        catch (Exception e) {
            logger.error((Object)"Error retrieving phones");
            return false;
        }
    }

    private boolean send(JSONObject obj) {
        if (this.connection == null || this.connectionWriter == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Send to server:" + obj));
        }
        this.connectionWriter.println(obj);
        return true;
    }

    private void phonesRecieved(JSONObject objReceived) {
        try {
            if (!objReceived.get((Object)"function").equals("sendlist") || !objReceived.containsKey((Object)"payload")) {
                return;
            }
            JSONObject payload = (JSONObject)objReceived.get((Object)"payload");
            Iterator iter = payload.keySet().iterator();
            ArrayList<JSONObject> phoneList = new ArrayList<JSONObject>();
            while (iter.hasNext()) {
                JSONObject obj = (JSONObject)payload.get(iter.next());
                Iterator phonesIter = obj.keySet().iterator();
                while (phonesIter.hasNext()) {
                    phoneList.add((JSONObject)obj.get(phonesIter.next()));
                }
            }
            for (JSONObject phone : phoneList) {
                try {
                    String number;
                    Address address;
                    ContactSipImpl contact;
                    if (!((String)phone.get((Object)"tech")).equalsIgnoreCase("sip")) continue;
                    String groupName = (String)phone.get((Object)"context");
                    ContactGroupSipImpl parentGroup = this.findGroupByName(groupName);
                    if (parentGroup == null) {
                        parentGroup = new ContactGroupSipImpl(groupName, this.sipProvider);
                        parentGroup.setPersistent(true);
                        this.getRootGroup().addSubgroup(parentGroup);
                        this.fireGroupEvent(parentGroup, 1);
                    }
                    if ((contact = this.parentOperationSet.resolveContactID((address = this.sipProvider.parseAddressString(number = (String)phone.get((Object)"number"))).toString())) == null) {
                        contact = new ContactSipImpl(address, this.sipProvider);
                        contact.setDisplayName(phone.get((Object)"firstname") + " " + phone.get((Object)"lastname"));
                        contact.setResolved(true);
                        parentGroup.addContact(contact);
                        this.fireContactAdded(parentGroup, contact);
                        continue;
                    }
                    contact.setDisplayName(phone.get((Object)"firstname") + " " + phone.get((Object)"lastname"));
                    contact.setResolved(true);
                    this.fireContactResolved(parentGroup, contact);
                }
                catch (Throwable t) {
                    logger.error((Object)("Error parsing " + phone));
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error init list from server", t);
        }
    }

    static void showError(Throwable ex, String title, String message) {
        try {
            if (title == null) {
                title = "Error in SIP contactlist storage";
            }
            if (message == null) {
                message = title + "\n" + ex.getClass().getName() + ": " + ex.getLocalizedMessage();
            }
            if (SipActivator.getUIService() != null) {
                SipActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)message, title, 0);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error for error dialog", t);
        }
    }
}

