/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.Dictionary;
import java.util.Hashtable;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderFactorySipImpl;
import net.java.sip.communicator.impl.protocol.sip.UriHandlerSipImpl;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.hid.HIDService;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.utils.version.VersionService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class SipActivator
implements BundleActivator {
    private Logger logger = Logger.getLogger((String)SipActivator.class.getName());
    private ServiceRegistration sipPpFactoryServReg = null;
    static BundleContext bundleContext = null;
    private static ConfigurationService configurationService = null;
    private static NetworkAddressManagerService networkAddressManagerService = null;
    private static MediaService mediaService = null;
    private static VersionService versionService = null;
    private static UIService uiService = null;
    private static HIDService hidService = null;
    private static PacketLoggingService packetLoggingService = null;
    private static CertificateService certService = null;
    private static FileAccessService fileService = null;
    private static ResourceManagementService resources = null;
    private static ProtocolProviderFactorySipImpl sipProviderFactory = null;
    private UriHandlerSipImpl uriHandlerSipImpl = null;

    public void start(BundleContext context) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Started.");
        }
        bundleContext = context;
        sipProviderFactory = this.createProtocolProviderFactory();
        this.uriHandlerSipImpl = new UriHandlerSipImpl(sipProviderFactory);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("PROTOCOL_NAME", "SIP");
        this.sipPpFactoryServReg = context.registerService(ProtocolProviderFactory.class.getName(), (Object)sipProviderFactory, properties);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"SIP Protocol Provider Factory ... [REGISTERED]");
        }
    }

    protected ProtocolProviderFactorySipImpl createProtocolProviderFactory() {
        return new ProtocolProviderFactorySipImpl();
    }

    public static CertificateService getCertificateVerificationService() {
        ServiceReference guiVerifyReference;
        if (certService == null && (guiVerifyReference = bundleContext.getServiceReference(CertificateService.class.getName())) != null) {
            certService = (CertificateService)bundleContext.getService(guiVerifyReference);
        }
        return certService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
            configurationService = (ConfigurationService)bundleContext.getService(confReference);
        }
        return configurationService;
    }

    public static NetworkAddressManagerService getNetworkAddressManagerService() {
        if (networkAddressManagerService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(NetworkAddressManagerService.class.getName());
            networkAddressManagerService = (NetworkAddressManagerService)bundleContext.getService(confReference);
        }
        return networkAddressManagerService;
    }

    public static HIDService getHIDService() {
        if (hidService == null) {
            ServiceReference hidReference = bundleContext.getServiceReference(HIDService.class.getName());
            if (hidReference == null) {
                return null;
            }
            hidService = (HIDService)bundleContext.getService(hidReference);
        }
        return hidService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public static ProtocolProviderFactorySipImpl getProtocolProviderFactory() {
        return sipProviderFactory;
    }

    public static MediaService getMediaService() {
        if (mediaService == null) {
            ServiceReference mediaServiceReference = bundleContext.getServiceReference(MediaService.class.getName());
            mediaService = (MediaService)bundleContext.getService(mediaServiceReference);
        }
        return mediaService;
    }

    public static VersionService getVersionService() {
        if (versionService == null) {
            ServiceReference versionServiceReference = bundleContext.getServiceReference(VersionService.class.getName());
            versionService = (VersionService)bundleContext.getService(versionServiceReference);
        }
        return versionService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            ServiceReference uiServiceReference = bundleContext.getServiceReference(UIService.class.getName());
            uiService = (UIService)bundleContext.getService(uiServiceReference);
        }
        return uiService;
    }

    public static ResourceManagementService getResources() {
        if (resources == null) {
            resources = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resources;
    }

    public static PacketLoggingService getPacketLogging() {
        if (packetLoggingService == null) {
            packetLoggingService = (PacketLoggingService)ServiceUtils.getService((BundleContext)bundleContext, PacketLoggingService.class);
        }
        return packetLoggingService;
    }

    public static FileAccessService getFileAccessService() {
        if (fileService == null) {
            fileService = (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
        }
        return fileService;
    }

    public void stop(BundleContext context) throws Exception {
        sipProviderFactory.stop();
        this.sipPpFactoryServReg.unregister();
        if (this.uriHandlerSipImpl != null) {
            this.uriHandlerSipImpl.dispose();
            this.uriHandlerSipImpl = null;
        }
        configurationService = null;
        networkAddressManagerService = null;
        mediaService = null;
        versionService = null;
        uiService = null;
        hidService = null;
        packetLoggingService = null;
        certService = null;
        fileService = null;
    }
}

