/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.net.NoRouteToHostException;
import java.time.Duration;
import java.util.List;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.ResponseCollector;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.PriorityAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.attribute.XorMappedAddressAttribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.PeerReflexiveCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.message.Indication;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;
import org.ice4j.util.PeriodicRunnable;

class ConnectivityCheckClient
implements ResponseCollector {
    private static final Logger classLogger = Logger.getLogger(ConnectivityCheckClient.class.getName());
    private final Agent parentAgent;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorService executorService;
    private final StunStack stunStack;
    private final Queue<PaceMaker> paceMakers = new ConcurrentLinkedQueue<PaceMaker>();
    private ConcurrentMap<String, ScheduledFuture<?>> checkListCompletionCheckers = new ConcurrentHashMap();
    private boolean alive = false;
    private org.ice4j.util.Logger logger;

    public ConnectivityCheckClient(Agent parentAgent, ScheduledExecutorService scheduledExecutorService, ExecutorService executorService) {
        this.parentAgent = parentAgent;
        this.scheduledExecutorService = scheduledExecutorService;
        this.executorService = executorService;
        this.logger = new org.ice4j.util.Logger(classLogger, parentAgent.getLogger());
        this.stunStack = this.parentAgent.getStunStack();
    }

    boolean isAlive() {
        return this.alive;
    }

    public void startChecks() {
        List<IceMediaStream> streamsWithPendingConnectivityEstablishment = this.parentAgent.getStreamsWithPendingConnectivityEstablishment();
        if (streamsWithPendingConnectivityEstablishment.size() > 0) {
            this.logger.info("Start connectivity checks. Local ufrag " + this.parentAgent.getLocalUfrag());
            this.startChecks(streamsWithPendingConnectivityEstablishment.get(0).getCheckList());
        } else {
            this.logger.info("Not starting any checks, because there are no pending streams.");
        }
    }

    public void startChecks(CheckList checkList) {
        PaceMaker paceMaker = new PaceMaker(checkList);
        this.paceMakers.add(paceMaker);
        paceMaker.schedule();
    }

    protected void sendBindingIndicationForPair(CandidatePair candidatePair) {
        block3: {
            LocalCandidate localCandidate = candidatePair.getLocalCandidate();
            Indication indication = MessageFactory.createBindingIndication();
            try {
                this.stunStack.sendIndication(indication, candidatePair.getRemoteCandidate().getTransportAddress(), ((LocalCandidate)localCandidate.getBase()).getTransportAddress());
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("sending binding indication to pair " + candidatePair);
                }
            }
            catch (Exception ex) {
                IceSocketWrapper stunSocket = localCandidate.getStunSocket(null);
                if (stunSocket == null) break block3;
                this.logger.log(Level.INFO, "Failed to send " + indication + " through " + stunSocket.getLocalSocketAddress(), ex);
            }
        }
    }

    protected TransactionID startCheckForPair(CandidatePair candidatePair) {
        return this.startCheckForPair(candidatePair, -1, -1, -1);
    }

    protected TransactionID startCheckForPair(CandidatePair candidatePair, int originalWaitInterval, int maxWaitInterval, int maxRetransmissions) {
        TransactionID tran;
        block8: {
            String media;
            String localUserName;
            LocalCandidate localCandidate = candidatePair.getLocalCandidate();
            Request request = MessageFactory.createBindingRequest();
            PriorityAttribute priority = AttributeFactory.createPriorityAttribute(localCandidate.computePriorityForType(CandidateType.PEER_REFLEXIVE_CANDIDATE));
            request.putAttribute(priority);
            if (this.parentAgent.isControlling()) {
                request.putAttribute(AttributeFactory.createIceControllingAttribute(this.parentAgent.getTieBreaker()));
                if (candidatePair.isNominated()) {
                    this.logger.fine("Add USE-CANDIDATE in check for: " + candidatePair.toShortString());
                    request.putAttribute(AttributeFactory.createUseCandidateAttribute());
                }
            } else {
                request.putAttribute(AttributeFactory.createIceControlledAttribute(this.parentAgent.getTieBreaker()));
            }
            if ((localUserName = this.parentAgent.generateLocalUserName(media = candidatePair.getParentComponent().getParentStream().getName())) == null) {
                return null;
            }
            UsernameAttribute unameAttr = AttributeFactory.createUsernameAttribute(localUserName);
            request.putAttribute(unameAttr);
            MessageIntegrityAttribute msgIntegrity = AttributeFactory.createMessageIntegrityAttribute(localUserName);
            msgIntegrity.setMedia(media);
            request.putAttribute(msgIntegrity);
            tran = TransactionID.createNewTransactionID();
            tran.setApplicationData(candidatePair);
            this.logger.fine("start check for " + candidatePair.toShortString() + " tid " + tran);
            try {
                tran = this.stunStack.sendRequest(request, candidatePair.getRemoteCandidate().getTransportAddress(), ((LocalCandidate)localCandidate.getBase()).getTransportAddress(), this, tran, originalWaitInterval, maxWaitInterval, maxRetransmissions);
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("checking pair " + candidatePair + " tid " + tran);
                }
            }
            catch (Exception ex2) {
                Object ex2;
                tran = null;
                IceSocketWrapper stunSocket = localCandidate.getStunSocket(null);
                if (stunSocket == null) break block8;
                String msg = "Failed to send " + request + " through " + stunSocket.getLocalSocketAddress() + ".";
                if (ex2 instanceof NoRouteToHostException || ex2.getMessage() != null && ex2.getMessage().equals("No route to host")) {
                    msg = msg + " No route to host.";
                    ex2 = null;
                }
                this.logger.log(Level.INFO, msg, ex2);
            }
        }
        return tran;
    }

    @Override
    public void processResponse(StunResponseEvent ev) {
        this.alive = true;
        CandidatePair checkedPair = (CandidatePair)ev.getTransactionID().getApplicationData();
        if (!this.checkSymmetricAddresses(ev)) {
            this.logger.info("Received a non-symmetric response for pair: " + checkedPair.toShortString() + ". Failing.");
            checkedPair.setStateFailed();
        } else {
            Response response = ev.getResponse();
            char messageType = response.getMessageType();
            if (messageType == '\u0111') {
                if (!response.containsAttribute('\t')) {
                    this.logger.fine("Received a malformed error response.");
                    return;
                }
                this.processErrorResponse(ev);
            } else if (messageType == '\u0101') {
                this.processSuccessResponse(ev);
            }
        }
        this.updateCheckListAndTimerStates(checkedPair);
    }

    private void updateCheckListAndTimerStates(CandidatePair checkedPair) {
        IceMediaStream stream = checkedPair.getParentComponent().getParentStream();
        final CheckList checkList = stream.getCheckList();
        if (stream.getParentAgent().getState().isEstablished()) {
            return;
        }
        if (checkList.allChecksCompleted()) {
            String streamName;
            if (!stream.validListContainsAllComponents() && !this.checkListCompletionCheckers.containsKey(streamName = stream.getName())) {
                this.logger.info("CheckList will failed in a few seconds if no succeeded checks come");
                Runnable checkLickCompletedChecker = new Runnable(){

                    @Override
                    public void run() {
                        if (checkList.getState() != CheckListState.COMPLETED) {
                            ConnectivityCheckClient.this.logger.info("CheckList for stream " + streamName + " FAILED");
                            checkList.setState(CheckListState.FAILED);
                            ConnectivityCheckClient.this.parentAgent.checkListStatesUpdated();
                        }
                    }
                };
                ScheduledFuture<?> scheduledCheckerFuture = this.scheduledExecutorService.schedule(checkLickCompletedChecker, 5000L, TimeUnit.MILLISECONDS);
                ScheduledFuture<?> existingCheckerFuture = this.checkListCompletionCheckers.putIfAbsent(streamName, scheduledCheckerFuture);
                if (existingCheckerFuture != null) {
                    scheduledCheckerFuture.cancel(false);
                }
            }
            List<IceMediaStream> allOtherStreams = this.parentAgent.getStreams();
            allOtherStreams.remove(stream);
            for (IceMediaStream anotherStream : allOtherStreams) {
                CheckList anotherCheckList = anotherStream.getCheckList();
                if (!anotherCheckList.isFrozen()) continue;
                anotherCheckList.computeInitialCheckListPairStates();
                this.startChecks(anotherCheckList);
            }
        }
        this.parentAgent.checkListStatesUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuccessResponse(StunResponseEvent ev) {
        CandidatePair existingPair;
        Object peerReflexiveCandidate;
        Object prioAttr;
        Response response = ev.getResponse();
        Request request = ev.getRequest();
        CandidatePair checkedPair = (CandidatePair)ev.getTransactionID().getApplicationData();
        TransportAddress mappedAddress = null;
        if (!response.containsAttribute(' ')) {
            this.logger.fine("Received a success response with no XOR_MAPPED_ADDRESS attribute.");
            this.logger.info("Pair failed (no XOR-MAPPED-ADDRESS): " + checkedPair.toShortString() + ". Local ufrag" + this.parentAgent.getLocalUfrag());
            checkedPair.setStateFailed();
            return;
        }
        XorMappedAddressAttribute mappedAddressAttr = (XorMappedAddressAttribute)response.getAttribute(' ');
        mappedAddress = mappedAddressAttr.getAddress(response.getTransactionID());
        if (checkedPair.getLocalCandidate().getTransport() == Transport.TCP) {
            mappedAddress = new TransportAddress(mappedAddress.getAddress(), mappedAddress.getPort(), Transport.TCP);
        }
        LocalCandidate validLocalCandidate = null;
        validLocalCandidate = this.parentAgent.findLocalCandidate(mappedAddress);
        RemoteCandidate validRemoteCandidate = checkedPair.getRemoteCandidate();
        if (validLocalCandidate == null) {
            long priority = 0L;
            prioAttr = (PriorityAttribute)request.getAttribute('$');
            priority = ((PriorityAttribute)prioAttr).getPriority();
            peerReflexiveCandidate = new PeerReflexiveCandidate(mappedAddress, checkedPair.getParentComponent(), checkedPair.getLocalCandidate(), priority);
            ((Candidate)peerReflexiveCandidate).setBase(checkedPair.getLocalCandidate());
            checkedPair.getParentComponent().addLocalCandidate((LocalCandidate)peerReflexiveCandidate);
            validLocalCandidate = peerReflexiveCandidate;
            if (checkedPair.getParentComponent().getSelectedPair() == null) {
                this.logger.info("Receive a peer-reflexive candidate: " + ((Candidate)peerReflexiveCandidate).getTransportAddress() + ". Local ufrag " + this.parentAgent.getLocalUfrag());
            }
        }
        CandidatePair validPair = (existingPair = this.parentAgent.findCandidatePair(validLocalCandidate.getTransportAddress(), validRemoteCandidate.getTransportAddress())) == null ? this.parentAgent.createCandidatePair(validLocalCandidate, validRemoteCandidate) : existingPair;
        prioAttr = checkedPair;
        synchronized (prioAttr) {
            if (checkedPair.getParentComponent().getSelectedPair() == null) {
                this.logger.info("Pair succeeded: " + checkedPair.toShortString() + ". Local ufrag " + this.parentAgent.getLocalUfrag());
            }
            checkedPair.setStateSucceeded();
        }
        if (!validPair.isValid()) {
            if (validPair.getParentComponent().getSelectedPair() == null) {
                this.logger.info("Pair validated: " + validPair.toShortString() + ". Local ufrag " + this.parentAgent.getLocalUfrag());
            }
            this.parentAgent.validatePair(validPair);
        }
        IceMediaStream parentStream = checkedPair.getParentComponent().getParentStream();
        peerReflexiveCandidate = this;
        synchronized (peerReflexiveCandidate) {
            Vector<CandidatePair> parentCheckList = new Vector<CandidatePair>(parentStream.getCheckList());
            for (CandidatePair pair : parentCheckList) {
                if (pair.getState() != CandidatePairState.FROZEN || !checkedPair.getFoundation().equals(pair.getFoundation())) continue;
                pair.setStateWaiting();
            }
        }
        List<IceMediaStream> allOtherStreams = this.parentAgent.getStreams();
        allOtherStreams.remove(parentStream);
        for (IceMediaStream stream : allOtherStreams) {
            CheckList checkList = stream.getCheckList();
            boolean wasFrozen = checkList.isFrozen();
            CheckList checkList2 = checkList;
            synchronized (checkList2) {
                for (CandidatePair pair : checkList) {
                    if (!parentStream.validListContainsFoundation(pair.getFoundation()) || pair.getState() != CandidatePairState.FROZEN) continue;
                    pair.setStateWaiting();
                }
            }
            if (checkList.isFrozen()) {
                checkList.computeInitialCheckListPairStates();
            }
            if (!wasFrozen) continue;
            this.logger.info("Start checks for checkList of stream " + stream.getName() + " that was frozen");
            this.startChecks(checkList);
        }
        if (validPair.getParentComponent().getSelectedPair() == null) {
            this.logger.info("IsControlling: " + this.parentAgent.isControlling() + " USE-CANDIDATE:" + (request.containsAttribute('%') || checkedPair.useCandidateSent()) + ". Local ufrag " + this.parentAgent.getLocalUfrag());
        }
        if (this.parentAgent.isControlling() && request.containsAttribute('%')) {
            if (validPair.getParentComponent().getSelectedPair() == null) {
                this.logger.info("Nomination confirmed for pair: " + validPair.toShortString() + ". Loal ufrag " + this.parentAgent.getLocalUfrag());
                this.parentAgent.nominationConfirmed(validPair);
            } else {
                this.logger.fine("Keep alive for pair: " + validPair.toShortString());
            }
        } else if (!this.parentAgent.isControlling() && checkedPair.useCandidateReceived() && !checkedPair.isNominated()) {
            if (checkedPair.getParentComponent().getSelectedPair() == null) {
                this.logger.info("Nomination confirmed for pair: " + validPair.toShortString());
                this.parentAgent.nominationConfirmed(checkedPair);
            } else {
                this.logger.fine("Keep alive for pair: " + validPair.toShortString());
            }
        }
        if (checkedPair.equals(checkedPair.getParentComponent().getSelectedPair())) {
            checkedPair.setConsentFreshness();
        }
    }

    private boolean checkSymmetricAddresses(StunResponseEvent evt) {
        CandidatePair pair = (CandidatePair)evt.getTransactionID().getApplicationData();
        TransportAddress localAddr = ((LocalCandidate)pair.getLocalCandidate().getBase()).getTransportAddress();
        return localAddr.equals(evt.getLocalAddress()) && pair.getRemoteCandidate().getTransportAddress().equals(evt.getRemoteAddress());
    }

    private void processErrorResponse(StunResponseEvent ev) {
        Response response = ev.getResponse();
        Request originalRequest = ev.getRequest();
        ErrorCodeAttribute errorAttr = (ErrorCodeAttribute)response.getAttribute('\t');
        byte cl = errorAttr.getErrorClass();
        int co = errorAttr.getErrorNumber() & 0xFF;
        char errorCode = errorAttr.getErrorCode();
        CandidatePair pair = (CandidatePair)ev.getTransactionID().getApplicationData();
        this.logger.finer("Received error code " + errorCode);
        if (errorCode == '\u01e7') {
            boolean wasControlling = originalRequest.containsAttribute('\u802a');
            this.logger.finer("Switching to isControlling=" + !wasControlling);
            this.parentAgent.setControlling(!wasControlling);
            pair.getParentComponent().getParentStream().getCheckList().scheduleTriggeredCheck(pair);
        } else {
            int code = cl * 100 + co;
            this.logger.info("Error response for pair: " + pair.toShortString() + ", failing.  Code = " + code + "(class=" + cl + "; number=" + co + ")");
            pair.setStateFailed();
        }
    }

    @Override
    public void processTimeout(StunTimeoutEvent ev) {
        CandidatePair pair = (CandidatePair)ev.getTransactionID().getApplicationData();
        this.logger.info("timeout for pair: " + pair.toShortString() + ", failing.");
        pair.setStateFailed();
        this.updateCheckListAndTimerStates(pair);
    }

    public void stop() {
        PaceMaker paceMaker;
        while ((paceMaker = this.paceMakers.poll()) != null) {
            paceMaker.cancel();
        }
    }

    private final class PaceMaker
    extends PeriodicRunnable {
        private final CheckList checkList;

        public PaceMaker(CheckList checkList) {
            super(ConnectivityCheckClient.this.scheduledExecutorService, ConnectivityCheckClient.this.executorService);
            this.checkList = checkList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run() {
            CandidatePair pairToCheck = this.checkList.popTriggeredCheck();
            if (pairToCheck == null) {
                pairToCheck = this.checkList.getNextOrdinaryPairToCheck();
            }
            if (pairToCheck != null) {
                CandidatePair candidatePair = pairToCheck;
                synchronized (candidatePair) {
                    TransactionID transactionID = ConnectivityCheckClient.this.startCheckForPair(pairToCheck);
                    if (transactionID == null) {
                        ConnectivityCheckClient.this.logger.info("Pair failed: " + pairToCheck.toShortString());
                        pairToCheck.setStateFailed();
                    } else {
                        pairToCheck.setStateInProgress(transactionID);
                    }
                }
            } else {
                ConnectivityCheckClient.this.logger.finest("will skip a check beat.");
                this.checkList.fireEndOfOrdinaryChecks();
            }
        }

        @Override
        protected Duration getDelayUntilNextRun() {
            int activeCheckLists = ConnectivityCheckClient.this.parentAgent.getActiveCheckListCount();
            if (activeCheckLists < 1) {
                activeCheckLists = 1;
            }
            return Duration.ofMillis(ConnectivityCheckClient.this.parentAgent.calculateTa() * (long)activeCheckLists);
        }
    }
}

