/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.logging.Logger;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingSocket;
import org.ice4j.socket.MultiplexedSocket;
import org.ice4j.socket.MultiplexingXXXSocketSupport;
import org.ice4j.socket.SocketReceiveBuffer;
import org.ice4j.socket.TCPInputStream;
import org.ice4j.socket.TCPOutputStream;

public class MultiplexingSocket
extends DelegatingSocket {
    private static final Logger logger = Logger.getLogger(MultiplexingSocket.class.getName());
    private final InputStream inputStream = new TCPInputStream(this);
    private final MultiplexingXXXSocketSupport<MultiplexedSocket> multiplexingXXXSocketSupport = new MultiplexingXXXSocketSupport<MultiplexedSocket>(){

        @Override
        protected MultiplexedSocket createSocket(DatagramPacketFilter filter) throws SocketException {
            return new MultiplexedSocket(MultiplexingSocket.this, filter);
        }

        @Override
        protected void doReceive(DatagramPacket p) throws IOException {
            MultiplexingSocket.this.multiplexingXXXSocketSupportDoReceive(p);
        }

        @Override
        protected void doSetReceiveBufferSize(int receiveBufferSize) throws SocketException {
            MultiplexingSocket.this.multiplexingXXXSocketSupportDoSetReceiveBufferSize(receiveBufferSize);
        }

        @Override
        protected SocketReceiveBuffer getReceived() {
            return MultiplexingSocket.this.received;
        }

        @Override
        protected SocketReceiveBuffer getReceived(MultiplexedSocket socket) {
            return socket.received;
        }
    };
    private TCPOutputStream outputStream = null;
    private final SocketReceiveBuffer received = new SocketReceiveBuffer(this::getReceiveBufferSize);
    private int soTimeout = 0;

    public MultiplexingSocket() {
        this((Socket)null);
    }

    public MultiplexingSocket(InetAddress address, int port) {
        this((Socket)null);
    }

    public MultiplexingSocket(InetAddress address, int port, InetAddress localAddr, int localPort) {
        this((Socket)null);
    }

    public MultiplexingSocket(Proxy proxy) {
        this((Socket)null);
    }

    public MultiplexingSocket(Socket socket) {
        super(socket);
        try {
            this.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            logger.info("Cannot SO_TCPNODELAY");
        }
    }

    protected MultiplexingSocket(SocketImpl impl) {
        this((Socket)null);
    }

    public MultiplexingSocket(String host, int port) {
        this((Socket)null);
    }

    public MultiplexingSocket(String host, int port, InetAddress localAddr, int localPort) {
        this((Socket)null);
    }

    void close(MultiplexedSocket multiplexed) {
        this.multiplexingXXXSocketSupport.close(multiplexed);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public InputStream getOriginalInputStream() throws IOException {
        return super.getInputStream();
    }

    public OutputStream getOriginalOutputStream() throws IOException {
        return super.getOutputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new TCPOutputStream(super.getOutputStream());
        }
        return this.outputStream;
    }

    public MultiplexedSocket getSocket(DatagramPacketFilter filter) throws SocketException {
        return this.multiplexingXXXSocketSupport.getSocket(filter);
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    private void multiplexingXXXSocketSupportDoReceive(DatagramPacket p) throws IOException {
        super.receive(p);
    }

    private void multiplexingXXXSocketSupportDoSetReceiveBufferSize(int receiveBufferSize) throws SocketException {
        super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public void receive(DatagramPacket p) throws IOException {
        try {
            this.setOriginalInputStream(super.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.multiplexingXXXSocketSupport.receive(this.received, p, this.soTimeout);
    }

    void receive(MultiplexedSocket multiplexed, DatagramPacket p) throws IOException {
        try {
            this.setOriginalInputStream(super.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.multiplexingXXXSocketSupport.receive(multiplexed.received, p, multiplexed.getSoTimeout());
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        this.soTimeout = timeout;
    }
}

