/*
 * Decompiled with CFR 0.152.
 */
package com.lti.utils.synchronization;

import com.lti.utils.collections.Queue;

public class ProducerConsumerQueue<T> {
    private final Queue<T> q = new Queue();
    private final int sizeLimit;

    public ProducerConsumerQueue() {
        this.sizeLimit = -1;
    }

    public ProducerConsumerQueue(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public synchronized T get() throws InterruptedException {
        while (this.q.isEmpty()) {
            this.wait();
        }
        T o = this.q.dequeue();
        this.notifyAll();
        return o;
    }

    public synchronized T get(long timeout, T returnOnTimeout) throws InterruptedException {
        while (this.q.isEmpty()) {
            long t1 = System.currentTimeMillis();
            this.wait(timeout);
            if (System.currentTimeMillis() - t1 <= timeout) continue;
            return returnOnTimeout;
        }
        T o = this.q.dequeue();
        this.notifyAll();
        return o;
    }

    public synchronized boolean isEmpty() {
        return this.q.size() == 0;
    }

    public synchronized boolean isFull() {
        return this.sizeLimit > 0 && this.q.size() >= this.sizeLimit;
    }

    public synchronized void put(T value) throws InterruptedException {
        while (this.sizeLimit > 0 && this.q.size() >= this.sizeLimit) {
            this.wait();
        }
        this.q.enqueue(value);
        this.notifyAll();
    }

    public synchronized boolean put(T value, long timeout) throws InterruptedException {
        while (this.sizeLimit > 0 && this.q.size() >= this.sizeLimit) {
            long t1 = System.currentTimeMillis();
            this.wait(timeout);
            if (System.currentTimeMillis() - t1 <= timeout) continue;
            return false;
        }
        this.q.enqueue(value);
        this.notifyAll();
        return true;
    }

    public synchronized int size() {
        return this.q.size();
    }

    public int sizeLimit() {
        return this.sizeLimit;
    }

    public synchronized void waitUntilEmpty() throws InterruptedException {
        while (!this.q.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void waitUntilNotEmpty() throws InterruptedException {
        while (this.q.isEmpty()) {
            this.wait();
        }
    }

    public synchronized boolean waitUntilNotEmpty(long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.q.isEmpty()) {
            long now = System.currentTimeMillis();
            long alreadyWaited = now - start;
            long waitRemaining = timeout - alreadyWaited;
            if (waitRemaining < 1L) {
                return false;
            }
            this.wait(waitRemaining);
        }
        return !this.q.isEmpty();
    }
}

