/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.Map;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.ConferenceMemberState;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.utils.event.PropertyChangeNotifier;

public class AbstractConferenceMember
extends PropertyChangeNotifier
implements ConferenceMember {
    public static final String ALERTING = "alerting";
    public static final String CONNECTED = "connected";
    public static final String DIALING_IN = "dialing-in";
    public static final String DIALING_OUT = "dialing-out";
    public static final String DISCONNECTED = "disconnected";
    public static final String ON_HOLD = "on-hold";
    public static final String PENDING = "pending";
    private final String address;
    private long audioSsrc = -1L;
    private MediaDirection audioStatus = MediaDirection.INACTIVE;
    private final CallPeer conferenceFocusCallPeer;
    private String displayName;
    private ConferenceMemberState state = ConferenceMemberState.UNKNOWN;
    private long videoSsrc = -1L;
    private MediaDirection videoStatus = MediaDirection.INACTIVE;

    public AbstractConferenceMember(CallPeer conferenceFocusCallPeer, String address) {
        if (conferenceFocusCallPeer == null) {
            throw new NullPointerException("conferenceFocusCallPeer");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.conferenceFocusCallPeer = conferenceFocusCallPeer;
        this.address = address;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public long getAudioSsrc() {
        return this.audioSsrc;
    }

    @Override
    public MediaDirection getAudioStatus() {
        return this.audioStatus;
    }

    @Override
    public CallPeer getConferenceFocusCallPeer() {
        return this.conferenceFocusCallPeer;
    }

    @Override
    public String getDisplayName() {
        String address;
        String displayName = this.displayName;
        if ((displayName == null || displayName.length() < 1) && (address = this.getAddress()) != null && address.length() > 0) {
            return address;
        }
        return displayName;
    }

    @Override
    public ConferenceMemberState getState() {
        return this.state;
    }

    @Override
    public long getVideoSsrc() {
        return this.videoSsrc;
    }

    @Override
    public MediaDirection getVideoStatus() {
        return this.videoStatus;
    }

    private static long parseMediaSSRC(Object value) {
        String str;
        long ssrc = value == null ? -1L : (value instanceof Long ? (Long)value : ((str = value.toString()) == null || str.length() == 0 ? -1L : Long.parseLong(str)));
        return ssrc;
    }

    private static MediaDirection parseMediaStatus(Object value) {
        String str;
        MediaDirection status = value == null ? MediaDirection.INACTIVE : (value instanceof MediaDirection ? (MediaDirection)value : ((str = value.toString()) == null || str.length() == 0 ? MediaDirection.INACTIVE : MediaDirection.parseString((String)str)));
        return status;
    }

    public void setAudioSsrc(long ssrc) {
        if (this.audioSsrc != ssrc) {
            long oldValue = this.audioSsrc;
            this.audioSsrc = ssrc;
            this.firePropertyChange("audioSsrc", oldValue, this.audioSsrc);
        }
    }

    public void setAudioStatus(MediaDirection status) {
        if (status == null) {
            status = MediaDirection.INACTIVE;
        }
        if (this.audioStatus != status) {
            MediaDirection oldValue = this.audioStatus;
            this.audioStatus = status;
            this.firePropertyChange("audioStatus", oldValue, this.audioStatus);
        }
    }

    public void setDisplayName(String displayName) {
        if (this.displayName == null && displayName != null || this.displayName != null && !this.displayName.equals(displayName)) {
            String oldValue = this.displayName;
            this.displayName = displayName;
            this.firePropertyChange("displayName", oldValue, this.displayName);
        }
    }

    public void setEndpointStatus(String endpointStatus) {
        ConferenceMemberState state = ALERTING.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.ALERTING : (CONNECTED.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.CONNECTED : (DIALING_IN.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.DIALING_IN : (DIALING_OUT.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.DIALING_OUT : (DISCONNECTED.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.DISCONNECTED : (ON_HOLD.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.ON_HOLD : (PENDING.equalsIgnoreCase(endpointStatus) ? ConferenceMemberState.PENDING : ConferenceMemberState.UNKNOWN))))));
        this.setState(state);
    }

    public boolean setProperties(Map<String, Object> properties) {
        boolean changed = false;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if ("audioSsrc".equals(key)) {
                long ssrc = AbstractConferenceMember.parseMediaSSRC(value);
                if (this.getAudioSsrc() == ssrc) continue;
                this.setAudioSsrc(ssrc);
                changed = true;
                continue;
            }
            if ("audioStatus".equals(key)) {
                MediaDirection status = AbstractConferenceMember.parseMediaStatus(value);
                if (this.getAudioStatus().equals((Object)status)) continue;
                this.setAudioStatus(status);
                changed = true;
                continue;
            }
            if ("videoSsrc".equals(key)) {
                long ssrc = AbstractConferenceMember.parseMediaSSRC(value);
                if (this.getVideoSsrc() == ssrc) continue;
                this.setVideoSsrc(ssrc);
                changed = true;
                continue;
            }
            if (!"videoStatus".equals(key)) continue;
            MediaDirection status = AbstractConferenceMember.parseMediaStatus(value);
            if (this.getVideoStatus().equals((Object)status)) continue;
            this.setVideoStatus(status);
            changed = true;
        }
        return changed;
    }

    public void setState(ConferenceMemberState state) {
        if (this.state != state) {
            ConferenceMemberState oldValue = this.state;
            this.state = state;
            this.firePropertyChange("state", (Object)oldValue, (Object)this.state);
        }
    }

    public void setVideoSsrc(long ssrc) {
        if (this.videoSsrc != ssrc) {
            long oldValue = this.videoSsrc;
            this.videoSsrc = ssrc;
            this.firePropertyChange("videoSsrc", oldValue, this.videoSsrc);
        }
    }

    public void setVideoStatus(MediaDirection status) {
        if (status == null) {
            status = MediaDirection.INACTIVE;
        }
        if (this.videoStatus != status) {
            MediaDirection oldValue = this.videoStatus;
            this.videoStatus = status;
            this.firePropertyChange("videoStatus", oldValue, this.videoStatus);
        }
    }
}

