/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xevent.packet;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;

public class MessageEvent
implements ExtensionElement {
    public static final String NAMESPACE = "jabber:x:event";
    public static final String ELEMENT = "x";
    public static final String OFFLINE = "offline";
    public static final String COMPOSING = "composing";
    public static final String DISPLAYED = "displayed";
    public static final String DELIVERED = "delivered";
    public static final String CANCELLED = "cancelled";
    private boolean offline = false;
    private boolean delivered = false;
    private boolean displayed = false;
    private boolean composing = false;
    private boolean cancelled = true;
    private String packetID = null;

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public boolean isComposing() {
        return this.composing;
    }

    public boolean isDelivered() {
        return this.delivered;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getStanzaId() {
        return this.packetID;
    }

    public List<String> getEventTypes() {
        ArrayList<String> allEvents = new ArrayList<String>();
        if (this.isDelivered()) {
            allEvents.add(DELIVERED);
        }
        if (!this.isMessageEventRequest() && this.isCancelled()) {
            allEvents.add(CANCELLED);
        }
        if (this.isComposing()) {
            allEvents.add(COMPOSING);
        }
        if (this.isDisplayed()) {
            allEvents.add(DISPLAYED);
        }
        if (this.isOffline()) {
            allEvents.add(OFFLINE);
        }
        return allEvents;
    }

    public void setComposing(boolean composing) {
        this.composing = composing;
        this.setCancelled(false);
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
        this.setCancelled(false);
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
        this.setCancelled(false);
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
        this.setCancelled(false);
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void setStanzaId(String packetID) {
        this.packetID = packetID;
    }

    public boolean isMessageEventRequest() {
        return this.packetID == null;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.isOffline()) {
            buf.append('<').append(OFFLINE).append("/>");
        }
        if (this.isDelivered()) {
            buf.append('<').append(DELIVERED).append("/>");
        }
        if (this.isDisplayed()) {
            buf.append('<').append(DISPLAYED).append("/>");
        }
        if (this.isComposing()) {
            buf.append('<').append(COMPOSING).append("/>");
        }
        if (this.getStanzaId() != null) {
            buf.append("<id>").append(this.getStanzaId()).append("</id>");
        }
        buf.append("</").append(this.getElementName()).append('>');
        return buf.toString();
    }
}

