/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;

public final class BOSHConfiguration
extends ConnectionConfiguration {
    private final boolean https;
    private final String file;

    private BOSHConfiguration(Builder builder) {
        super((ConnectionConfiguration.Builder)builder);
        if (this.proxy != null && this.proxy.getProxyType() != ProxyInfo.ProxyType.HTTP) {
            throw new IllegalArgumentException("Only HTTP proxies are support with BOSH connections");
        }
        this.https = builder.https;
        this.file = builder.file.charAt(0) != '/' ? '/' + builder.file : builder.file;
    }

    public boolean isProxyEnabled() {
        return this.proxy != null;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxy;
    }

    public String getProxyAddress() {
        return this.proxy != null ? this.proxy.getProxyAddress() : null;
    }

    public int getProxyPort() {
        return this.proxy != null ? this.proxy.getProxyPort() : 8080;
    }

    public boolean isUsingHTTPS() {
        return this.https;
    }

    public URI getURI() throws URISyntaxException {
        return new URI((this.https ? "https://" : "http://") + this.host + ":" + this.port + this.file);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ConnectionConfiguration.Builder<Builder, BOSHConfiguration> {
        private boolean https;
        private String file;

        private Builder() {
        }

        public Builder setUseHttps(boolean useHttps) {
            this.https = useHttps;
            return this;
        }

        public Builder useHttps() {
            return this.setUseHttps(true);
        }

        public Builder setFile(String file) {
            this.file = file;
            return this;
        }

        public BOSHConfiguration build() {
            return new BOSHConfiguration(this);
        }

        protected Builder getThis() {
            return this;
        }
    }
}

