/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.List;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.util.event.VideoListener;
import org.jitsi.utils.MediaType;

public abstract class AbstractOperationSetVideoTelephony<T extends OperationSetBasicTelephony<U>, U extends ProtocolProviderService, V extends MediaAwareCall<W, T, U>, W extends MediaAwareCallPeer<V, ?, U>>
implements OperationSetVideoTelephony {
    protected final U parentProvider;
    protected final T basicTelephony;

    public AbstractOperationSetVideoTelephony(T basicTelephony) {
        this.basicTelephony = basicTelephony;
        this.parentProvider = basicTelephony.getProtocolProvider();
    }

    public void addVideoListener(CallPeer peer, VideoListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)peer).getMediaHandler())).addVideoListener(listener);
    }

    public Component getLocalVisualComponent(CallPeer peer) throws OperationFailedException {
        return ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)peer).getMediaHandler())).getLocalVisualComponent();
    }

    @Deprecated
    public Component getVisualComponent(CallPeer peer) {
        List<Component> visualComponents = this.getVisualComponents(peer);
        return visualComponents.isEmpty() ? null : visualComponents.get(0);
    }

    public List<Component> getVisualComponents(CallPeer peer) {
        return ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)peer).getMediaHandler())).getVisualComponents();
    }

    public ConferenceMember getConferenceMember(CallPeer peer, Component visualComponent) {
        MediaAwareCallPeer w = (MediaAwareCallPeer)peer;
        VideoMediaStream videoStream = (VideoMediaStream)((CallPeerMediaHandler)((Object)w.getMediaHandler())).getStream(MediaType.VIDEO);
        if (videoStream != null) {
            for (ConferenceMember member : peer.getConferenceMembers()) {
                Component memberComponent = videoStream.getVisualComponent(member.getVideoSsrc());
                if (!visualComponent.equals(memberComponent)) continue;
                return member;
            }
        }
        return null;
    }

    public void removeVideoListener(CallPeer peer, VideoListener listener) {
        if (listener != null) {
            ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)peer).getMediaHandler())).removeVideoListener(listener);
        }
    }

    public void setLocalVideoAllowed(Call call, boolean allowed) throws OperationFailedException {
        MediaAwareCall mediaAwareCall = (MediaAwareCall)call;
        MediaUseCase useCase = MediaUseCase.CALL;
        mediaAwareCall.setLocalVideoAllowed(allowed, useCase);
    }

    public boolean isLocalVideoAllowed(Call call) {
        return ((MediaAwareCall)call).isLocalVideoAllowed(MediaUseCase.CALL);
    }

    public boolean isLocalVideoStreaming(Call call) {
        return ((MediaAwareCall)call).isLocalVideoStreaming();
    }

    public void addPropertyChangeListener(Call call, PropertyChangeListener listener) {
        ((MediaAwareCall)call).addVideoPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(Call call, PropertyChangeListener listener) {
        ((MediaAwareCall)call).removeVideoPropertyChangeListener(listener);
    }

    public MediaUseCase getMediaUseCase() {
        return MediaUseCase.CALL;
    }

    public QualityControl getQualityControl(CallPeer peer) {
        return null;
    }

    public Call createVideoCall(String uri, QualityPreset qualityPreferences) throws OperationFailedException, ParseException {
        return this.createVideoCall(uri);
    }

    public Call createVideoCall(Contact callee, QualityPreset qualityPreferences) throws OperationFailedException {
        return this.createVideoCall(callee);
    }
}

