/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.DTMFListener;
import net.java.sip.communicator.service.protocol.media.DynamicPayloadTypeRegistry;
import net.java.sip.communicator.service.protocol.media.DynamicRTPExtensionsRegistry;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.MediaHandler;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import net.java.sip.communicator.service.protocol.media.SrtpControls;
import net.java.sip.communicator.service.protocol.media.TransportManager;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.MediaDeviceWrapper;
import org.jitsi.service.neomedia.event.CsrcAudioLevelListener;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.event.SrtpListener;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;
import org.jitsi.util.event.VideoNotifierSupport;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.event.PropertyChangeNotifier;

public abstract class CallPeerMediaHandler<T extends MediaAwareCallPeer<?, ?, ?>>
extends PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(CallPeerMediaHandler.class);
    public static final String AUDIO_LOCAL_SSRC = "AUDIO_LOCAL_SSRC";
    public static final String AUDIO_REMOTE_SSRC = "AUDIO_REMOTE_SSRC";
    public static final long SSRC_UNKNOWN = -1L;
    public static final String VIDEO_LOCAL_SSRC = "VIDEO_LOCAL_SSRC";
    public static final String VIDEO_REMOTE_SSRC = "VIDEO_REMOTE_SSRC";
    private static final byte[] HOLE_PUNCH_PACKET = new byte[]{-128, 0, 2, -98, 0, 9, -48, -128, 0, 0, 0, 0};
    private boolean disableHolePunching = false;
    private List<SrtpControlType> advertisedEncryptionMethods = new ArrayList<SrtpControlType>();
    private MediaDirection audioDirectionUserPreference = MediaDirection.SENDRECV;
    private AudioMediaStream audioStream;
    private final CallPropertyChangeListener callPropertyChangeListener;
    private CsrcAudioLevelListener csrcAudioLevelListener;
    private final Object csrcAudioLevelListenerLock = new Object();
    private final DynamicPayloadTypeRegistry dynamicPayloadTypes = new DynamicPayloadTypeRegistry();
    private final KeyFrameControl.KeyFrameRequester keyFrameRequester = new KeyFrameControl.KeyFrameRequester(){

        public boolean requestKeyFrame() {
            return CallPeerMediaHandler.this.requestKeyFrame();
        }
    };
    protected boolean locallyOnHold = false;
    private SimpleAudioLevelListener localUserAudioLevelListener;
    private final Object localUserAudioLevelListenerLock = new Object();
    private MediaHandler mediaHandler;
    private final PropertyChangeListener mediaHandlerPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            CallPeerMediaHandler.this.mediaHandlerPropertyChange(ev);
        }
    };
    private final T peer;
    private final DynamicRTPExtensionsRegistry rtpExtensionsRegistry = new DynamicRTPExtensionsRegistry();
    private final SrtpListener srtpListener;
    private SimpleAudioLevelListener streamAudioLevelListener;
    private final Object streamAudioLevelListenerLock = new Object();
    private MediaDirection videoDirectionUserPreference = MediaDirection.RECVONLY;
    private final VideoNotifierSupport videoNotifierSupport = new VideoNotifierSupport((Object)this, true);
    private VideoMediaStream videoStream;
    private String msLabel = UUID.randomUUID().toString();
    private final VideoListener videoStreamVideoListener = new VideoListener(){

        private void onVideoEvent(VideoEvent ev) {
            VideoEvent clone = ev.clone((Object)CallPeerMediaHandler.this);
            CallPeerMediaHandler.this.fireVideoEvent(clone);
            if (clone.isConsumed()) {
                ev.consume();
            }
        }

        public void videoAdded(VideoEvent ev) {
            this.onVideoEvent(ev);
        }

        public void videoRemoved(VideoEvent ev) {
            this.onVideoEvent(ev);
        }

        public void videoUpdate(VideoEvent ev) {
            this.onVideoEvent(ev);
        }
    };

    public CallPeerMediaHandler(T peer, SrtpListener srtpListener) {
        this.peer = peer;
        this.srtpListener = srtpListener;
        this.setMediaHandler(new MediaHandler());
        Object call = ((MediaAwareCallPeer)((Object)this.peer)).getCall();
        if (call == null) {
            this.callPropertyChangeListener = null;
        } else {
            this.callPropertyChangeListener = new CallPropertyChangeListener((MediaAwareCall<?, ?, ?>)call);
            call.addPropertyChangeListener((PropertyChangeListener)this.callPropertyChangeListener);
        }
    }

    public void addAdvertisedEncryptionMethod(SrtpControlType encryptionMethod) {
        if (!this.advertisedEncryptionMethods.contains(encryptionMethod)) {
            this.advertisedEncryptionMethods.add(encryptionMethod);
        }
    }

    public void addVideoListener(VideoListener listener) {
        this.videoNotifierSupport.addVideoListener(listener);
    }

    private void callPropertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        boolean callConferenceChange = "conference".equals(propertyName);
        if (callConferenceChange || "defaultDevice".equals(propertyName)) {
            Object call = ((MediaAwareCallPeer)((Object)this.getPeer())).getCall();
            if (call == null) {
                return;
            }
            for (MediaType mediaType : new MediaType[]{MediaType.AUDIO, MediaType.VIDEO}) {
                MediaStream stream = this.getStream(mediaType);
                if (stream == null) continue;
                MediaDevice oldDevice = stream.getDevice();
                if (oldDevice != null) {
                    MediaDevice newValue;
                    MediaDevice oldValue = !callConferenceChange && oldDevice instanceof MediaDeviceWrapper ? ((MediaDeviceWrapper)oldDevice).getWrappedDevice() : oldDevice;
                    MediaDevice newDevice = this.getDefaultDevice(mediaType);
                    MediaDevice mediaDevice = newValue = !callConferenceChange && newDevice instanceof MediaDeviceWrapper ? ((MediaDeviceWrapper)newDevice).getWrappedDevice() : newDevice;
                    if (oldValue != newValue) {
                        stream.setDevice(newDevice);
                    }
                }
                stream.setRTPTranslator(((MediaAwareCall)call).getRTPTranslator(mediaType));
            }
        }
    }

    public synchronized void close() {
        this.closeStream(MediaType.AUDIO);
        this.closeStream(MediaType.VIDEO);
        this.locallyOnHold = false;
        if (this.callPropertyChangeListener != null) {
            this.callPropertyChangeListener.removePropertyChangeListener();
        }
        this.setMediaHandler(null);
    }

    protected void closeStream(MediaType mediaType) {
        TransportManager<T> transportManager;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing " + mediaType + " stream for " + this.getPeer()));
        }
        boolean mediaHandlerCloseStream = false;
        switch (mediaType) {
            case AUDIO: {
                if (this.audioStream == null) break;
                this.audioStream = null;
                mediaHandlerCloseStream = true;
                break;
            }
            case VIDEO: {
                if (this.videoStream == null) break;
                this.videoStream = null;
                mediaHandlerCloseStream = true;
            }
        }
        if (mediaHandlerCloseStream) {
            this.mediaHandler.closeStream(this, mediaType);
        }
        if ((transportManager = this.queryTransportManager()) != null) {
            transportManager.closeStreamConnector(mediaType);
        }
    }

    private RTPExtension findExtension(List<RTPExtension> extList, String extensionURN) {
        for (RTPExtension rtpExt : extList) {
            if (!rtpExt.getURI().toASCIIString().equals(extensionURN)) continue;
            return rtpExt;
        }
        return null;
    }

    protected MediaFormat findMediaFormat(List<MediaFormat> formats, MediaFormat format) {
        for (MediaFormat match : formats) {
            if (!match.matches(format)) continue;
            return match;
        }
        return null;
    }

    protected boolean fireVideoEvent(int type, Component visualComponent, int origin) {
        return this.videoNotifierSupport.fireVideoEvent(type, visualComponent, origin, true);
    }

    public void fireVideoEvent(VideoEvent event) {
        this.videoNotifierSupport.fireVideoEvent(event, true);
    }

    public SrtpControlType[] getAdvertisedEncryptionMethods() {
        return this.advertisedEncryptionMethods.toArray(new SrtpControlType[this.advertisedEncryptionMethods.size()]);
    }

    protected MediaDevice getDefaultDevice(MediaType mediaType) {
        return ((MediaAwareCall)((MediaAwareCallPeer)((Object)this.getPeer())).getCall()).getDefaultDevice(mediaType);
    }

    protected MediaDirection getDirectionUserPreference(MediaType mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return this.audioDirectionUserPreference;
            }
            case VIDEO: {
                return this.videoDirectionUserPreference;
            }
        }
        return MediaDirection.INACTIVE;
    }

    protected DynamicPayloadTypeRegistry getDynamicPayloadTypes() {
        return this.dynamicPayloadTypes;
    }

    public SrtpControl getEncryptionMethod(MediaType mediaType) {
        return this.mediaHandler.getEncryptionMethod(this, mediaType);
    }

    protected List<RTPExtension> getExtensionsForType(MediaType type) {
        MediaDevice device = this.getDefaultDevice(type);
        return device != null ? device.getSupportedExtensions() : new ArrayList();
    }

    public long getHarvestingTime(String harvesterName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? 0L : transportManager.getHarvestingTime(harvesterName);
    }

    public String getICECandidateExtendedType(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICECandidateExtendedType(streamName);
    }

    public InetSocketAddress getICELocalHostAddress(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICELocalHostAddress(streamName);
    }

    public InetSocketAddress getICELocalReflexiveAddress(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICELocalReflexiveAddress(streamName);
    }

    public InetSocketAddress getICELocalRelayedAddress(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICELocalRelayedAddress(streamName);
    }

    public InetSocketAddress getICERemoteHostAddress(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICERemoteHostAddress(streamName);
    }

    public InetSocketAddress getICERemoteReflexiveAddress(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICERemoteReflexiveAddress(streamName);
    }

    public InetSocketAddress getICERemoteRelayedAddress(String streamName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICERemoteRelayedAddress(streamName);
    }

    public String getICEState() {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? null : transportManager.getICEState();
    }

    public List<MediaFormat> getLocallySupportedFormats(MediaDevice mediaDevice) {
        return this.getLocallySupportedFormats(mediaDevice, null, null);
    }

    public List<MediaFormat> getLocallySupportedFormats(MediaDevice mediaDevice, QualityPreset sendPreset, QualityPreset receivePreset) {
        if (mediaDevice == null) {
            return Collections.emptyList();
        }
        Map accountProperties = ((MediaAwareCallPeer)((Object)this.getPeer())).getProtocolProvider().getAccountID().getAccountProperties();
        String overrideEncodings = (String)accountProperties.get("OVERRIDE_ENCODINGS");
        if (Boolean.parseBoolean(overrideEncodings)) {
            EncodingConfiguration encodingConfiguration = ProtocolMediaActivator.getMediaService().createEmptyEncodingConfiguration();
            encodingConfiguration.loadProperties(accountProperties, "Encodings");
            return mediaDevice.getSupportedFormats(sendPreset, receivePreset, encodingConfiguration);
        }
        return mediaDevice.getSupportedFormats(sendPreset, receivePreset);
    }

    public Component getLocalVisualComponent() {
        MediaStream videoStream = this.getStream(MediaType.VIDEO);
        return videoStream == null || !this.isLocalVideoTransmissionEnabled() ? null : ((VideoMediaStream)videoStream).getLocalVisualComponent();
    }

    public MediaHandler getMediaHandler() {
        return this.mediaHandler;
    }

    public int getNbHarvesting() {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? 0 : transportManager.getNbHarvesting();
    }

    public int getNbHarvesting(String harvesterName) {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? 0 : transportManager.getNbHarvesting(harvesterName);
    }

    public T getPeer() {
        return this.peer;
    }

    public long getRemoteSSRC(MediaType mediaType) {
        return this.mediaHandler.getRemoteSSRC(this, mediaType);
    }

    protected DynamicRTPExtensionsRegistry getRtpExtensionsRegistry() {
        return this.rtpExtensionsRegistry;
    }

    public SrtpControls getSrtpControls() {
        return this.mediaHandler.getSrtpControls(this);
    }

    public MediaStream getStream(MediaType mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return this.audioStream;
            }
            case VIDEO: {
                return this.videoStream;
            }
        }
        return null;
    }

    public long getTotalHarvestingTime() {
        TransportManager<T> transportManager = this.queryTransportManager();
        return transportManager == null ? 0L : transportManager.getTotalHarvestingTime();
    }

    protected abstract TransportManager<T> getTransportManager();

    protected abstract TransportManager<T> queryTransportManager();

    @Deprecated
    public Component getVisualComponent() {
        List<Component> visualComponents = this.getVisualComponents();
        return visualComponents.isEmpty() ? null : visualComponents.get(0);
    }

    public List<Component> getVisualComponents() {
        MediaStream videoStream = this.getStream(MediaType.VIDEO);
        List visualComponents = videoStream == null ? Collections.emptyList() : ((VideoMediaStream)videoStream).getVisualComponents();
        return visualComponents;
    }

    protected MediaStream initStream(StreamConnector connector, MediaDevice device, MediaFormat format, MediaStreamTarget target, MediaDirection direction, List<RTPExtension> rtpExtensions, boolean masterStream) throws OperationFailedException {
        MediaType mediaType = device.getMediaType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initializing " + mediaType + " stream for " + this.getPeer()));
        }
        direction = direction.and(this.getDirectionUserPreference(mediaType));
        direction = direction.and(device.getDirection());
        MediaStream stream = this.mediaHandler.initStream(this, connector, device, format, target, direction, rtpExtensions, masterStream);
        switch (mediaType) {
            case AUDIO: {
                this.audioStream = (AudioMediaStream)stream;
                break;
            }
            case VIDEO: {
                this.videoStream = (VideoMediaStream)stream;
            }
        }
        return stream;
    }

    protected List<MediaFormat> intersectFormats(List<MediaFormat> remoteFormats, List<MediaFormat> localFormats) {
        ArrayList<MediaFormat> ret = new ArrayList<MediaFormat>();
        MediaFormat telephoneEvents = null;
        MediaFormat red = null;
        MediaFormat ulpfec = null;
        for (MediaFormat remoteFormat : remoteFormats) {
            MediaFormat localFormat = this.findMediaFormat(localFormats, remoteFormat);
            if (localFormat == null) continue;
            String encoding = localFormat.getEncoding();
            if ("telephone-event".equals(encoding)) {
                telephoneEvents = localFormat;
                continue;
            }
            if ("red".equals(encoding)) {
                red = localFormat;
                continue;
            }
            if ("ulpfec".equals(encoding)) {
                ulpfec = localFormat;
                continue;
            }
            ret.add(localFormat);
        }
        if (!ret.isEmpty()) {
            if (telephoneEvents != null) {
                ret.add(telephoneEvents);
            }
            if (red != null) {
                ret.add(red);
            }
            if (ulpfec != null) {
                ret.add(ulpfec);
            }
        }
        return ret;
    }

    protected List<RTPExtension> intersectRTPExtensions(List<RTPExtension> remoteExtensions, List<RTPExtension> supportedExtensions) {
        if (remoteExtensions == null || supportedExtensions == null) {
            return new ArrayList<RTPExtension>();
        }
        ArrayList<RTPExtension> intersection = new ArrayList<RTPExtension>(Math.min(remoteExtensions.size(), supportedExtensions.size()));
        for (RTPExtension remoteExtension : remoteExtensions) {
            RTPExtension localExtension = this.findExtension(supportedExtensions, remoteExtension.getURI().toString());
            if (localExtension == null) continue;
            MediaDirection localDir = localExtension.getDirection();
            MediaDirection remoteDir = remoteExtension.getDirection();
            RTPExtension intersected = new RTPExtension(localExtension.getURI(), localDir.getDirectionForAnswer(remoteDir), remoteExtension.getExtensionAttributes());
            intersection.add(intersected);
        }
        return intersection;
    }

    public boolean isDeviceActive(MediaDevice dev) {
        return dev != null && !this.getLocallySupportedFormats(dev).isEmpty();
    }

    public boolean isDeviceActive(MediaDevice dev, QualityPreset sendPreset, QualityPreset receivePreset) {
        return dev != null && !this.getLocallySupportedFormats(dev, sendPreset, receivePreset).isEmpty();
    }

    public boolean isLocalAudioTransmissionEnabled() {
        return this.audioDirectionUserPreference.allowsSending();
    }

    public boolean isLocallyOnHold() {
        return this.locallyOnHold;
    }

    public boolean isLocalVideoTransmissionEnabled() {
        return this.videoDirectionUserPreference.allowsSending();
    }

    public boolean isMute() {
        MediaStream audioStream = this.getStream(MediaType.AUDIO);
        return audioStream != null && audioStream.isMute();
    }

    public boolean isRemotelyOnHold() {
        for (MediaType mediaType : MediaType.values()) {
            MediaStream stream = this.getStream(mediaType);
            if (stream == null || !stream.getDirection().allowsSending()) continue;
            return false;
        }
        return true;
    }

    public boolean isRTPTranslationEnabled(MediaType mediaType) {
        T peer = this.getPeer();
        Object call = ((MediaAwareCallPeer)((Object)peer)).getCall();
        if (call != null && ((MediaAwareCall)call).isConferenceFocus() && !((MediaAwareCall)call).isLocalVideoStreaming()) {
            Iterator callPeerIt = call.getCallPeers();
            while (callPeerIt.hasNext()) {
                MediaAwareCallPeer callPeer = (MediaAwareCallPeer)((Object)callPeerIt.next());
                MediaStream stream = ((CallPeerMediaHandler)((Object)callPeer.getMediaHandler())).getStream(mediaType);
                if (stream == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSecure() {
        for (MediaType mediaType : MediaType.values()) {
            MediaStream stream = this.getStream(mediaType);
            if (stream == null || stream.getSrtpControl().getSecureCommunicationStatus()) continue;
            return false;
        }
        return true;
    }

    protected void mediaHandlerPropertyChange(PropertyChangeEvent ev) {
        this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
    }

    public boolean processKeyFrameRequest() {
        return this.mediaHandler.processKeyFrameRequest(this);
    }

    protected void removeAndCleanupOtherSrtpControls(MediaType mediaType, SrtpControlType srtpControlType) {
        SrtpControls srtpControls = this.getSrtpControls();
        for (SrtpControlType i : SrtpControlType.values()) {
            SrtpControl e;
            if (i.equals((Object)srtpControlType) || (e = srtpControls.remove(mediaType, i)) == null) continue;
            e.cleanup(null);
        }
    }

    public void removeVideoListener(VideoListener listener) {
        this.videoNotifierSupport.removeVideoListener(listener);
    }

    protected boolean requestKeyFrame() {
        return false;
    }

    protected void sendHolePunchPacket(MediaStream stream, MediaType mediaType) {
        if (this.disableHolePunching) {
            return;
        }
        RawPacket packet = new RawPacket(HOLE_PUNCH_PACKET, 0, 12);
        MediaFormat format = stream.getFormat();
        byte payloadType = format.getRTPPayloadType();
        if (payloadType == -1) {
            payloadType = this.dynamicPayloadTypes.getPayloadType(format);
        }
        packet.setPayloadType(payloadType);
        packet.setSSRC((int)stream.getLocalSourceID());
        this.getTransportManager().sendHolePunchPacket(stream.getTarget(), mediaType, packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCsrcAudioLevelListener(CsrcAudioLevelListener listener) {
        Object object = this.csrcAudioLevelListenerLock;
        synchronized (object) {
            if (this.csrcAudioLevelListener != listener) {
                MediaHandler mediaHandler = this.getMediaHandler();
                if (mediaHandler != null && this.csrcAudioLevelListener != null) {
                    mediaHandler.removeCsrcAudioLevelListener(this.csrcAudioLevelListener);
                }
                this.csrcAudioLevelListener = listener;
                if (mediaHandler != null && this.csrcAudioLevelListener != null) {
                    mediaHandler.addCsrcAudioLevelListener(this.csrcAudioLevelListener);
                }
            }
        }
    }

    public void setLocalAudioTransmissionEnabled(boolean enabled) {
        this.audioDirectionUserPreference = enabled ? MediaDirection.SENDRECV : MediaDirection.RECVONLY;
    }

    public void setLocallyOnHold(boolean locallyOnHold) throws OperationFailedException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting locally on hold: " + locallyOnHold));
        }
        this.locallyOnHold = locallyOnHold;
        if (locallyOnHold) {
            MediaStream videoStream;
            MediaDirection direction;
            MediaStream audioStream = this.getStream(MediaType.AUDIO);
            MediaDirection mediaDirection = direction = ((MediaAwareCall)((MediaAwareCallPeer)((Object)this.getPeer())).getCall()).isConferenceFocus() || audioStream == null ? MediaDirection.INACTIVE : audioStream.getDirection().and(MediaDirection.SENDONLY);
            if (audioStream != null) {
                audioStream.setDirection(direction);
                audioStream.setMute(true);
            }
            if ((videoStream = this.getStream(MediaType.VIDEO)) != null) {
                direction = ((MediaAwareCall)((MediaAwareCallPeer)((Object)this.getPeer())).getCall()).isConferenceFocus() ? MediaDirection.INACTIVE : videoStream.getDirection().and(MediaDirection.SENDONLY);
                videoStream.setDirection(direction);
                videoStream.setMute(true);
            }
        } else if (!CallPeerState.ON_HOLD_MUTUALLY.equals(this.getPeer().getState())) {
            MediaStream videoStream;
            MediaStream audioStream = this.getStream(MediaType.AUDIO);
            if (audioStream != null) {
                audioStream.setDirection(audioStream.getDirection().or(MediaDirection.SENDONLY));
                audioStream.setMute(false);
            }
            if ((videoStream = this.getStream(MediaType.VIDEO)) != null && videoStream.getDirection() != MediaDirection.INACTIVE) {
                videoStream.setDirection(videoStream.getDirection().or(MediaDirection.SENDONLY));
                videoStream.setMute(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalUserAudioLevelListener(SimpleAudioLevelListener listener) {
        Object object = this.localUserAudioLevelListenerLock;
        synchronized (object) {
            if (this.localUserAudioLevelListener != listener) {
                MediaHandler mediaHandler = this.getMediaHandler();
                if (mediaHandler != null && this.localUserAudioLevelListener != null) {
                    mediaHandler.removeLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                }
                this.localUserAudioLevelListener = listener;
                if (mediaHandler != null && this.localUserAudioLevelListener != null) {
                    mediaHandler.addLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                }
            }
        }
    }

    public void setLocalVideoTransmissionEnabled(boolean enabled) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting local video transmission enabled: " + enabled));
        }
        MediaDirection oldValue = this.videoDirectionUserPreference;
        MediaDirection newValue = this.videoDirectionUserPreference = enabled ? MediaDirection.SENDRECV : MediaDirection.RECVONLY;
        if (!enabled) {
            this.firePropertyChange("LOCAL_VIDEO_STREAMING", oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaHandler(MediaHandler mediaHandler) {
        if (this.mediaHandler != mediaHandler) {
            Object object;
            if (this.mediaHandler != null) {
                object = this.csrcAudioLevelListenerLock;
                synchronized (object) {
                    if (this.csrcAudioLevelListener != null) {
                        this.mediaHandler.removeCsrcAudioLevelListener(this.csrcAudioLevelListener);
                    }
                }
                object = this.localUserAudioLevelListenerLock;
                synchronized (object) {
                    if (this.localUserAudioLevelListener != null) {
                        this.mediaHandler.removeLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                    }
                }
                object = this.streamAudioLevelListenerLock;
                synchronized (object) {
                    if (this.streamAudioLevelListener != null) {
                        this.mediaHandler.removeStreamAudioLevelListener(this.streamAudioLevelListener);
                    }
                }
                this.mediaHandler.removeKeyFrameRequester(this.keyFrameRequester);
                this.mediaHandler.removePropertyChangeListener(this.mediaHandlerPropertyChangeListener);
                if (this.srtpListener != null) {
                    this.mediaHandler.removeSrtpListener(this.srtpListener);
                }
                this.mediaHandler.removeVideoListener(this.videoStreamVideoListener);
            }
            this.mediaHandler = mediaHandler;
            if (this.mediaHandler != null) {
                object = this.csrcAudioLevelListenerLock;
                synchronized (object) {
                    if (this.csrcAudioLevelListener != null) {
                        this.mediaHandler.addCsrcAudioLevelListener(this.csrcAudioLevelListener);
                    }
                }
                object = this.localUserAudioLevelListenerLock;
                synchronized (object) {
                    if (this.localUserAudioLevelListener != null) {
                        this.mediaHandler.addLocalUserAudioLevelListener(this.localUserAudioLevelListener);
                    }
                }
                object = this.streamAudioLevelListenerLock;
                synchronized (object) {
                    if (this.streamAudioLevelListener != null) {
                        this.mediaHandler.addStreamAudioLevelListener(this.streamAudioLevelListener);
                    }
                }
                this.mediaHandler.addKeyFrameRequester(-1, this.keyFrameRequester);
                this.mediaHandler.addPropertyChangeListener(this.mediaHandlerPropertyChangeListener);
                if (this.srtpListener != null) {
                    this.mediaHandler.addSrtpListener(this.srtpListener);
                }
                this.mediaHandler.addVideoListener(this.videoStreamVideoListener);
                this.mediaHandler.addDtmfListener((DTMFListener)((MediaAwareCallPeer)((Object)this.getPeer())).getCall());
            }
        }
    }

    public void setMute(boolean mute) {
        MediaStream audioStream = this.getStream(MediaType.AUDIO);
        if (audioStream != null) {
            audioStream.setMute(mute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStreamAudioLevelListener(SimpleAudioLevelListener listener) {
        Object object = this.streamAudioLevelListenerLock;
        synchronized (object) {
            if (this.streamAudioLevelListener != listener) {
                MediaHandler mediaHandler = this.getMediaHandler();
                if (mediaHandler != null && this.streamAudioLevelListener != null) {
                    mediaHandler.removeStreamAudioLevelListener(this.streamAudioLevelListener);
                }
                this.streamAudioLevelListener = listener;
                if (mediaHandler != null && this.streamAudioLevelListener != null) {
                    mediaHandler.addStreamAudioLevelListener(this.streamAudioLevelListener);
                }
            }
        }
    }

    public void start() throws IllegalStateException {
        MediaStream stream;
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Starting");
        }
        if ((stream = this.getStream(MediaType.AUDIO)) != null && !stream.isStarted() && this.isLocalAudioTransmissionEnabled()) {
            this.getTransportManager().setTrafficClass(stream.getTarget(), MediaType.AUDIO);
            stream.start();
            this.sendHolePunchPacket(stream, MediaType.AUDIO);
        }
        if ((stream = this.getStream(MediaType.VIDEO)) != null) {
            this.firePropertyChange("LOCAL_VIDEO_STREAMING", null, this.videoDirectionUserPreference);
            if (!stream.isStarted()) {
                this.getTransportManager().setTrafficClass(stream.getTarget(), MediaType.VIDEO);
                stream.start();
                this.sendHolePunchPacket(stream, MediaType.VIDEO);
            }
        }
    }

    public void startSrtpMultistream(SrtpControl master) {
        MediaStream videoStream = this.getStream(MediaType.VIDEO);
        if (videoStream != null) {
            videoStream.getSrtpControl().setMultistream(master);
        }
    }

    protected abstract void throwOperationFailedException(String var1, int var2, Throwable var3) throws OperationFailedException;

    public String getMsid(MediaType mediaType) {
        return this.msLabel + " " + this.getLabel(mediaType);
    }

    public String getLabel(MediaType mediaType) {
        return mediaType.toString() + ((Object)((Object)this)).hashCode();
    }

    public String getMsLabel() {
        return this.msLabel;
    }

    public void setDisableHolePunching(boolean disableHolePunching) {
        this.disableHolePunching = disableHolePunching;
    }

    private class CallPropertyChangeListener
    implements PropertyChangeListener {
        private final MediaAwareCall<?, ?, ?> call;

        public CallPropertyChangeListener(MediaAwareCall<?, ?, ?> call) {
            this.call = call;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            CallPeerMediaHandler.this.callPropertyChange(event);
        }

        public void removePropertyChangeListener() {
            this.call.removePropertyChangeListener(this);
        }
    }
}

