/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.ColoredDefaultText;
import net.java.sip.communicator.plugin.desktoputil.event.TextFieldChangeListener;

public class SIPCommTextField
extends JTextField
implements MouseListener,
FocusListener,
KeyListener,
DocumentListener,
ColoredDefaultText {
    private static final long serialVersionUID = 0L;
    private String defaultText;
    private Collection<TextFieldChangeListener> changeListeners = new LinkedList<TextFieldChangeListener>();
    private boolean isDefaultTextVisible;
    private Color foregroundColor = Color.BLACK;
    private Color defaultTextColor = Color.GRAY;

    public SIPCommTextField(String text) {
        super(text);
        if (text != null && text.length() > 0) {
            this.defaultText = text;
            this.isDefaultTextVisible = true;
        }
        this.setFont(this.getFont().deriveFont(10.0f));
        this.setForeground(this.defaultTextColor);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.getDocument().addDocumentListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.getText() == null) {
            this.clearDefaultText();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.clearDefaultText();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.getText() == null || this.getText().length() == 0) {
            this.setDefaultText();
        }
    }

    @Override
    public String getText() {
        if (!super.getText().equals(this.defaultText)) {
            return super.getText();
        }
        return null;
    }

    @Override
    public void setText(String text) {
        if (!(text != null && text.length() != 0 || this.isFocusOwner())) {
            this.setDefaultText();
        } else {
            this.setForeground(this.foregroundColor);
            super.setText(text);
        }
    }

    private void setDefaultText() {
        super.setText(this.defaultText);
        this.setForeground(this.defaultTextColor);
        this.setCaretPosition(0);
    }

    private void clearDefaultText() {
        if (super.getText().equals(this.defaultText)) {
            super.setText("");
            this.setForeground(this.foregroundColor);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.clearDefaultText();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.clearDefaultText();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextChangeListener(TextFieldChangeListener l) {
        Collection<TextFieldChangeListener> collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextChangeListener(TextFieldChangeListener l) {
        Collection<TextFieldChangeListener> collection = this.changeListeners;
        synchronized (collection) {
            this.changeListeners.remove(l);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!super.getText().equals(this.defaultText)) {
            this.fireTextFieldChangeListener(0);
        } else {
            this.isDefaultTextVisible = true;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.isDefaultTextVisible) {
            this.fireTextFieldChangeListener(1);
        } else {
            this.isDefaultTextVisible = false;
        }
    }

    @Override
    public void replaceSelection(String content) {
        if (super.getText().equals(this.defaultText)) {
            this.clearDefaultText();
        }
        super.replaceSelection(content);
    }

    @Override
    public void setForegroundColor(Color c) {
        this.foregroundColor = c;
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public void setDefaultTextColor(Color c) {
        this.defaultTextColor = c;
        if (this.isDefaultTextVisible) {
            this.setForeground(this.defaultTextColor);
        }
    }

    @Override
    public Color getDefaultTextColor() {
        return this.defaultTextColor;
    }

    private void fireTextFieldChangeListener(int eventType) {
        for (TextFieldChangeListener l : this.changeListeners) {
            switch (eventType) {
                case 0: {
                    l.textInserted();
                    break;
                }
                case 1: {
                    l.textRemoved();
                }
            }
        }
    }
}

