/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_markup.element;

import java.util.Collections;
import java.util.Set;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.message_markup.element.MarkupElement;

public class SpanElement
implements MarkupElement.MarkupChildElement {
    public static final String ELEMENT = "span";
    private final int start;
    private final int end;
    private final Set<SpanStyle> styles;
    public static final String emphasis = "emphasis";
    public static final String code = "code";
    public static final String deleted = "deleted";

    public SpanElement(int start, int end, Set<SpanStyle> styles) {
        this.start = start;
        this.end = end;
        this.styles = Collections.unmodifiableSet(styles);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public Set<SpanStyle> getStyles() {
        return this.styles;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.halfOpenElement((NamedElement)this);
        xml.attribute("start", this.getStart());
        xml.attribute("end", this.getEnd());
        xml.rightAngleBracket();
        for (SpanStyle style : this.getStyles()) {
            xml.halfOpenElement(style.toString()).closeEmptyElement();
        }
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static enum SpanStyle {
        emphasis,
        code,
        deleted;

    }
}

