/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.stats.media;

import io.callstats.sdk.CallStats;
import io.callstats.sdk.CallStatsConferenceEvents;
import io.callstats.sdk.CallStatsErrors;
import io.callstats.sdk.data.CallStatsStreamType;
import io.callstats.sdk.data.ConferenceInfo;
import io.callstats.sdk.data.ConferenceStatsBuilder;
import io.callstats.sdk.data.UserInfo;
import io.callstats.sdk.listeners.CallStatsStartConferenceListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jitsi.service.neomedia.stats.ReceiveTrackStats;
import org.jitsi.service.neomedia.stats.SendTrackStats;
import org.jitsi.stats.media.StatsService;
import org.jitsi.utils.concurrent.PeriodicRunnableWithObject;
import org.jitsi.utils.logging.Logger;

public abstract class AbstractStatsPeriodicRunnable<T>
extends PeriodicRunnableWithObject<T> {
    private static final Logger logger = Logger.getLogger(AbstractStatsPeriodicRunnable.class);
    private UserInfo userInfo = null;
    private String initiatorID;
    private final String conferenceID;
    private StatsService statsService;

    public AbstractStatsPeriodicRunnable(T o, long period, StatsService statsService, String conferenceName, String conferenceIDPrefix, String initiatorID) {
        super(o, period);
        this.statsService = statsService;
        this.initiatorID = initiatorID;
        if (conferenceIDPrefix != null && !conferenceIDPrefix.endsWith("/")) {
            conferenceIDPrefix = conferenceIDPrefix + "/";
        }
        this.conferenceID = (conferenceIDPrefix != null ? conferenceIDPrefix : "") + conferenceName;
    }

    protected abstract Map<String, Collection<? extends ReceiveTrackStats>> getReceiveTrackStats();

    protected abstract Map<String, Collection<? extends SendTrackStats>> getSendTrackStats();

    protected void doRun() {
        CallStats callStats = this.statsService.getCallStats();
        if (this.userInfo == null || callStats == null || !callStats.isInitialized()) {
            return;
        }
        Map<String, Collection<ReceiveTrackStats>> receiveStats = this.getReceiveTrackStats();
        Map<String, Collection<SendTrackStats>> sendStats = this.getSendTrackStats();
        HashSet<String> combinedEndpoints = new HashSet<String>(receiveStats.keySet());
        combinedEndpoints.addAll(sendStats.keySet());
        for (String endpointID : combinedEndpoints) {
            Collection<SendTrackStats> sendTrackStats;
            callStats.startStatsReportingForUser(endpointID, this.conferenceID);
            Collection<ReceiveTrackStats> receiveTrackStats = receiveStats.get(endpointID);
            if (receiveTrackStats != null) {
                for (ReceiveTrackStats receiveStat : receiveTrackStats) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)new StringBuilder().append("ReceiveTrackStats (").append(this.initiatorID).append(" <- ").append(endpointID).append(") :").append(" ssrc: ").append(receiveStat.getSSRC()).append(", bytes:").append(receiveStat.getBytes()).append(", packets:").append(receiveStat.getPackets()).append(", packetsLost:").append(receiveStat.getPacketsLost()).append(", lostRate:").append(receiveStat.getLossRate()).append(", jitter:").append(receiveStat.getJitter()).append(", rtt:").append(receiveStat.getRtt()));
                    }
                    ConferenceStatsBuilder conferenceStats = new ConferenceStatsBuilder().bytesReceived(receiveStat.getBytes()).packetsReceived(receiveStat.getPackets()).packetsLost(receiveStat.getPacketsLost()).fractionalPacketLost(receiveStat.getLossRate()).ssrc(String.valueOf(receiveStat.getSSRC())).confID(this.conferenceID).localUserID(this.initiatorID).remoteUserID(endpointID).statsType(CallStatsStreamType.INBOUND).ucID(this.userInfo.getUcID());
                    if (receiveStat.getJitter() != Double.MIN_VALUE) {
                        conferenceStats = conferenceStats.jitter(receiveStat.getJitter());
                    }
                    if (receiveStat.getRtt() != -1L) {
                        conferenceStats = conferenceStats.rtt((int)receiveStat.getRtt());
                    }
                    callStats.reportConferenceStats(endpointID, conferenceStats.build());
                }
            }
            if ((sendTrackStats = sendStats.get(endpointID)) != null) {
                for (SendTrackStats sendStat : sendTrackStats) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)new StringBuilder().append("SendTrackStats (").append(this.initiatorID).append(" -> ").append(endpointID).append(") :").append(" ssrc: ").append(sendStat.getSSRC()).append(", bytes:").append(sendStat.getBytes()).append(", packets:").append(sendStat.getPackets()).append(", lostRate:").append(sendStat.getLossRate()).append(", jitter:").append(sendStat.getJitter()).append(", rtt:").append(sendStat.getRtt()));
                    }
                    ConferenceStatsBuilder conferenceStats = new ConferenceStatsBuilder().bytesSent(sendStat.getBytes()).packetsSent(sendStat.getPackets()).fractionalPacketLost(sendStat.getLossRate()).ssrc(String.valueOf(sendStat.getSSRC())).confID(this.conferenceID).localUserID(this.initiatorID).remoteUserID(endpointID).statsType(CallStatsStreamType.OUTBOUND).ucID(this.userInfo.getUcID());
                    if (sendStat.getJitter() != Double.MIN_VALUE) {
                        conferenceStats = conferenceStats.jitter(sendStat.getJitter());
                    }
                    if (sendStat.getRtt() != -1L) {
                        conferenceStats = conferenceStats.rtt((int)sendStat.getRtt());
                    }
                    callStats.reportConferenceStats(endpointID, conferenceStats.build());
                }
            }
            callStats.stopStatsReportingForUser(endpointID, this.conferenceID);
        }
    }

    public void start() {
        ConferenceInfo conferenceInfo = new ConferenceInfo(this.conferenceID, this.initiatorID);
        this.statsService.getCallStats().sendCallStatsConferenceEvent(CallStatsConferenceEvents.CONFERENCE_SETUP, conferenceInfo, (CallStatsStartConferenceListener)new CSStartConferenceListener(new WeakReference(this)));
    }

    public void stop() {
        if (this.userInfo != null) {
            this.statsService.getCallStats().sendCallStatsConferenceEvent(CallStatsConferenceEvents.CONFERENCE_TERMINATED, this.userInfo);
        }
    }

    private void conferenceSetupResponse(String ucid) {
        this.userInfo = new UserInfo(this.conferenceID, this.initiatorID, ucid);
    }

    private class CSStartConferenceListener
    implements CallStatsStartConferenceListener {
        private final WeakReference<AbstractStatsPeriodicRunnable<T>> processible;

        CSStartConferenceListener(WeakReference<AbstractStatsPeriodicRunnable<T>> processible) {
            this.processible = processible;
        }

        public void onResponse(String ucid) {
            AbstractStatsPeriodicRunnable p = (AbstractStatsPeriodicRunnable)((Object)this.processible.get());
            if (p != null) {
                p.conferenceSetupResponse(ucid);
            }
        }

        public void onError(CallStatsErrors callStatsErrors, String message) {
            logger.error((Object)("Failed to start a callstats conference (???): " + message + ", " + callStatsErrors));
        }
    }
}

