/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.stats.media;

import io.callstats.sdk.CallStats;
import io.callstats.sdk.CallStatsErrors;
import io.callstats.sdk.ICallStatsTokenGenerator;
import io.callstats.sdk.data.ServerInfo;
import io.callstats.sdk.listeners.CallStatsInitListener;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.stats.media.StatsService;
import org.jitsi.stats.media.TokenGenerator;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.version.Version;
import org.jitsi.utils.version.VersionService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class StatsServiceFactory {
    private static final Logger logger = Logger.getLogger(StatsServiceFactory.class);
    private static StatsServiceFactory factoryInstance;
    private Map<Integer, CallStats> callStatsInstances = new HashMap<Integer, CallStats>();
    private Map<Integer, ServiceRegistration<StatsService>> statsServiceInstanceRegistrations = new HashMap<Integer, ServiceRegistration<StatsService>>();

    public static StatsServiceFactory getInstance() {
        if (factoryInstance == null) {
            factoryInstance = new StatsServiceFactory();
        }
        return factoryInstance;
    }

    public StatsService getStatsService(int id, BundleContext context) {
        ServiceRegistration<StatsService> reg = this.statsServiceInstanceRegistrations.get(id);
        if (reg == null) {
            return null;
        }
        return (StatsService)context.getService(reg.getReference());
    }

    public synchronized void createStatsService(BundleContext context, int id, String appSecret, String keyId, String keyPath, String initiatorID, boolean isClient) {
        this.createStatsService(context, id, appSecret, keyId, keyPath, initiatorID, isClient, (reason, errorMsg) -> logger.error((Object)("callstats.io Java library failed to initialize with error: " + reason + " and error message: " + errorMsg)));
    }

    public synchronized void createStatsService(final BundleContext context, final int id, String appSecret, String keyId, String keyPath, String initiatorID, boolean isClient, final InitErrorCallback errorCallback) {
        if (this.callStatsInstances.containsKey(id)) {
            return;
        }
        if (keyId == null || keyPath == null) {
            logger.warn((Object)"KeyID/keyPath missing, will try using appSecret");
            if (appSecret == null) {
                errorCallback.errorCallback("Missing parameres", "appSecret missing");
                logger.warn((Object)"appSecret missing. Skipping callstats init");
                return;
            }
        }
        ServerInfo serverInfo = this.createServerInfo(context, isClient);
        final CallStats callStats = new CallStats();
        this.callStatsInstances.put(id, callStats);
        CallStatsInitListener callStatsInitListener = new CallStatsInitListener(){

            public void onError(CallStatsErrors error, String errMsg) {
                if (errorCallback != null) {
                    errorCallback.errorCallback(error.getReason(), errMsg);
                }
            }

            public void onInitialized(String msg) {
                StatsServiceFactory.this.callStatsOnInitialized(id, context, callStats, msg);
            }
        };
        if (keyId != null && keyPath != null) {
            callStats.initialize(id, (ICallStatsTokenGenerator)new TokenGenerator(String.valueOf(id), keyId, initiatorID, keyPath), initiatorID, serverInfo, callStatsInitListener);
        } else {
            callStats.initialize(id, appSecret, initiatorID, serverInfo, callStatsInitListener);
        }
    }

    public void stopStatsService(BundleContext context, int id) {
        ServiceRegistration<StatsService> serviceRegistration = this.statsServiceInstanceRegistrations.remove(id);
        this.callStatsInstances.remove(id);
        if (serviceRegistration == null) {
            return;
        }
        serviceRegistration.unregister();
    }

    private ServerInfo createServerInfo(BundleContext bundleContext, boolean isClient) {
        VersionService versionService;
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setOs(System.getProperty("os.name"));
        ServiceReference serviceReference = bundleContext == null ? null : bundleContext.getServiceReference(VersionService.class);
        VersionService versionService2 = versionService = serviceReference == null ? null : (VersionService)bundleContext.getService(serviceReference);
        if (versionService != null) {
            Version version = versionService.getCurrentVersion();
            serverInfo.setName(version.getApplicationName());
            serverInfo.setVer(version.toString());
        }
        String endpointType = "middlebox";
        if (isClient) {
            endpointType = "browser";
        }
        serverInfo.setEndpointType(endpointType);
        return serverInfo;
    }

    private void callStatsOnError(CallStats callStats, CallStatsErrors error, String errMsg) {
        logger.error((Object)("callstats.io Java library failed to initialize with error: " + error + " and error message: " + errMsg));
    }

    private void callStatsOnInitialized(int id, BundleContext context, CallStats callStats, String msg) {
        if (this.statsServiceInstanceRegistrations.containsKey(id)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("callstats.io Java library initialized successfully with message: " + msg));
        }
        ServiceRegistration serviceRegistration = context.registerService(StatsService.class, (Object)new StatsService(id, callStats), null);
        this.statsServiceInstanceRegistrations.put(id, (ServiceRegistration<StatsService>)serviceRegistration);
    }

    public static interface InitErrorCallback {
        public void errorCallback(String var1, String var2);
    }
}

