/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.KeepAliveStrategy;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.AbstractUdpListener;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.SinglePortUdpHarvester;
import org.ice4j.ice.harvest.TcpHarvester;
import org.ice4j.socket.DTLSDatagramFilter;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.MultiplexedSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.MultiplexingSocket;
import org.jitsi.eventadmin.EventAdmin;
import org.jitsi.impl.neomedia.rtp.TransportCCEngine;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.DefaultTCPStreamConnector;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.health.Health;
import org.jitsi.videobridge.rest.ColibriWebSocketService;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidatePacketExtension;
import org.jitsi.xmpp.extensions.jingle.CandidateType;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtcpmuxPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.osgi.framework.BundleContext;

public class IceUdpTransportManager
extends TransportManager {
    private static final String DEFAULT_ICE_STREAM_NAME = "stream";
    public static final String DISABLE_TCP_HARVESTER = "org.jitsi.videobridge.DISABLE_TCP_HARVESTER";
    public static final String SINGLE_PORT_HARVESTER_PORT = "org.jitsi.videobridge.SINGLE_PORT_HARVESTER_PORT";
    public static final String KEEP_ALIVE_STRATEGY_PNAME = "org.jitsi.videobridge.KEEP_ALIVE_STRATEGY";
    private static KeepAliveStrategy keepAliveStrategy = KeepAliveStrategy.SELECTED_AND_TCP;
    private static final int SINGLE_PORT_DEFAULT_VALUE = 10000;
    private static final Logger classLogger = Logger.getLogger(IceUdpTransportManager.class);
    private static final int TCP_DEFAULT_PORT = 443;
    private static final int TCP_FALLBACK_PORT = 4443;
    public static final String TCP_HARVESTER_MAPPED_PORT = "org.jitsi.videobridge.TCP_HARVESTER_MAPPED_PORT";
    public static final String TCP_HARVESTER_PORT = "org.jitsi.videobridge.TCP_HARVESTER_PORT";
    public static final String TCP_HARVESTER_SSLTCP = "org.jitsi.videobridge.TCP_HARVESTER_SSLTCP";
    public static final String ICE_UFRAG_PREFIX_PNAME = "org.jitsi.videobridge.ICE_UFRAG_PREFIX";
    private static String iceUfragPrefix;
    private static final boolean TCP_HARVESTER_SSLTCP_DEFAULT = true;
    private static TcpHarvester tcpHarvester;
    private static List<SinglePortUdpHarvester> singlePortHarvesters;
    public static boolean healthy;
    private static boolean staticConfigurationInitialized;
    private static int tcpHarvesterMappedPort;
    private static boolean useComponentSocket;
    public static final String USE_COMPONENT_SOCKET_PNAME = "org.jitsi.videobridge.USE_COMPONENT_SOCKET";
    private Channel channelForDtls = null;
    private boolean closed = false;
    private final Conference conference;
    private final DiagnosticContext diagnosticContext = new DiagnosticContext();
    private final String id;
    private Thread connectThread;
    private final Object connectThreadSyncRoot = new Object();
    private final DtlsControlImpl dtlsControl;
    private Agent iceAgent;
    private final PropertyChangeListener iceAgentStateChangeListener = this::iceAgentStateChange;
    private boolean iceConnected = false;
    private final IceMediaStream iceStream;
    private final PropertyChangeListener iceStreamPairChangeListener = this::iceStreamPairChange;
    private final boolean controlling;
    private int numComponents;
    private boolean rtcpmux;
    private SctpConnection sctpConnection = null;
    private final Logger logger;
    private final TransportCCEngine transportCCEngine;
    private static final String PERMANENT_FAILURE_PNAME;
    private static BundleContext bundleContext;
    private static boolean permanentFailureMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeStaticConfiguration(ConfigurationService cfg) {
        Class<IceUdpTransportManager> clazz = IceUdpTransportManager.class;
        synchronized (IceUdpTransportManager.class) {
            if (staticConfigurationInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            staticConfigurationInitialized = true;
            useComponentSocket = cfg.getBoolean(USE_COMPONENT_SOCKET_PNAME, useComponentSocket);
            classLogger.info((Object)("Using component socket: " + useComponentSocket));
            iceUfragPrefix = cfg.getString(ICE_UFRAG_PREFIX_PNAME, null);
            String strategyName = cfg.getString(KEEP_ALIVE_STRATEGY_PNAME);
            KeepAliveStrategy strategy = KeepAliveStrategy.fromString((String)strategyName);
            if (strategyName != null && strategy == null) {
                classLogger.warn((Object)("Invalid keep alive strategy name: " + strategyName));
            } else if (strategy != null) {
                keepAliveStrategy = strategy;
            }
            int singlePort = cfg.getInt(SINGLE_PORT_HARVESTER_PORT, 10000);
            if (singlePort != -1) {
                singlePortHarvesters = SinglePortUdpHarvester.createHarvesters((int)singlePort);
                if (singlePortHarvesters.isEmpty()) {
                    singlePortHarvesters = null;
                    classLogger.info((Object)"No single-port harvesters created.");
                }
                boolean bl = healthy = singlePortHarvesters != null;
            }
            if (!cfg.getBoolean(DISABLE_TCP_HARVESTER, false)) {
                int mappedPort;
                int port = cfg.getInt(TCP_HARVESTER_PORT, -1);
                boolean fallback = false;
                boolean ssltcp = cfg.getBoolean(TCP_HARVESTER_SSLTCP, true);
                if (port == -1) {
                    port = 443;
                    fallback = true;
                }
                try {
                    tcpHarvester = new TcpHarvester(port, ssltcp);
                }
                catch (IOException ioe) {
                    classLogger.warn((Object)("Failed to initialize TCP harvester on port " + port + ": " + ioe + (fallback ? ". Retrying on port 4443" : "") + "."));
                }
                if (tcpHarvester == null) {
                    if (!fallback) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    port = 4443;
                    try {
                        tcpHarvester = new TcpHarvester(port, ssltcp);
                    }
                    catch (IOException ioe) {
                        classLogger.warn((Object)("Failed to initialize TCP harvester on fallback port " + port + ": " + ioe));
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                if (classLogger.isInfoEnabled()) {
                    classLogger.info((Object)("Initialized TCP harvester on port " + port + ", using SSLTCP:" + ssltcp));
                }
                if ((mappedPort = cfg.getInt(TCP_HARVESTER_MAPPED_PORT, -1)) != -1) {
                    tcpHarvesterMappedPort = mappedPort;
                    tcpHarvester.addMappedPort(mappedPort);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeStaticConfiguration(ConfigurationService cfg) {
        Class<IceUdpTransportManager> clazz = IceUdpTransportManager.class;
        synchronized (IceUdpTransportManager.class) {
            if (!staticConfigurationInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            staticConfigurationInitialized = false;
            if (singlePortHarvesters != null) {
                singlePortHarvesters.forEach(AbstractUdpListener::close);
                singlePortHarvesters = null;
            }
            if (tcpHarvester != null) {
                tcpHarvester.close();
                tcpHarvester = null;
            }
            healthy = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public IceUdpTransportManager(Conference conference, boolean controlling) throws IOException {
        this(conference, controlling, 2, DEFAULT_ICE_STREAM_NAME, null);
    }

    public IceUdpTransportManager(Conference conference, boolean controlling, int numComponents) throws IOException {
        this(conference, controlling, numComponents, DEFAULT_ICE_STREAM_NAME, null);
    }

    public IceUdpTransportManager(Conference conference, boolean controlling, int numComponents, String id) throws IOException {
        this(conference, controlling, numComponents, DEFAULT_ICE_STREAM_NAME, id);
    }

    public IceUdpTransportManager(Conference conference, boolean controlling, int numComponents, String iceStreamName, String id) throws IOException {
        this.conference = conference;
        this.id = id;
        this.controlling = controlling;
        this.numComponents = numComponents;
        this.rtcpmux = numComponents == 1;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)conference.getLogger());
        this.transportCCEngine = new TransportCCEngine(this.diagnosticContext);
        conference.appendDiagnosticInformation(this.diagnosticContext);
        this.diagnosticContext.put((Object)"transport", (Object)this.hashCode());
        this.dtlsControl = this.createDtlsControl();
        this.iceAgent = this.createIceAgent(controlling, iceStreamName, this.rtcpmux);
        this.iceAgent.addStateChangeListener(this.iceAgentStateChangeListener);
        this.iceStream = this.iceAgent.getStream(iceStreamName);
        this.iceStream.addPairChangeListener(this.iceStreamPairChangeListener);
        EventAdmin eventAdmin = conference.getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.transportCreated(this));
        }
    }

    public IceUdpTransportManager(Conference conference, boolean controlling, String iceStreamName) throws IOException {
        this(conference, controlling, 2, iceStreamName);
    }

    @Override
    public boolean addChannel(Channel channel) {
        EventAdmin eventAdmin;
        if (this.closed) {
            return false;
        }
        if (channel instanceof SctpConnection && this.sctpConnection != null && this.sctpConnection != channel) {
            this.logger.error((Object)"Not adding a second SctpConnection to TransportManager.");
            return false;
        }
        if (!super.addChannel(channel)) {
            return false;
        }
        if (channel instanceof SctpConnection) {
            this.sctpConnection = (SctpConnection)channel;
            if (this.channelForDtls != null && this.channelForDtls instanceof RtpChannel) {
                RtpChannel rtpChannelForDtls = (RtpChannel)this.channelForDtls;
                rtpChannelForDtls.getDatagramFilter(false).setAcceptNonRtp(false);
                rtpChannelForDtls.getDatagramFilter(true).setAcceptNonRtp(false);
            }
            this.channelForDtls = this.sctpConnection;
        } else if (this.channelForDtls == null) {
            this.channelForDtls = channel;
            RtpChannel rtpChannel = (RtpChannel)channel;
            rtpChannel.getDatagramFilter(false).setAcceptNonRtp(true);
            rtpChannel.getDatagramFilter(true).setAcceptNonRtp(!this.rtcpmux);
        }
        if (this.iceConnected) {
            channel.transportConnected();
        }
        if ((eventAdmin = this.conference.getEventAdmin()) != null) {
            eventAdmin.sendEvent(EventFactory.transportChannelAdded(channel));
        }
        return true;
    }

    private int addRemoteCandidates(List<CandidatePacketExtension> candidates, boolean iceAgentStateIsRunning) {
        Collections.sort(candidates);
        int generation = this.iceAgent.getGeneration();
        int remoteCandidateCount = 0;
        for (CandidatePacketExtension candidate : candidates) {
            int relPort;
            if (candidate.getGeneration() != generation) continue;
            if (this.rtcpmux && 2 == candidate.getComponent()) {
                this.logger.warn((Object)"Received an RTCP candidate, but we're using rtcp-mux. Ignoring.");
                continue;
            }
            Component component = this.iceStream.getComponent(candidate.getComponent());
            TransportAddress relatedAddress = null;
            String relAddr = candidate.getRelAddr();
            if (relAddr != null && (relPort = candidate.getRelPort()) != -1) {
                relatedAddress = new TransportAddress(relAddr, relPort, Transport.parse((String)candidate.getProtocol()));
            }
            RemoteCandidate relatedCandidate = component.findRemoteCandidate(relatedAddress);
            RemoteCandidate remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse((String)candidate.getProtocol())), component, org.ice4j.ice.CandidateType.parse((String)candidate.getType().toString()), candidate.getFoundation(), (long)candidate.getPriority(), relatedCandidate);
            if (!this.canReach(component, remoteCandidate)) continue;
            if (iceAgentStateIsRunning) {
                component.addUpdateRemoteCandidates(remoteCandidate);
            } else {
                component.addRemoteCandidate(remoteCandidate);
            }
            ++remoteCandidateCount;
        }
        return remoteCandidateCount;
    }

    private void configureHarvesters(Agent iceAgent, boolean rtcpmux) {
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)this.getBundleContext(), ConfigurationService.class);
        boolean disableDynamicHostHarvester = false;
        if (rtcpmux) {
            IceUdpTransportManager.initializeStaticConfiguration(cfg);
            if (tcpHarvester != null) {
                iceAgent.addCandidateHarvester((CandidateHarvester)tcpHarvester);
            }
            if (singlePortHarvesters != null) {
                for (CandidateHarvester candidateHarvester : singlePortHarvesters) {
                    iceAgent.addCandidateHarvester(candidateHarvester);
                    disableDynamicHostHarvester = true;
                }
            }
        }
        if (disableDynamicHostHarvester) {
            iceAgent.setUseHostHarvester(false);
        }
    }

    private boolean canReach(Component component, RemoteCandidate remoteCandidate) {
        return component.getLocalCandidates().stream().anyMatch(localCandidate -> localCandidate.canReach((Candidate)remoteCandidate));
    }

    @Override
    protected void channelPropertyChange(PropertyChangeEvent ev) {
        super.channelPropertyChange(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.getChannels().forEach(this::close);
            if (this.dtlsControl != null) {
                this.dtlsControl.start(null);
                this.dtlsControl.cleanup((Object)this);
            }
            if (this.iceStream != null) {
                this.iceStream.removePairStateChangeListener(this.iceStreamPairChangeListener);
            }
            if (this.iceAgent != null) {
                this.iceAgent.removeStateChangeListener(this.iceAgentStateChangeListener);
                this.iceAgent.free();
                this.iceAgent = null;
            }
            Object object = this.connectThreadSyncRoot;
            synchronized (object) {
                if (this.connectThread != null) {
                    this.connectThread.interrupt();
                }
            }
            super.close();
        }
    }

    @Override
    public boolean close(Channel channel) {
        boolean removed = super.close(channel);
        if (removed) {
            if (channel == this.sctpConnection) {
                this.sctpConnection = null;
            }
            if (channel == this.channelForDtls) {
                if (this.sctpConnection != null) {
                    this.channelForDtls = this.sctpConnection;
                } else if (channel instanceof RtpChannel) {
                    RtpChannel newChannelForDtls = null;
                    for (Channel c : this.getChannels()) {
                        if (!(c instanceof RtpChannel)) continue;
                        newChannelForDtls = (RtpChannel)c;
                    }
                    if (newChannelForDtls != null) {
                        newChannelForDtls.getDatagramFilter(false).setAcceptNonRtp(true);
                        newChannelForDtls.getDatagramFilter(true).setAcceptNonRtp(!this.rtcpmux);
                    }
                    this.channelForDtls = newChannelForDtls;
                }
                if (channel instanceof RtpChannel) {
                    RtpChannel rtpChannel = (RtpChannel)channel;
                    rtpChannel.getDatagramFilter(false).setAcceptNonRtp(false);
                    rtpChannel.getDatagramFilter(true).setAcceptNonRtp(false);
                }
            }
            try {
                StreamConnector connector = channel.getStreamConnector();
                if (connector != null) {
                    Socket socket;
                    DatagramSocket datagramSocket = connector.getDataSocket();
                    if (datagramSocket != null) {
                        datagramSocket.close();
                    }
                    if ((datagramSocket = connector.getControlSocket()) != null) {
                        datagramSocket.close();
                    }
                    if ((socket = connector.getDataTCPSocket()) != null) {
                        socket.close();
                    }
                    if ((socket = connector.getControlTCPSocket()) != null) {
                        socket.close();
                    }
                }
            }
            catch (IOException ioe) {
                this.logger.info((Object)("Failed to close sockets when closing a channel:" + ioe));
            }
            EventAdmin eventAdmin = this.conference.getEventAdmin();
            if (eventAdmin != null) {
                eventAdmin.sendEvent(EventFactory.transportChannelRemoved(channel));
            }
            channel.transportClosed();
        }
        if (this.getChannels().isEmpty()) {
            this.close();
        }
        return removed;
    }

    private DtlsControlImpl createDtlsControl() {
        DtlsControlImpl dtlsControl = new DtlsControlImpl(false);
        dtlsControl.registerUser((Object)this);
        dtlsControl.setSetup(this.controlling ? DtlsControl.Setup.ACTPASS : DtlsControl.Setup.ACTIVE);
        dtlsControl.start(MediaType.AUDIO);
        return dtlsControl;
    }

    private Agent createIceAgent(boolean controlling, String iceStreamName, boolean rtcpmux) throws IOException {
        int maxAllocatedPort;
        Agent iceAgent = new Agent(this.logger.getLevel(), iceUfragPrefix);
        this.configureHarvesters(iceAgent, rtcpmux);
        iceAgent.setControlling(controlling);
        iceAgent.setPerformConsentFreshness(true);
        int portBase = portTracker.getPort();
        IceMediaStream iceStream = iceAgent.createMediaStream(iceStreamName);
        iceAgent.createComponent(iceStream, Transport.UDP, portBase, portBase, portBase + 100, keepAliveStrategy, useComponentSocket);
        if (this.numComponents > 1) {
            iceAgent.createComponent(iceStream, Transport.UDP, portBase + 1, portBase + 1, portBase + 101, keepAliveStrategy, useComponentSocket);
        }
        if ((maxAllocatedPort = this.getMaxAllocatedPort(iceStream, portTracker.getMinPort(), portTracker.getMaxPort())) > 0) {
            int nextPort = 1 + maxAllocatedPort;
            portTracker.setNextPort(nextPort);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Updating the port tracker min port: " + nextPort));
            }
        }
        return iceAgent;
    }

    private int getMaxAllocatedPort(IceMediaStream iceStream, int min, int max) {
        return Math.max(this.getMaxAllocatedPort(iceStream.getComponent(1), min, max), this.getMaxAllocatedPort(iceStream.getComponent(2), min, max));
    }

    private int getMaxAllocatedPort(Component component, int min, int max) {
        int maxAllocatedPort = -1;
        if (component != null) {
            for (LocalCandidate candidate : component.getLocalCandidates()) {
                int candidatePort = candidate.getTransportAddress().getPort();
                if (min > candidatePort || candidatePort > max || maxAllocatedPort >= candidatePort) continue;
                maxAllocatedPort = candidatePort;
            }
        }
        return maxAllocatedPort;
    }

    @Override
    protected void describe(IceUdpTransportPacketExtension pe) {
        if (!this.closed) {
            pe.setPassword(this.iceAgent.getLocalPassword());
            pe.setUfrag(this.iceAgent.getLocalUfrag());
            for (Component component : this.iceStream.getComponents()) {
                List candidates = component.getLocalCandidates();
                if (candidates == null || candidates.isEmpty()) continue;
                for (LocalCandidate candidate : candidates) {
                    if (candidate.getTransport() == Transport.TCP && tcpHarvesterMappedPort != -1 && candidate.getTransportAddress().getPort() != tcpHarvesterMappedPort) continue;
                    this.describe(candidate, pe);
                }
            }
            String colibriWsUrl = this.getColibriWsUrl();
            if (colibriWsUrl != null) {
                WebSocketPacketExtension wsPacketExtension = new WebSocketPacketExtension(colibriWsUrl);
                pe.addChildExtension((ExtensionElement)wsPacketExtension);
            }
            if (this.rtcpmux) {
                pe.addChildExtension((ExtensionElement)new RtcpmuxPacketExtension());
            }
            this.describeDtlsControl(pe);
        }
    }

    private String getColibriWsUrl() {
        BundleContext bundleContext = this.getConference().getVideobridge().getBundleContext();
        ColibriWebSocketService colibriWebSocketService = (ColibriWebSocketService)ServiceUtils.getService((BundleContext)bundleContext, ColibriWebSocketService.class);
        if (colibriWebSocketService != null) {
            return colibriWebSocketService.getColibriWebSocketUrl(this.getConference().getID(), this.id, this.iceAgent.getLocalPassword());
        }
        return null;
    }

    private void describe(LocalCandidate candidate, IceUdpTransportPacketExtension pe) {
        CandidatePacketExtension candidatePE = new CandidatePacketExtension();
        Component component = candidate.getParentComponent();
        candidatePE.setComponent(component.getComponentID());
        candidatePE.setFoundation(candidate.getFoundation());
        candidatePE.setGeneration(component.getParentStream().getParentAgent().getGeneration());
        candidatePE.setID(this.generateCandidateID(candidate));
        candidatePE.setNetwork(0);
        candidatePE.setPriority(candidate.getPriority());
        Transport transport = candidate.getTransport();
        if (transport == Transport.TCP && candidate.isSSL()) {
            transport = Transport.SSLTCP;
        }
        candidatePE.setProtocol(transport.toString());
        if (transport == Transport.TCP || transport == Transport.SSLTCP) {
            candidatePE.setTcpType(candidate.getTcpType().toString());
        }
        candidatePE.setType(CandidateType.valueOf((String)candidate.getType().toString()));
        TransportAddress transportAddress = candidate.getTransportAddress();
        candidatePE.setIP(transportAddress.getHostAddress());
        candidatePE.setPort(transportAddress.getPort());
        TransportAddress relatedAddress = candidate.getRelatedAddress();
        if (relatedAddress != null) {
            candidatePE.setRelAddr(relatedAddress.getHostAddress());
            candidatePE.setRelPort(relatedAddress.getPort());
        }
        pe.addChildExtension((ExtensionElement)candidatePE);
    }

    private void describeDtlsControl(IceUdpTransportPacketExtension transportPE) {
        DtlsControlImpl dtlsControl = this.dtlsControl;
        String fingerprint = dtlsControl.getLocalFingerprint();
        String hash = dtlsControl.getLocalFingerprintHashFunction();
        DtlsFingerprintPacketExtension fingerprintPE = (DtlsFingerprintPacketExtension)transportPE.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (fingerprintPE == null) {
            fingerprintPE = new DtlsFingerprintPacketExtension();
            transportPE.addChildExtension((ExtensionElement)fingerprintPE);
        }
        fingerprintPE.setFingerprint(fingerprint);
        fingerprintPE.setHash(hash);
        DtlsControl.Setup setup = dtlsControl.getSetup();
        if (setup != null) {
            fingerprintPE.setSetup(setup.toString());
        }
    }

    private synchronized void doStartConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        Component rtcpComponent;
        if (this.closed) {
            return;
        }
        this.setRtcpmux(transport);
        this.setRemoteFingerprints(transport);
        IceProcessingState iceAgentState = this.iceAgent.getState();
        if (iceAgentState.isEstablished()) {
            return;
        }
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING.equals((Object)iceAgentState);
        if (this.rtcpmux && (rtcpComponent = this.iceStream.getComponent(2)) != null) {
            this.iceStream.removeComponent(rtcpComponent);
        }
        this.setRemoteUfragAndPwd(transport);
        List candidates = transport.getChildExtensionsOfType(CandidatePacketExtension.class);
        if (iceAgentStateIsRunning && candidates.isEmpty()) {
            return;
        }
        int remoteCandidateCount = this.addRemoteCandidates(candidates, iceAgentStateIsRunning);
        if (iceAgentStateIsRunning) {
            if (remoteCandidateCount != 0) {
                this.iceAgent.getStreams().forEach(stream -> stream.getComponents().forEach(Component::updateRemoteCandidates));
            }
        } else if (remoteCandidateCount != 0) {
            if (this.iceAgent.getStreams().stream().allMatch(stream -> stream.getComponents().stream().allMatch(component -> component.getRemoteCandidateCount() >= 1))) {
                this.logger.info((Object)"We have remote candidates for all ICE components. Starting the ICE agent.");
                this.iceAgent.startConnectivityEstablishment();
            }
        } else if (this.iceStream.getRemoteUfrag() != null && this.iceStream.getRemotePassword() != null) {
            this.logger.info((Object)"Starting ICE agent without remote candidates.");
            this.iceAgent.startConnectivityEstablishment();
        }
    }

    private String generateCandidateID(LocalCandidate candidate) {
        StringBuilder candidateID = new StringBuilder();
        candidateID.append(this.conference.getID());
        candidateID.append(Long.toHexString(this.hashCode()));
        Agent iceAgent = candidate.getParentComponent().getParentStream().getParentAgent();
        candidateID.append(Long.toHexString(iceAgent.hashCode()));
        candidateID.append(Long.toHexString(iceAgent.getGeneration()));
        candidateID.append(Long.toHexString(candidate.hashCode()));
        return candidateID.toString();
    }

    public Conference getConference() {
        return this.conference;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getLocalUfrag() {
        Agent iceAgent = this.iceAgent;
        return iceAgent == null ? null : iceAgent.getLocalUfrag();
    }

    public String getIcePassword() {
        Agent iceAgent = this.iceAgent;
        return iceAgent == null ? null : iceAgent.getLocalPassword();
    }

    public IceMediaStream getIceStream() {
        return this.iceStream;
    }

    public boolean isControlling() {
        return this.controlling;
    }

    public boolean isRtcpmux() {
        return this.rtcpmux;
    }

    public BundleContext getBundleContext() {
        return this.conference != null ? this.conference.getBundleContext() : null;
    }

    @Override
    public SrtpControl getSrtpControl(Channel channel) {
        return this.dtlsControl;
    }

    @Override
    public StreamConnector getStreamConnector(Channel channel) {
        if (!this.getChannels().contains(channel)) {
            return null;
        }
        IceSocketWrapper rtpSocket = this.getSocketForComponent(this.iceStream.getComponent(1));
        IceSocketWrapper rtcpSocket = this.numComponents > 1 && !this.rtcpmux ? this.getSocketForComponent(this.iceStream.getComponent(2)) : rtpSocket;
        if (rtpSocket == null || rtcpSocket == null) {
            throw new IllegalStateException("No sockets from ice4j.");
        }
        if (channel instanceof SctpConnection) {
            MultiplexingDatagramSocket multiplexing;
            DatagramSocket udpSocket = rtpSocket.getUDPSocket();
            Socket tcpSocket = rtpSocket.getTCPSocket();
            if (udpSocket instanceof MultiplexingDatagramSocket) {
                multiplexing = (MultiplexingDatagramSocket)udpSocket;
                try {
                    MultiplexedDatagramSocket dtlsSocket = multiplexing.getSocket((DatagramPacketFilter)new DTLSDatagramFilter());
                    return new DefaultStreamConnector((DatagramSocket)dtlsSocket, null);
                }
                catch (SocketException se) {
                    this.logger.warn((Object)("Failed to create DTLS socket: " + se));
                }
            } else if (tcpSocket instanceof MultiplexingSocket) {
                multiplexing = (MultiplexingSocket)tcpSocket;
                try {
                    MultiplexedSocket dtlsSocket = multiplexing.getSocket((DatagramPacketFilter)new DTLSDatagramFilter());
                    return new DefaultTCPStreamConnector((Socket)dtlsSocket, null);
                }
                catch (IOException ioe) {
                    this.logger.warn((Object)("Failed to create DTLS socket: " + ioe));
                }
            } else {
                this.logger.warn((Object)"No valid sockets from ice4j.");
                return null;
            }
        }
        if (!(channel instanceof RtpChannel)) {
            return null;
        }
        RtpChannel rtpChannel = (RtpChannel)channel;
        DatagramSocket rtpUdpSocket = rtpSocket.getUDPSocket();
        DatagramSocket rtcpUdpSocket = rtcpSocket.getUDPSocket();
        if (rtpUdpSocket instanceof MultiplexingDatagramSocket && rtcpUdpSocket instanceof MultiplexingDatagramSocket) {
            return this.getUDPStreamConnector(rtpChannel, (MultiplexingDatagramSocket)rtpUdpSocket, (MultiplexingDatagramSocket)rtcpUdpSocket);
        }
        Socket rtpTcpSocket = rtpSocket.getTCPSocket();
        Socket rtcpTcpSocket = rtcpSocket.getTCPSocket();
        if (rtpTcpSocket instanceof MultiplexingSocket && rtcpTcpSocket instanceof MultiplexingSocket) {
            return this.getTCPStreamConnector(rtpChannel, (MultiplexingSocket)rtpTcpSocket, (MultiplexingSocket)rtcpTcpSocket);
        }
        this.logger.warn((Object)"No valid sockets from ice4j");
        return null;
    }

    private StreamConnector getUDPStreamConnector(RtpChannel rtpChannel, MultiplexingDatagramSocket rtpSocket, MultiplexingDatagramSocket rtcpSocket) {
        Objects.requireNonNull(rtpSocket, "rtpSocket");
        Objects.requireNonNull(rtcpSocket, "rtcpSocket");
        try {
            MultiplexedDatagramSocket channelRtpSocket = rtpSocket.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(false));
            MultiplexedDatagramSocket channelRtcpSocket = rtcpSocket.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(true));
            return new DefaultStreamConnector((DatagramSocket)channelRtpSocket, (DatagramSocket)channelRtcpSocket, this.rtcpmux);
        }
        catch (SocketException se) {
            this.logger.error((Object)"An unexpected exception occurred.", (Throwable)se);
            return null;
        }
    }

    private StreamConnector getTCPStreamConnector(RtpChannel rtpChannel, MultiplexingSocket rtpSocket, MultiplexingSocket rtcpSocket) {
        Objects.requireNonNull(rtpSocket, "rtpSocket");
        Objects.requireNonNull(rtcpSocket, "rtcpSocket");
        try {
            MultiplexedSocket channelRtpSocket = rtpSocket.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(false));
            MultiplexedSocket channelRtcpSocket = rtcpSocket.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(true));
            return new DefaultTCPStreamConnector((Socket)channelRtpSocket, (Socket)channelRtcpSocket, this.rtcpmux);
        }
        catch (SocketException se) {
            this.logger.error((Object)"An unexpected exception occurred.", (Throwable)se);
            return null;
        }
    }

    private IceSocketWrapper getSocketForComponent(Component component) {
        if (useComponentSocket) {
            return component.getSocketWrapper();
        }
        CandidatePair selectedPair = component.getSelectedPair();
        return selectedPair == null ? null : selectedPair.getIceSocketWrapper();
    }

    private MediaStreamTarget getStreamTarget() {
        TransportAddress streamTargetAddress;
        CandidatePair selectedPair;
        Component rtcpComponent;
        TransportAddress streamTargetAddress2;
        CandidatePair selectedPair2;
        MediaStreamTarget streamTarget = null;
        InetSocketAddress[] streamTargetAddresses = new InetSocketAddress[2];
        int streamTargetAddressCount = 0;
        Component rtpComponent = this.iceStream.getComponent(1);
        if (rtpComponent != null && (selectedPair2 = rtpComponent.getSelectedPair()) != null && (streamTargetAddress2 = selectedPair2.getRemoteCandidate().getTransportAddress()) != null) {
            streamTargetAddresses[0] = streamTargetAddress2;
            ++streamTargetAddressCount;
        }
        if (this.rtcpmux) {
            streamTargetAddresses[1] = streamTargetAddresses[0];
            ++streamTargetAddressCount;
        } else if (this.numComponents > 1 && (rtcpComponent = this.iceStream.getComponent(2)) != null && (selectedPair = rtcpComponent.getSelectedPair()) != null && (streamTargetAddress = selectedPair.getRemoteCandidate().getTransportAddress()) != null) {
            streamTargetAddresses[1] = streamTargetAddress;
            ++streamTargetAddressCount;
        }
        if (streamTargetAddressCount > 0) {
            streamTarget = new MediaStreamTarget(streamTargetAddresses[0], streamTargetAddresses[1]);
        }
        return streamTarget;
    }

    @Override
    public MediaStreamTarget getStreamTarget(Channel channel) {
        return this.getStreamTarget();
    }

    @Override
    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:ice-udp:1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iceAgentStateChange(PropertyChangeEvent ev) {
        boolean interrupted = false;
        try {
            IceProcessingState oldState = (IceProcessingState)ev.getOldValue();
            IceProcessingState newState = (IceProcessingState)ev.getNewValue();
            this.logger.info(Logger.Category.STATISTICS, "ice_state_change," + this.getLoggingId() + " old_state=" + oldState + ",new_state=" + newState);
            EventAdmin eventAdmin = this.conference.getEventAdmin();
            if (eventAdmin != null) {
                eventAdmin.sendEvent(EventFactory.transportStateChanged(this, oldState, newState));
            }
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                interrupted = true;
            } else if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void iceStreamPairChange(PropertyChangeEvent ev) {
        if ("PairConsentFreshnessChanged".equals(ev.getPropertyName())) {
            this.getChannels().forEach(channel -> channel.touch(Channel.ActivityType.TRANSPORT));
        }
    }

    private void onIceConnected() {
        EventAdmin eventAdmin;
        this.iceConnected = true;
        if (this.conference.includeInStatistics()) {
            Transport transport = this.getTransport();
            if (transport == null) {
                this.logger.warn((Object)"Cannot get transport type.");
            } else {
                Conference.Statistics statistics = this.conference.getStatistics();
                if (transport == Transport.TCP || transport == Transport.SSLTCP) {
                    statistics.totalTcpTransportManagers.incrementAndGet();
                } else if (transport == Transport.UDP) {
                    statistics.totalUdpTransportManagers.incrementAndGet();
                }
            }
        }
        if ((eventAdmin = this.conference.getEventAdmin()) != null) {
            eventAdmin.sendEvent(EventFactory.transportConnected(this));
        }
        this.getChannels().forEach(Channel::transportConnected);
    }

    private Transport getTransport() {
        CandidatePair selectedPair;
        Transport transport = null;
        Component component = this.iceStream.getComponent(1);
        if (component != null && (selectedPair = component.getSelectedPair()) != null) {
            transport = selectedPair.getLocalCandidate().getHostAddress().getTransport();
        }
        return transport;
    }

    private void setRemoteFingerprints(IceUdpTransportPacketExtension transport) {
        List dfpes = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
        if (!dfpes.isEmpty()) {
            LinkedHashMap<String, String> remoteFingerprints = new LinkedHashMap<String, String>();
            boolean setSetup = true;
            DtlsControl.Setup setup = null;
            for (DtlsFingerprintPacketExtension dfpe : dfpes) {
                remoteFingerprints.put(dfpe.getHash(), dfpe.getFingerprint());
                if (!setSetup) continue;
                String aSetupStr = dfpe.getSetup();
                DtlsControl.Setup aSetup = null;
                if (!StringUtils.isNullOrEmpty((String)aSetupStr, (boolean)true)) {
                    try {
                        aSetup = DtlsControl.Setup.parseSetup((String)aSetupStr);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.debug((Object)("Unable to parse: " + aSetupStr), (Throwable)e);
                    }
                }
                if (aSetup == null) {
                    setSetup = false;
                    continue;
                }
                if (setup == null) {
                    setup = aSetup;
                    continue;
                }
                if (setup.equals((Object)aSetup)) continue;
                setSetup = false;
            }
            if (setSetup && setup != null) {
                switch (setup) {
                    case ACTIVE: {
                        if (!DtlsControl.Setup.ACTIVE.equals((Object)this.dtlsControl.getSetup())) break;
                        this.dtlsControl.setSetup(DtlsControl.Setup.ACTPASS);
                        break;
                    }
                    case PASSIVE: {
                        this.dtlsControl.setSetup(DtlsControl.Setup.ACTIVE);
                        break;
                    }
                }
            }
            this.dtlsControl.setRemoteFingerprints(remoteFingerprints);
        }
    }

    private void setRemoteUfragAndPwd(IceUdpTransportPacketExtension transport) {
        String password;
        String ufrag = transport.getUfrag();
        if (ufrag != null) {
            this.iceStream.setRemoteUfrag(ufrag);
        }
        if ((password = transport.getPassword()) != null) {
            this.iceStream.setRemotePassword(password);
        }
    }

    private void setRtcpmux(IceUdpTransportPacketExtension transport) {
        if (transport.isRtcpMux()) {
            this.rtcpmux = true;
            if (this.channelForDtls != null && this.channelForDtls instanceof RtpChannel) {
                ((RtpChannel)this.channelForDtls).getDatagramFilter(true).setAcceptNonRtp(false);
            }
        }
        this.dtlsControl.setRtcpmux(this.rtcpmux);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        this.doStartConnectivityEstablishment(transport);
        Object object = this.connectThreadSyncRoot;
        synchronized (object) {
            if (this.connectThread == null) {
                this.connectThread = new Thread(() -> {
                    try {
                        this.wrapupConnectivityEstablishment();
                    }
                    catch (OperationFailedException ofe) {
                        this.logger.info((Object)("Failed to connect IceUdpTransportManager: " + (Object)((Object)ofe)));
                        Object object = this.connectThreadSyncRoot;
                        synchronized (object) {
                            this.connectThread = null;
                            return;
                        }
                    }
                    Agent iceAgent = this.iceAgent;
                    if (iceAgent == null) {
                        return;
                    }
                    IceProcessingState state = iceAgent.getState();
                    if (state.isEstablished()) {
                        this.onIceConnected();
                    } else {
                        this.logger.log(Level.WARNING, Logger.Category.STATISTICS, "ice_failed," + this.getLoggingId() + " state=" + state);
                    }
                });
                this.connectThread.setDaemon(true);
                this.connectThread.setName("IceUdpTransportManager connect thread");
                this.connectThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapupConnectivityEstablishment() throws OperationFailedException {
        final Object syncRoot = new Object();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                Agent iceAgent = (Agent)ev.getSource();
                if (iceAgent.isOver()) {
                    iceAgent.removeStateChangeListener((PropertyChangeListener)this);
                    if (iceAgent == IceUdpTransportManager.this.iceAgent) {
                        Object object = syncRoot;
                        synchronized (object) {
                            syncRoot.notify();
                        }
                    }
                }
            }
        };
        Agent iceAgent = this.iceAgent;
        if (iceAgent == null) {
            return;
        }
        iceAgent.addStateChangeListener(propertyChangeListener);
        boolean interrupted = false;
        IceProcessingState state = iceAgent.getState();
        Object object = syncRoot;
        synchronized (object) {
            while (IceProcessingState.RUNNING.equals((Object)state) || IceProcessingState.WAITING.equals((Object)state)) {
                try {
                    syncRoot.wait(1000L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                finally {
                    state = iceAgent.getState();
                    if (this.iceAgent != null) continue;
                    break;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        iceAgent.removeStateChangeListener(propertyChangeListener);
        if (this.iceAgent == null) {
            throw new OperationFailedException("TransportManager closed", 1);
        }
        if (IceProcessingState.FAILED.equals((Object)state)) {
            throw new OperationFailedException("ICE failed", 1);
        }
    }

    @Override
    public boolean isConnected() {
        return this.iceConnected;
    }

    private String getLoggingId() {
        return Channel.getLoggingId(this.channelForDtls);
    }

    @Override
    public TransportCCEngine getTransportCCEngine() {
        return this.transportCCEngine;
    }

    static {
        tcpHarvester = null;
        singlePortHarvesters = null;
        healthy = true;
        staticConfigurationInitialized = false;
        tcpHarvesterMappedPort = -1;
        useComponentSocket = true;
        PERMANENT_FAILURE_PNAME = Health.class.getName() + ".PERMANENT_FAILURE";
        bundleContext = null;
        permanentFailureMode = false;
    }
}

