/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.util.PortTracker;
import org.jitsi.impl.neomedia.rtp.TransportCCEngine;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.xmpp.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RawUdpTransportPacketExtension;

public abstract class TransportManager {
    private static long nextCandidateID = 1L;
    private static final Logger logger = Logger.getLogger(TransportManager.class);
    public static final int DEFAULT_MIN_PORT = 10001;
    public static final int DEFAULT_MAX_PORT = 20000;
    public static final PortTracker portTracker = new PortTracker(10001, 20000);
    private final PropertyChangeListener channelPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            TransportManager.this.channelPropertyChange(ev);
        }
    };
    private List<Channel> _channels = Collections.emptyList();
    private final Object _channelsSyncRoot = new Object();

    protected TransportManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(Channel channel) {
        Object object = this._channelsSyncRoot;
        synchronized (object) {
            if (!this._channels.contains(channel)) {
                LinkedList<Channel> newChannels = new LinkedList<Channel>(this._channels);
                newChannels.add(channel);
                this._channels = newChannels;
                channel.addPropertyChangeListener(this.channelPropertyChangeListener);
                return true;
            }
        }
        return false;
    }

    protected void channelPropertyChange(PropertyChangeEvent ev) {
    }

    public void close() {
        for (Channel channel : this.getChannels()) {
            this.close(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(Channel channel) {
        if (channel == null) {
            return false;
        }
        channel.removePropertyChangeListener(this.channelPropertyChangeListener);
        Object object = this._channelsSyncRoot;
        synchronized (object) {
            LinkedList<Channel> newChannels = new LinkedList<Channel>(this._channels);
            boolean removed = newChannels.remove(channel);
            if (removed) {
                this._channels = newChannels;
                if (this.getChannels().isEmpty()) {
                    channel.getContent().getConference().closeTransportManager(this);
                }
            }
            return removed;
        }
    }

    public void describe(ColibriConferenceIQ.ChannelBundle iq) {
        Object pe = iq.getTransport();
        String namespace = this.getXmlNamespace();
        if (pe == null || !namespace.equals(pe.getNamespace())) {
            pe = "urn:xmpp:jingle:transports:ice-udp:1".equals(namespace) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(namespace) ? new RawUdpTransportPacketExtension() : null);
            iq.setTransport(pe);
        }
        if (pe != null) {
            this.describe((IceUdpTransportPacketExtension)pe);
        }
    }

    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        Object pe = iq.getTransport();
        String namespace = this.getXmlNamespace();
        if (pe == null || !namespace.equals(pe.getNamespace())) {
            pe = "urn:xmpp:jingle:transports:ice-udp:1".equals(namespace) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(namespace) ? new RawUdpTransportPacketExtension() : null);
            iq.setTransport(pe);
        }
        if (pe != null) {
            this.describe((IceUdpTransportPacketExtension)pe);
        }
    }

    protected abstract void describe(IceUdpTransportPacketExtension var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateCandidateID() {
        Class<TransportManager> clazz = TransportManager.class;
        synchronized (TransportManager.class) {
            long candidateID = nextCandidateID++;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            return Long.toHexString(candidateID);
        }
    }

    protected List<Channel> getChannels() {
        return this._channels;
    }

    public abstract SrtpControl getSrtpControl(Channel var1);

    public abstract StreamConnector getStreamConnector(Channel var1);

    public abstract MediaStreamTarget getStreamTarget(Channel var1);

    public abstract String getXmlNamespace();

    public abstract void startConnectivityEstablishment(IceUdpTransportPacketExtension var1);

    public void payloadTypesChanged(RtpChannel channel) {
        this.checkPayloadTypes(channel);
    }

    private void checkPayloadTypes(RtpChannel channel) {
        for (Channel c : this.getChannels()) {
            if (!(c instanceof RtpChannel) || c == channel) continue;
            for (int pt1 : ((RtpChannel)c).getReceivePTs()) {
                for (int pt2 : channel.getReceivePTs()) {
                    if (pt1 != pt2) continue;
                    logger.warn((Object)("The same PT (" + pt1 + ") used by two channels in the same bundle."));
                }
            }
        }
    }

    public abstract boolean isConnected();

    public TransportCCEngine getTransportCCEngine() {
        return null;
    }
}

