/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.octo;

import org.jitsi.util.RTPUtils;
import org.jitsi.utils.MediaType;

public class OctoPacket {
    public static final int OCTO_HEADER_LENGTH = 8;
    public static final int OCTO_MEDIA_TYPE_AUDIO = 0;
    public static final int OCTO_MEDIA_TYPE_VIDEO = 1;
    public static final int OCTO_MEDIA_TYPE_DATA = 2;

    private static int getMediaTypeId(MediaType mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return 0;
            }
            case VIDEO: {
                return 1;
            }
            case DATA: {
                return 2;
            }
        }
        return -1;
    }

    public static void writeHeaders(byte[] buf, int off, boolean r, MediaType mediaType, int s, String conferenceId, String endpointId) {
        buf[off] = 0;
        if (r) {
            int n = off;
            buf[n] = (byte)(buf[n] | 0x80);
        }
        int n = off;
        buf[n] = (byte)(buf[n] | (OctoPacket.getMediaTypeId(mediaType) & 3) << 5);
        int n2 = off;
        buf[n2] = (byte)(buf[n2] | (s & 3) << 3);
        OctoPacket.writeConferenceId(conferenceId, buf, off, 8);
        OctoPacket.writeEndpointId(endpointId, buf, off, 8);
    }

    public static String readConferenceId(byte[] buf, int off, int len) {
        OctoPacket.assertMinLen(buf, off, len);
        int cid = RTPUtils.readUint24AsInt((byte[])buf, (int)(off + 1));
        return Integer.toHexString(cid);
    }

    public static MediaType readMediaType(byte[] buf, int off, int len) {
        OctoPacket.assertMinLen(buf, off, len);
        int mediaType = (buf[off] & 0x60) >> 5;
        switch (mediaType) {
            case 0: {
                return MediaType.AUDIO;
            }
            case 1: {
                return MediaType.VIDEO;
            }
            case 2: {
                return MediaType.DATA;
            }
        }
        return null;
    }

    public static boolean readRflag(byte[] buf, int off, int len) {
        OctoPacket.assertMinLen(buf, off, len);
        return (buf[off] & 0x80) != 0;
    }

    public static String readEndpointId(byte[] buf, int off, int len) {
        OctoPacket.assertMinLen(buf, off, len);
        long eid = RTPUtils.readUint32AsLong((byte[])buf, (int)(off + 4));
        return Long.toHexString(eid);
    }

    public static void writeConferenceId(String conferenceId, byte[] buf, int off, int len) {
        OctoPacket.assertMinLen(buf, off, len);
        int cid = Integer.parseInt(conferenceId, 16);
        RTPUtils.writeUint24((byte[])buf, (int)(off + 1), (int)cid);
    }

    public static void writeEndpointId(String endpointId, byte[] buf, int off, int len) {
        OctoPacket.assertMinLen(buf, off, len);
        long eid = Long.parseLong(endpointId, 16);
        RTPUtils.writeInt((byte[])buf, (int)(off + 4), (int)((int)eid));
    }

    private static void assertMinLen(byte[] buf, int off, int len) {
        if (!OctoPacket.verifyMinLength(buf, off, len, 8)) {
            throw new IllegalArgumentException("Invalid Octo packet.");
        }
    }

    private static boolean verifyMinLength(byte[] buf, int off, int len, int minLen) {
        return buf != null && off >= 0 && len >= minLen && minLen >= 0 && off + len < buf.length;
    }
}

