/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.util.Collection;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.meet.OSGi;
import org.jitsi.osgi.ServiceUtils2;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.xmpp.XmppCommon;
import org.jitsi.xmpp.component.ComponentBase;
import org.jitsi.xmpp.util.IQUtils;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;

public class ComponentImpl
extends ComponentBase
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(ComponentImpl.class);
    private static final String DESCRIPTION = "Jitsi Videobridge Jabber Component";
    private static final String NAME = "JitsiVideobridge";
    public static final String SUBDOMAIN = "jitsi-videobridge";
    private final XmppCommon common = new XmppCommon();

    public static Collection<ComponentImpl> getComponents(BundleContext bundleContext) {
        return ServiceUtils2.getServices((BundleContext)bundleContext, ComponentImpl.class);
    }

    public ComponentImpl(String host, int port, String domain, String subDomain, String secret) {
        super(host, port, domain, subDomain, secret);
    }

    protected String[] discoInfoFeatureNamespaces() {
        return (String[])XmppCommon.FEATURES.clone();
    }

    protected String discoInfoIdentityCategoryType() {
        return "conference";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    public Videobridge getVideobridge() {
        return this.common.getVideobridge();
    }

    private IQ handleIQ(IQ iq) throws Exception {
        try {
            org.jivesoftware.smack.packet.IQ resultSmackIQ;
            org.jivesoftware.smack.packet.IQ smackIQ = IQUtils.convert((IQ)iq);
            if (smackIQ == null) {
                if (iq.isRequest()) {
                    IQ error = new IQ(IQ.Type.error, iq.getID());
                    error.setFrom(iq.getTo());
                    error.setTo(iq.getFrom());
                    error.setError(new PacketError(PacketError.Condition.bad_request, PacketError.Type.modify, "Failed to parse incoming stanza"));
                    return error;
                }
                logger.error((Object)("Failed to convert stanza: " + iq.toXML()));
            }
            IQ resultIQ = (resultSmackIQ = this.common.handleIQ(smackIQ)) == null ? null : IQUtils.convert((org.jivesoftware.smack.packet.IQ)resultSmackIQ);
            return resultIQ;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to handle IQ with id=" + (iq == null ? "null" : iq.getID())), (Throwable)e);
            throw e;
        }
    }

    protected void handleIQErrorImpl(IQ iq) {
        super.handleIQErrorImpl(iq);
        try {
            this.handleIQ(iq);
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred while trying to handle an 'error' IQ.", (Throwable)e);
        }
    }

    protected IQ handleIQGetImpl(IQ iq) throws Exception {
        IQ resultIQ = this.handleIQ(iq);
        return resultIQ == null ? super.handleIQGetImpl(iq) : resultIQ;
    }

    protected void handleIQResultImpl(IQ iq) {
        super.handleIQResultImpl(iq);
        try {
            this.handleIQ(iq);
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred while trying to handle a 'result' IQ.", (Throwable)e);
        }
    }

    protected IQ handleIQSetImpl(IQ iq) throws Exception {
        IQ resultIQ = this.handleIQ(iq);
        return resultIQ == null ? super.handleIQSetImpl(iq) : resultIQ;
    }

    public void postComponentShutdown() {
        super.postComponentShutdown();
        OSGi.stop((BundleActivator)this);
    }

    public void postComponentStart() {
        super.postComponentStart();
        OSGi.start((BundleActivator)this);
    }

    public void send(org.jivesoftware.smack.packet.IQ iq) throws Exception {
        try {
            JID fromJID;
            Jid from = iq.getFrom();
            if ((from == null || from.length() == 0) && (fromJID = this.getJID()) != null) {
                iq.setFrom(JidCreate.from((String)fromJID.toString()));
            }
            IQ packet = IQUtils.convert((org.jivesoftware.smack.packet.IQ)iq);
            this.send((Packet)packet);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SENT: " + packet.toXML()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send an IQ with id=" + (iq == null ? "null" : iq.getStanzaId())), (Throwable)e);
            throw e;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.common.start(bundleContext);
        Collection<ComponentImpl> components = ComponentImpl.getComponents(bundleContext);
        if (!components.contains((Object)this)) {
            bundleContext.registerService(ComponentImpl.class, (Object)this, null);
        }
        ConfigurationService config = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        this.loadConfig(config, "org.jitsi.videobridge");
        if (!this.isPingTaskStarted()) {
            this.startPingTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            Collection serviceReferences = bundleContext.getServiceReferences(ComponentImpl.class, null);
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    Object service = bundleContext.getService(serviceReference);
                    if (service != this) continue;
                    bundleContext.ungetService(serviceReference);
                }
            }
        }
        finally {
            this.common.stop(bundleContext);
        }
    }
}

