/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class AbstractEndpointMessageTransport {
    private static final Logger classLogger = Logger.getLogger(AbstractEndpointMessageTransport.class);
    protected final AbstractEndpoint endpoint;
    private final Logger logger;

    public AbstractEndpointMessageTransport(AbstractEndpoint endpoint) {
        this.endpoint = endpoint;
        this.logger = Logger.getLogger((Logger)classLogger, endpoint == null ? null : endpoint.getConference().getLogger());
    }

    protected void notifyTransportChannelConnected() {
    }

    protected void onClientHello(Object src, JSONObject jsonObject) {
    }

    private void onJSONData(Object src, JSONObject jsonObject, String colibriClass) {
        switch (colibriClass) {
            case "SelectedEndpointChangedEvent": {
                this.onSelectedEndpointChangedEvent(src, jsonObject);
                break;
            }
            case "SelectedEndpointsChangedEvent": {
                this.onSelectedEndpointsChangedEvent(src, jsonObject);
                break;
            }
            case "PinnedEndpointChangedEvent": {
                this.onPinnedEndpointChangedEvent(src, jsonObject);
                break;
            }
            case "PinnedEndpointsChangedEvent": {
                this.onPinnedEndpointsChangedEvent(src, jsonObject);
                break;
            }
            case "ClientHello": {
                this.onClientHello(src, jsonObject);
                break;
            }
            case "EndpointMessage": {
                this.onClientEndpointMessage(src, jsonObject);
                break;
            }
            case "LastNChangedEvent": {
                this.onLastNChangedEvent(src, jsonObject);
                break;
            }
            case "ReceiverVideoConstraint": {
                this.onReceiverVideoConstraintEvent(src, jsonObject);
                break;
            }
            default: {
                this.logger.info((Object)("Received a message with unknown colibri class: " + colibriClass));
            }
        }
    }

    private void onClientEndpointMessage(Object src, JSONObject jsonObject) {
        List<AbstractEndpoint> endpointSubset;
        String to = (String)jsonObject.get((Object)"to");
        jsonObject.put((Object)"from", (Object)this.getId(jsonObject.get((Object)"from")));
        Conference conference = this.getConference();
        if (conference == null || conference.isExpired()) {
            this.logger.warn((Object)"Unable to send EndpointMessage, conference is null or expired");
            return;
        }
        if ("".equals(to)) {
            endpointSubset = new LinkedList<AbstractEndpoint>(conference.getEndpoints());
            endpointSubset.removeIf(e -> e.getID().equalsIgnoreCase(this.getId()));
        } else {
            AbstractEndpoint targetEndpoint = conference.getEndpoint(to);
            if (targetEndpoint != null) {
                endpointSubset = Collections.singletonList(targetEndpoint);
            } else {
                endpointSubset = Collections.emptyList();
                this.logger.warn((Object)("Unable to find endpoint " + to + " to send EndpointMessage"));
            }
        }
        this.sendMessageToEndpoints(jsonObject.toString(), endpointSubset);
    }

    protected void sendMessageToEndpoints(String msg, List<AbstractEndpoint> endpoints) {
        Conference conference = this.getConference();
        if (conference != null) {
            conference.sendMessage(msg, endpoints, true);
        }
    }

    protected Conference getConference() {
        return this.endpoint != null ? this.endpoint.getConference() : null;
    }

    private String getId() {
        return this.getId(null);
    }

    protected String getId(Object id) {
        return this.endpoint != null ? this.endpoint.getID() : null;
    }

    protected abstract void onPinnedEndpointChangedEvent(Object var1, JSONObject var2);

    protected abstract void onPinnedEndpointsChangedEvent(Object var1, JSONObject var2);

    protected abstract void onSelectedEndpointChangedEvent(Object var1, JSONObject var2);

    protected abstract void onSelectedEndpointsChangedEvent(Object var1, JSONObject var2);

    protected void onLastNChangedEvent(Object src, JSONObject jsonObject) {
        Object o = jsonObject.get((Object)"lastN");
        if (!(o instanceof Number)) {
            return;
        }
        int lastN = ((Number)o).intValue();
        if (this.endpoint != null) {
            for (RtpChannel channel : this.endpoint.getChannels(MediaType.VIDEO)) {
                channel.setLastN(lastN);
            }
        }
    }

    protected void onReceiverVideoConstraintEvent(Object src, JSONObject jsonObject) {
        Object o = jsonObject.get((Object)"maxFrameHeight");
        if (!(o instanceof Number)) {
            this.logger.warn((Object)("Received a non-number maxFrameHeight video constraint from " + this.getId() + ": " + o.toString()));
            return;
        }
        int maxFrameHeight = ((Number)o).intValue();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received a maxFrameHeight video constraint from " + this.getId() + ": " + maxFrameHeight));
        }
        if (this.endpoint != null) {
            for (RtpChannel channel : this.endpoint.getChannels(MediaType.VIDEO)) {
                if (!(channel instanceof VideoChannel)) continue;
                ((VideoChannel)channel).setMaxFrameHeight(maxFrameHeight);
            }
        }
    }

    public void onMessage(Object src, String msg) {
        Object obj;
        JSONParser parser = new JSONParser();
        try {
            obj = parser.parse(msg);
        }
        catch (ParseException ex) {
            this.logger.warn((Object)("Malformed JSON received from endpoint " + this.getId()), (Throwable)ex);
            obj = null;
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            String colibriClass = (String)jsonObject.get((Object)"colibriClass");
            if (colibriClass != null) {
                this.onJSONData(src, jsonObject, colibriClass);
            } else {
                this.logger.warn((Object)("Malformed JSON received from endpoint " + this.getId() + ". JSON object does not contain the colibriClass field."));
            }
        }
    }

    protected void sendMessage(String msg) throws IOException {
    }

    protected void close() {
    }
}

