/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.octo;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingDatagramSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.jitsi.impl.neomedia.transform.NullSrtpControl;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.StringUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.octo.OctoChannel;
import org.jitsi.videobridge.octo.OctoPacket;
import org.jitsi.videobridge.octo.OctoRelay;
import org.jitsi.videobridge.octo.OctoRelayService;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.osgi.framework.BundleContext;

public class OctoTransportManager
extends TransportManager {
    private static final Logger classLogger = Logger.getLogger(OctoTransportManager.class);
    public static final String NAMESPACE = "http://jitsi.org/octo";
    private static final int SO_TIMEOUT = 1000;
    private OctoChannel channel;
    private OctoRelay octoRelay;
    private DatagramSocket rtpSocket;
    private DatagramSocket rtcpSocket;
    private final SrtpControl srtpControl = new NullSrtpControl();
    private List<SocketAddress> remoteRelays;
    private final Logger logger;
    private final Object socketsSyncRoot = new Object();

    private static SocketAddress relayIdToSocketAddress(String relayId) {
        if (relayId == null || !relayId.contains(":")) {
            return null;
        }
        try {
            String[] addressAndPort = relayId.split(":");
            return new InetSocketAddress(addressAndPort[0], (int)Integer.valueOf(addressAndPort[1]));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public OctoTransportManager(Channel channel) {
        if (!(channel instanceof OctoChannel)) {
            throw new IllegalArgumentException("channel is not an OctoChannel");
        }
        this.channel = (OctoChannel)channel;
        this.logger = Logger.getLogger((Logger)classLogger, (Logger)channel.getContent().getConference().getLogger());
        OctoRelayService relayService = (OctoRelayService)ServiceUtils.getService((BundleContext)channel.getBundleContext(), OctoRelayService.class);
        this.octoRelay = Objects.requireNonNull(relayService.getRelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            if (this.rtpSocket != null) {
                this.rtpSocket.close();
            }
            if (this.rtcpSocket != null) {
                this.rtcpSocket.close();
            }
        }
    }

    @Override
    public StreamConnector getStreamConnector(Channel channel) {
        try {
            this.initializeSockets();
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Failed to initialize sockets: ", (Throwable)ioe);
            return null;
        }
        return new DefaultStreamConnector(this.rtpSocket, this.rtcpSocket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSockets() throws IOException {
        Object object = this.socketsSyncRoot;
        synchronized (object) {
            if (this.rtpSocket != null) {
                return;
            }
            MultiplexingDatagramSocket relaySocket = this.octoRelay.getSocket();
            this.rtpSocket = this.createOctoSocket((DatagramSocket)relaySocket.getSocket((DatagramPacketFilter)this.channel.getDatagramFilter(false)));
            this.rtcpSocket = this.createOctoSocket((DatagramSocket)relaySocket.getSocket((DatagramPacketFilter)this.channel.getDatagramFilter(true)));
        }
    }

    private DatagramSocket createOctoSocket(DatagramSocket socket) throws SocketException {
        DelegatingDatagramSocket s = new DelegatingDatagramSocket(socket){

            public void receive(DatagramPacket p) throws IOException {
                super.receive(p);
                try {
                    p.setData(p.getData(), p.getOffset() + 8, p.getLength() - 8);
                }
                catch (Exception e) {
                    OctoTransportManager.this.logger.error((Object)("Failed to strip Octo header while receiving a packet:" + e));
                }
            }

            public void send(DatagramPacket p) throws IOException {
                OctoTransportManager.this.doSend(p, true);
            }
        };
        s.setSoTimeout(1000);
        return s;
    }

    @Override
    public MediaStreamTarget getStreamTarget(Channel channel) {
        MultiplexingDatagramSocket socket = this.octoRelay.getSocket();
        InetAddress inetAddress = socket.getLocalAddress();
        int port = socket.getLocalPort();
        return new MediaStreamTarget(inetAddress, port, inetAddress, port);
    }

    @Override
    protected void describe(IceUdpTransportPacketExtension pe) {
    }

    @Override
    public SrtpControl getSrtpControl(Channel channel) {
        return this.srtpControl;
    }

    @Override
    public String getXmlNamespace() {
        return NAMESPACE;
    }

    @Override
    public void startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public void setRelayIds(List<String> relayIds) {
        ArrayList<SocketAddress> remoteRelays = new ArrayList<SocketAddress>(relayIds.size());
        for (String relayId : relayIds) {
            SocketAddress socketAddress = OctoTransportManager.relayIdToSocketAddress(relayId);
            if (socketAddress == null) {
                this.logger.error((Object)("Could not convert a relay ID to a socket address: " + relayId));
                continue;
            }
            if (remoteRelays.contains(socketAddress)) {
                this.logger.info((Object)("Relay ID duplicate: " + relayId));
                continue;
            }
            remoteRelays.add(socketAddress);
        }
        this.remoteRelays = remoteRelays;
    }

    private void doSend(DatagramPacket p, boolean addHeaders) throws IOException {
        if (addHeaders) {
            p = this.addOctoHeaders(p);
        }
        MultiplexingDatagramSocket relaySocket = this.octoRelay.getSocket();
        IOException exception = null;
        int exceptions = 0;
        if (this.remoteRelays != null) {
            for (SocketAddress remoteAddress : this.remoteRelays) {
                try {
                    p.setSocketAddress(remoteAddress);
                    relaySocket.send(p);
                }
                catch (IOException ioe) {
                    ++exceptions;
                    exception = ioe;
                }
            }
        }
        if (exception != null) {
            this.logger.warn((Object)("Caught " + exceptions + " while trying to send a packet."));
            throw exception;
        }
    }

    private DatagramPacket addOctoHeaders(DatagramPacket p) {
        byte[] buf = p.getData();
        int off = p.getOffset();
        int len = p.getLength();
        if (off >= 8) {
            off -= 8;
        } else if (buf.length >= len + 8) {
            System.arraycopy(buf, off, buf, 8, len);
            off = 0;
        } else {
            byte[] newBuf = new byte[len + 8];
            System.arraycopy(buf, off, newBuf, 8, len);
            buf = newBuf;
            off = 0;
        }
        p.setData(buf, off, len += 8);
        OctoPacket.writeHeaders(buf, off, true, this.channel.getMediaType(), 0, this.channel.getConferenceId(), "ffffffff");
        return p;
    }

    void sendMessage(String msg, String sourceEndpointId, String conferenceId) {
        if (StringUtils.isNullOrEmpty((String)sourceEndpointId)) {
            sourceEndpointId = "ffffffff";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending a message through Octo: " + msg));
        }
        byte[] msgBytes = msg.getBytes(StandardCharsets.UTF_8);
        byte[] buf = new byte[msgBytes.length + 8];
        System.arraycopy(msgBytes, 0, buf, 8, msgBytes.length);
        OctoPacket.writeHeaders(buf, 0, true, MediaType.DATA, 0, conferenceId, sourceEndpointId);
        try {
            this.doSend(new DatagramPacket(buf, 0, buf.length), false);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Failed to send Octo data message: ", (Throwable)ioe);
        }
    }
}

