/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.util;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import org.jitsi.utils.logging.Logger;
import org.jitsi.videobridge.util.Expireable;

public class ExpireableImpl
implements Expireable {
    private static final Logger logger = Logger.getLogger(ExpireableImpl.class);
    private WeakReference<Thread> expireThread = null;
    private long expireStarted = -1L;
    private final Object syncRoot = new Object();
    private final String name;
    private final Runnable expireRunnable;

    private static String getStackTraceAsString(Thread thread) {
        if (thread == null) {
            return "null";
        }
        return Arrays.stream(thread.getStackTrace()).map(StackTraceElement::toString).reduce((s, str) -> s.concat(" -> ").concat((String)str)).orElse("empty");
    }

    public ExpireableImpl(String name, Runnable expireRunnable) {
        this.name = name;
        this.expireRunnable = Objects.requireNonNull(expireRunnable);
    }

    @Override
    public boolean shouldExpire() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void safeExpire() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Expiring " + this.name));
            }
            long now = System.currentTimeMillis();
            if (this.expireStarted > 0L) {
                long duration = now - this.expireStarted;
                if (duration > 1000L || logger.isDebugEnabled()) {
                    Thread expireThread = this.expireThread == null ? null : (Thread)this.expireThread.get();
                    logger.warn((Object)("A thread has been running safeExpire() on " + this.name + "for " + duration + "ms: " + ExpireableImpl.getStackTraceAsString(expireThread)));
                }
                return;
            }
            this.expireStarted = now;
            this.expireThread = new WeakReference<Thread>(Thread.currentThread());
        }
        try {
            this.expireRunnable.run();
        }
        catch (Throwable t) {
            logger.error((Object)("Failed to expire " + this.name), t);
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Expired " + this.name));
            }
            object = this.syncRoot;
            synchronized (object) {
                this.expireStarted = -1L;
                this.expireThread = null;
            }
        }
    }
}

